/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.Strictness;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorTransformer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelType;
import qupath.lib.io.GsonTools;

public class ColorTransforms {
    private ColorTransforms() {
        throw new AssertionError((Object)"This class is not instantiable.");
    }

    public static ColorTransform createChannelExtractor(int channel) {
        return new ExtractChannel(channel);
    }

    public static ColorTransform createChannelExtractor(String channelName) {
        return new ExtractChannelByName(channelName);
    }

    public static ColorTransform createLinearCombinationChannelTransform(Map<String, ? extends Number> coefficients) {
        return new LinearCombinationChannel(coefficients);
    }

    public static ColorTransform createLinearCombinationChannelTransform(List<? extends Number> coefficients) {
        return new LinearCombinationChannel(coefficients);
    }

    public static ColorTransform createLinearCombinationChannelTransform(double ... coefficients) {
        return ColorTransforms.createLinearCombinationChannelTransform(Arrays.stream(coefficients).boxed().toList());
    }

    public static ColorTransform createMeanChannelTransform() {
        return new AverageChannels();
    }

    public static ColorTransform createMaximumChannelTransform() {
        return new MaxChannels();
    }

    public static ColorTransform createMinimumChannelTransform() {
        return new MinChannels();
    }

    public static ColorTransform createColorDeconvolvedChannel(ColorDeconvolutionStains stains, int stainNumber) {
        return new ColorDeconvolvedChannel(stains, stainNumber);
    }

    private static float[] ensureArrayLength(BufferedImage img, float[] pixels) {
        int n = img.getWidth() * img.getHeight();
        if (pixels == null || pixels.length < n) {
            return new float[n];
        }
        return pixels;
    }

    static class ExtractChannel
    implements ColorTransform {
        private final int channel;

        public ExtractChannel(int channel) {
            this.channel = channel;
        }

        @Override
        public float[] extractChannel(ImageServer<BufferedImage> server, BufferedImage img, float[] pixels) {
            pixels = ColorTransforms.ensureArrayLength(img, pixels);
            return img.getRaster().getSamples(0, 0, img.getWidth(), img.getHeight(), this.channel, pixels);
        }

        @Override
        public String getName() {
            return "Channel " + (this.channel + 1);
        }

        @Override
        public boolean supportsImage(ImageServer<BufferedImage> server) {
            return this.channel < server.nChannels();
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.channel;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExtractChannel)) {
                return false;
            }
            ExtractChannel extractChannel = (ExtractChannel)obj;
            return this.channel == extractChannel.channel;
        }

        public int getChannelNumber() {
            return this.channel;
        }
    }

    static class ExtractChannelByName
    implements ColorTransform {
        private final String channelName;

        public ExtractChannelByName(String channel) {
            this.channelName = channel;
        }

        @Override
        public float[] extractChannel(ImageServer<BufferedImage> server, BufferedImage img, float[] pixels) {
            pixels = ColorTransforms.ensureArrayLength(img, pixels);
            int c = this.getChannelNumber(server);
            if (c >= 0) {
                return img.getRaster().getSamples(0, 0, img.getWidth(), img.getHeight(), c, pixels);
            }
            throw new IllegalArgumentException("No channel found with name " + this.channelName);
        }

        @Override
        public String getName() {
            return this.channelName;
        }

        @Override
        public boolean supportsImage(ImageServer<BufferedImage> server) {
            return this.getChannelNumber(server) >= 0;
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.channelName == null ? 0 : this.channelName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExtractChannelByName)) {
                return false;
            }
            ExtractChannelByName extractChannel = (ExtractChannelByName)obj;
            return Objects.equals(this.channelName, extractChannel.channelName);
        }

        public String getChannelName() {
            return this.channelName;
        }

        private int getChannelNumber(ImageServer<BufferedImage> server) {
            int i = 0;
            for (ImageChannel channel : server.getMetadata().getChannels()) {
                if (channel.getName().equals(this.channelName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    static class LinearCombinationChannel
    implements ColorTransform {
        private final Map<String, Double> channelNamesToCoefficients;
        private final List<Double> channelIndicesToCoefficients;
        private transient String name;

        private LinearCombinationChannel(Map<String, Double> channelNamesToCoefficients, List<Double> channelIndicesToCoefficients) {
            this.channelNamesToCoefficients = channelNamesToCoefficients;
            this.channelIndicesToCoefficients = channelIndicesToCoefficients;
        }

        public LinearCombinationChannel(Map<String, ? extends Number> coefficients) {
            this(coefficients.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Number)entry.getValue()).doubleValue())), null);
        }

        public LinearCombinationChannel(List<? extends Number> coefficients) {
            this(null, coefficients.stream().map(Number::doubleValue).toList());
        }

        @Override
        public float[] extractChannel(ImageServer<BufferedImage> server, BufferedImage img, float[] pixels) {
            pixels = ColorTransforms.ensureArrayLength(img, pixels);
            int w = img.getWidth();
            int h = img.getHeight();
            WritableRaster raster = img.getRaster();
            double[] coefficients = this.getCoefficients(server);
            double[] values = null;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    values = raster.getPixel(x, y, values);
                    double result = 0.0;
                    for (int i = 0; i < values.length; ++i) {
                        result += values[i] * coefficients[i];
                    }
                    pixels[y * w + x] = (float)result;
                }
            }
            return pixels;
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.name = this.channelNamesToCoefficients != null ? this.channelNamesToCoefficients.entrySet().stream().map(entry -> String.valueOf(entry.getValue()) + "*" + (String)entry.getKey()).collect(Collectors.joining(" + ")) : (this.channelIndicesToCoefficients != null ? IntStream.range(0, this.channelIndicesToCoefficients.size()).mapToObj(i -> String.valueOf(this.channelIndicesToCoefficients.get(i)) + "*channel" + i).collect(Collectors.joining(" + ")) : "Linear combination channels");
            }
            return this.name;
        }

        @Override
        public boolean supportsImage(ImageServer<BufferedImage> server) {
            if (this.channelNamesToCoefficients != null) {
                return server.getMetadata().getChannels().stream().map(ImageChannel::getName).collect(Collectors.toSet()).containsAll(this.channelNamesToCoefficients.keySet());
            }
            if (this.channelIndicesToCoefficients != null) {
                return server.nChannels() >= this.channelIndicesToCoefficients.size();
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.channelNamesToCoefficients == null ? 0 : this.channelNamesToCoefficients.hashCode());
            result = 31 * result + (this.channelIndicesToCoefficients == null ? 0 : this.channelIndicesToCoefficients.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LinearCombinationChannel)) {
                return false;
            }
            LinearCombinationChannel linearCombinationChannel = (LinearCombinationChannel)obj;
            return Objects.equals(this.channelNamesToCoefficients, linearCombinationChannel.channelNamesToCoefficients) && Objects.equals(this.channelIndicesToCoefficients, linearCombinationChannel.channelIndicesToCoefficients);
        }

        private double[] getCoefficients(ImageServer<BufferedImage> server) {
            double[] coefficients;
            block3: {
                block2: {
                    coefficients = new double[server.nChannels()];
                    if (this.channelNamesToCoefficients == null) break block2;
                    for (int i = 0; i < server.nChannels(); ++i) {
                        coefficients[i] = this.channelNamesToCoefficients.getOrDefault(server.getChannel(i).getName(), 0.0);
                    }
                    break block3;
                }
                if (this.channelIndicesToCoefficients == null) break block3;
                for (int i = 0; i < this.channelIndicesToCoefficients.size(); ++i) {
                    coefficients[i] = this.channelIndicesToCoefficients.get(i);
                }
            }
            return coefficients;
        }
    }

    public static interface ColorTransform {
        public float[] extractChannel(ImageServer<BufferedImage> var1, BufferedImage var2, float[] var3);

        public boolean supportsImage(ImageServer<BufferedImage> var1);

        public String getName();
    }

    static class AverageChannels
    extends CombineChannels {
        private final CombineType combineType = CombineType.MEAN;

        AverageChannels() {
        }

        @Override
        public double computeValue(double[] values) {
            return Arrays.stream(values).average().orElse(Double.NaN);
        }

        @Override
        public String getName() {
            return "Average channels";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.combineType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof AverageChannels;
        }
    }

    static class MaxChannels
    extends CombineChannels {
        private final CombineType combineType = CombineType.MAXIMUM;

        MaxChannels() {
        }

        @Override
        public double computeValue(double[] values) {
            return Arrays.stream(values).max().orElse(Double.NaN);
        }

        @Override
        public String getName() {
            return "Max channels";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.combineType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof MaxChannels;
        }
    }

    static class MinChannels
    extends CombineChannels {
        private final CombineType combineType = CombineType.MINIMUM;

        MinChannels() {
        }

        @Override
        public double computeValue(double[] values) {
            return Arrays.stream(values).min().orElse(Double.NaN);
        }

        @Override
        public String getName() {
            return "Min channels";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.combineType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof MinChannels;
        }
    }

    static class ColorDeconvolvedChannel
    implements ColorTransform {
        private final ColorDeconvolutionStains stains;
        private final int stainNumber;
        private final transient ColorTransformer.ColorTransformMethod method;

        public ColorDeconvolvedChannel(ColorDeconvolutionStains stains, int stainNumber) {
            this.stains = stains;
            this.stainNumber = stainNumber;
            this.method = switch (stainNumber) {
                case 1 -> ColorTransformer.ColorTransformMethod.Stain_1;
                case 2 -> ColorTransformer.ColorTransformMethod.Stain_2;
                case 3 -> ColorTransformer.ColorTransformMethod.Stain_3;
                default -> throw new IllegalArgumentException("Stain number is " + stainNumber + ", but must be between 1 and 3!");
            };
        }

        @Override
        public float[] extractChannel(ImageServer<BufferedImage> server, BufferedImage img, float[] pixels) {
            int[] rgb = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
            return ColorTransformer.getTransformedPixels(rgb, this.method, pixels, this.stains);
        }

        @Override
        public boolean supportsImage(ImageServer<BufferedImage> server) {
            return server.isRGB() && server.getPixelType() == PixelType.UINT8;
        }

        @Override
        public String getName() {
            return this.stains == null ? null : this.stains.getStain(this.stainNumber).getName();
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.stainNumber;
            result = 31 * result + (this.stains == null ? 0 : this.stains.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ColorDeconvolvedChannel)) {
                return false;
            }
            ColorDeconvolvedChannel colorDeconvolvedChannel = (ColorDeconvolvedChannel)obj;
            return Objects.equals(this.stains, colorDeconvolvedChannel.stains) && this.stainNumber == colorDeconvolvedChannel.stainNumber;
        }
    }

    private static enum CombineType {
        MEAN,
        MINIMUM,
        MAXIMUM;

    }

    static abstract class CombineChannels
    implements ColorTransform {
        CombineChannels() {
        }

        @Override
        public float[] extractChannel(ImageServer<BufferedImage> server, BufferedImage img, float[] pixels) {
            pixels = ColorTransforms.ensureArrayLength(img, pixels);
            int w = img.getWidth();
            int h = img.getHeight();
            WritableRaster raster = img.getRaster();
            double[] vals = null;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    vals = raster.getPixel(x, y, vals);
                    pixels[y * w + x] = (float)this.computeValue(vals);
                }
            }
            return pixels;
        }

        abstract double computeValue(double[] var1);

        @Override
        public boolean supportsImage(ImageServer<BufferedImage> server) {
            return true;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class ColorTransformTypeAdapter
    extends TypeAdapter<ColorTransform> {
        private static final Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).create();

        public void write(JsonWriter out, ColorTransform value) throws IOException {
            gson.toJson(gson.toJsonTree((Object)value), out);
        }

        public ColorTransform read(JsonReader in) throws IOException {
            JsonObject obj = (JsonObject)gson.fromJson(in, JsonObject.class);
            if (obj.has("channel")) {
                return new ExtractChannel(obj.get("channel").getAsInt());
            }
            if (obj.has("channelName")) {
                return new ExtractChannelByName(obj.get("channelName").getAsString());
            }
            if (obj.has("channelNamesToCoefficients") || obj.has("channelIndicesToCoefficients")) {
                Map channelNamesToCoefficients = null;
                List<Double> channelIndicesToCoefficients = null;
                if (obj.get("channelNamesToCoefficients") != null) {
                    channelNamesToCoefficients = (Map)gson.fromJson(obj.get("channelNamesToCoefficients"), new TypeToken<Map<String, Double>>(this){}.getType());
                }
                if (obj.get("channelIndicesToCoefficients") != null) {
                    channelIndicesToCoefficients = obj.get("channelIndicesToCoefficients").getAsJsonArray().asList().stream().map(JsonElement::getAsDouble).toList();
                }
                return new LinearCombinationChannel(channelNamesToCoefficients, channelIndicesToCoefficients);
            }
            if (obj.has("stains")) {
                return new ColorDeconvolvedChannel((ColorDeconvolutionStains)GsonTools.getInstance().fromJson(obj.get("stains"), ColorDeconvolutionStains.class), obj.get("stainNumber").getAsInt());
            }
            if (obj.has("combineType")) {
                return switch (CombineType.valueOf(obj.get("combineType").getAsString()).ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> new AverageChannels();
                    case 2 -> new MaxChannels();
                    case 1 -> new MinChannels();
                };
            }
            throw new IOException("Unknown ColorTransform " + String.valueOf(obj));
        }
    }
}

