/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.regions.RegionRequest;

class ConcatChannelsImageServer
extends TransformingImageServer<BufferedImage> {
    private ImageServerMetadata originalMetadata;
    private List<ImageServer<BufferedImage>> allServers = new ArrayList<ImageServer<BufferedImage>>();

    ConcatChannelsImageServer(ImageServer<BufferedImage> server, Collection<ImageServer<BufferedImage>> imageServers) {
        super(server);
        this.allServers.addAll(imageServers);
        ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>();
        for (ImageServer<BufferedImage> s : this.allServers) {
            channels.addAll(s.getMetadata().getChannels());
        }
        this.originalMetadata = new ImageServerMetadata.Builder(server.getMetadata()).rgb(server.getMetadata().isRGB() && this.allServers.size() == 1).channels(channels).build();
    }

    @Override
    protected String createID() {
        StringBuilder sb = new StringBuilder();
        for (ImageServer<BufferedImage> server : this.allServers) {
            if (sb.length() == 0) {
                sb.append(", ");
            }
            sb.append(server.getPath());
        }
        return this.getClass().getName() + ": [" + String.valueOf(sb) + "]";
    }

    @Override
    public String getServerType() {
        return "Channel concat image server";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    public List<ImageServer<BufferedImage>> getAllServers() {
        return Collections.unmodifiableList(this.allServers);
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        WritableRaster raster;
        ArrayList<WritableRaster> rasters = new ArrayList<WritableRaster>();
        boolean premultiplied = false;
        int nBands = 0;
        for (ImageServer<BufferedImage> server : this.allServers) {
            BufferedImage img = server.readRegion(request);
            if (img == null) {
                rasters.add(null);
                nBands += server.nChannels();
                continue;
            }
            premultiplied = img.isAlphaPremultiplied();
            nBands += img.getRaster().getNumBands();
            rasters.add(img.getRaster());
        }
        WritableRaster first = rasters.stream().filter(r -> r != null).findFirst().orElse(null);
        if (first == null) {
            return null;
        }
        int width = first.getWidth();
        int height = first.getHeight();
        if (first.getDataBuffer().getDataType() != 0 && first.getDataBuffer().getDataType() != 1) {
            BandedSampleModel sampleModel = new BandedSampleModel(4, width, height, nBands);
            raster = WritableRaster.createWritableRaster(sampleModel, null);
        } else {
            raster = WritableRaster.createInterleavedRaster(first.getDataBuffer().getDataType(), width, height, nBands, null);
        }
        float[] samples = new float[width * height];
        int currentBand = 0;
        for (WritableRaster temp : rasters) {
            if (temp == null) continue;
            int w = Math.min(width, temp.getWidth());
            int h = Math.min(height, temp.getHeight());
            for (int b = 0; b < temp.getNumBands(); ++b) {
                samples = temp.getSamples(0, 0, w, h, b, samples);
                raster.setSamples(0, 0, w, h, currentBand, samples);
                ++currentBand;
            }
        }
        return new BufferedImage(ColorModelFactory.getDummyColorModel(this.getPixelType().getBitsPerPixel()), raster, premultiplied, null);
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.ConcatChannelsImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.allServers.stream().map(s -> s.getBuilder()).toList());
    }
}

