/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.plugins.tiff.TIFFDirectory;
import javax.imageio.plugins.tiff.TIFFField;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;

public class FileFormatInfo {
    private static final Logger logger = LoggerFactory.getLogger(FileFormatInfo.class);
    private static Map<URI, ImageCheckType> cache = new HashMap<URI, ImageCheckType>();

    public static synchronized ImageCheckType checkType(URI uri) {
        ImageCheckType check = cache.get(uri);
        if (check == null) {
            check = FileFormatInfo.checkImageType(uri);
            cache.put(uri, check);
        }
        return check;
    }

    static boolean maybeRGB(ImageTypeSpecifier specifier) {
        int nBands = specifier.getNumBands();
        if (nBands < 3 || nBands > 4) {
            return false;
        }
        for (int i = 0; i < nBands; ++i) {
            if (specifier.getBitsPerBand(i) == 8) continue;
            return false;
        }
        return true;
    }

    static ImageCheckType checkImageType(URI uri) {
        return new DefaultFormatInfo(uri);
    }

    static int readShort(RandomAccessFile in, boolean littleEndian) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        if (littleEndian) {
            return (b2 << 8) + b1;
        }
        return (b1 << 8) + b2;
    }

    public static interface ImageCheckType {
        public boolean isURL();

        public boolean isTiff();

        public boolean isBigTiff();

        public String getDescription();

        public File getFile();

        public int nImages();

        public int nImagesLargest();

        public boolean isNotRGB();

        public long getLargestImageWidth();

        public long getLargestImageHeight();
    }

    static class DefaultFormatInfo
    implements ImageCheckType {
        private static int MAX_IMAGES = 100;
        private boolean isURL;
        private File file;
        private boolean isTiff;
        private boolean isBigTiff;
        private boolean notRGB;
        private int nImages;
        private int nImagesLargest;
        private String description;
        private long largestImageWidth;
        private long largestImageHeight;

        DefaultFormatInfo(URI uri) {
            block32: {
                this.isURL = false;
                this.file = null;
                this.isTiff = false;
                this.isBigTiff = false;
                this.notRGB = false;
                this.nImages = -1;
                this.nImagesLargest = -1;
                this.largestImageWidth = -1L;
                this.largestImageHeight = -1L;
                String scheme = uri.getScheme();
                if (scheme != null && scheme.startsWith("http")) {
                    this.isURL = true;
                    return;
                }
                Path path = GeneralTools.toPath(uri);
                if (!Files.exists(path, new LinkOption[0])) {
                    return;
                }
                File file = path.toFile();
                if (!file.isFile()) {
                    return;
                }
                this.file = file;
                try {
                    block31: {
                        try (RandomAccessFile in = new RandomAccessFile(file, "r");){
                            boolean littleEndian;
                            short byteOrder = in.readShort();
                            if (byteOrder == 18761) {
                                littleEndian = true;
                            } else if (byteOrder == 19789) {
                                littleEndian = false;
                            } else {
                                in.close();
                                return;
                            }
                            int special = FileFormatInfo.readShort(in, littleEndian);
                            if (special == 42) {
                                this.isTiff = true;
                                break block31;
                            }
                            if (special == 43) {
                                this.isTiff = true;
                                this.isBigTiff = true;
                                break block31;
                            }
                            return;
                        }
                    }
                    try (ImageInputStream stream = ImageIO.createImageInputStream(file);){
                        int i;
                        int nTestImages;
                        Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                        if (!readers.hasNext()) {
                            logger.debug("ImageIO could not construct reader for {}", (Object)file);
                            return;
                        }
                        ImageReader reader = readers.next();
                        reader.setInput(stream);
                        TIFFDirectory tiffDir = TIFFDirectory.createFromMetadata(reader.getImageMetadata(0));
                        TIFFField tempDescription = tiffDir.getTIFFField(270);
                        this.description = tempDescription == null ? null : tempDescription.getAsString(0);
                        this.nImages = reader.getNumImages(false);
                        int n = nTestImages = this.nImages >= 0 ? this.nImages : MAX_IMAGES;
                        if (nTestImages <= 0) break block32;
                        try {
                            int largestCount = 0;
                            long maxNumPixels = 0L;
                            boolean largestMaybeRGB = false;
                            for (i = 0; i < nTestImages; ++i) {
                                long width = reader.getWidth(i);
                                long height = reader.getHeight(i);
                                long nPixels = width * height;
                                ImageTypeSpecifier specifier = reader.getRawImageType(i);
                                if (nPixels > maxNumPixels) {
                                    maxNumPixels = nPixels;
                                    largestCount = 1;
                                    largestMaybeRGB = FileFormatInfo.maybeRGB(specifier);
                                    this.largestImageWidth = width;
                                    this.largestImageHeight = height;
                                } else if (width == this.largestImageWidth && height == this.largestImageHeight) {
                                    ++largestCount;
                                    largestMaybeRGB = largestMaybeRGB && FileFormatInfo.maybeRGB(specifier);
                                }
                                this.nImagesLargest = largestCount;
                                this.notRGB = !largestMaybeRGB;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.nImages = i - 1;
                            logger.debug("Checked first {} images only of {}", (Object)(i - 1), (Object)uri);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("Unable to obtain full image format info for {} ({})", (Object)uri, e.getLocalizedMessage() == null ? e.getClass() : e.getLocalizedMessage());
                    logger.debug("Format info error", (Throwable)e);
                }
            }
        }

        @Override
        public boolean isURL() {
            return this.isURL;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isTiff() {
            return this.isTiff;
        }

        @Override
        public boolean isBigTiff() {
            return this.isBigTiff;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public int nImages() {
            return this.nImages;
        }

        @Override
        public int nImagesLargest() {
            return this.nImagesLargest;
        }

        @Override
        public boolean isNotRGB() {
            return this.notRGB;
        }

        @Override
        public long getLargestImageWidth() {
            return this.largestImageWidth;
        }

        @Override
        public long getLargestImageHeight() {
            return this.largestImageHeight;
        }

        public String toString() {
            return "DefaultFormatInfo [isURL=" + this.isURL + ", file=" + String.valueOf(this.file) + ", isTiff=" + this.isTiff + ", isBigTiff=" + this.isBigTiff + ", notRGB=" + this.notRGB + ", nImages=" + this.nImages + ", nImagesLargest=" + this.nImagesLargest + ", description=" + Boolean.toString(this.description != null) + "]";
        }
    }
}

