/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.images.servers.TileRequestManager;
import qupath.lib.regions.RegionRequest;

public interface ImageServer<T>
extends AutoCloseable {
    public String getPath();

    public Collection<URI> getURIs();

    public double[] getPreferredDownsamples();

    public int nResolutions();

    public double getDownsampleForResolution(int var1);

    public int getWidth();

    public int getHeight();

    public int nChannels();

    public boolean isRGB();

    public int nZSlices();

    public int nTimepoints();

    default public PixelCalibration getPixelCalibration() {
        return this.getMetadata().getPixelCalibration();
    }

    public T getCachedTile(TileRequest var1);

    @Deprecated
    default public T readBufferedImage(RegionRequest request) throws IOException {
        ImageServers.logFirstDeprecatedReadCall(this.getClass());
        return this.readRegion(request);
    }

    default public T readRegion(RegionRequest request) throws IOException {
        try {
            Method m = this.getClass().getMethod("readBufferedImage", RegionRequest.class);
            if (m != null && !Objects.equals(ImageServer.class, m.getDeclaringClass())) {
                ImageServers.logFirstDeprecatedReadCall(this.getClass());
                return (T)m.invoke((Object)this, request);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).debug(e.getLocalizedMessage(), (Throwable)e);
        }
        throw new UnsupportedOperationException("readRegion is not implemented!");
    }

    default public T readRegion(double downsample, int x, int y, int width, int height, int z, int t) throws IOException {
        return this.readRegion(RegionRequest.createInstance(this.getPath(), downsample, x, y, width, height, z, t));
    }

    default public T readRegion(double downsample, int x, int y, int width, int height) throws IOException {
        return this.readRegion(downsample, x, y, width, height, 0, 0);
    }

    public String getServerType();

    public List<String> getAssociatedImageList();

    public T getAssociatedImage(String var1);

    public boolean isEmptyRegion(RegionRequest var1);

    public PixelType getPixelType();

    public ImageChannel getChannel(int var1);

    public ImageServerMetadata getMetadata();

    public void setMetadata(ImageServerMetadata var1) throws IllegalArgumentException;

    public ImageServerMetadata getOriginalMetadata();

    public T getDefaultThumbnail(int var1, int var2) throws IOException;

    public TileRequestManager getTileRequestManager();

    public Class<T> getImageClass();

    default public ImageServerBuilder.ServerBuilder<T> getBuilder() {
        return null;
    }
}

