/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.PixelType;
import qupath.lib.objects.classes.PathClass;

public class ImageServerMetadata {
    private static Logger logger = LoggerFactory.getLogger(ImageServerMetadata.class);
    public static final ImageChannel DEFAULT_CLASSIFICATION_LABELS_CHANNEL = ImageChannel.getInstance("Labels", ColorTools.packRGB(255, 255, 255));
    private static int DEFAULT_TILE_SIZE = 256;
    private String name;
    private int width;
    private int height;
    private int sizeZ = 1;
    private int sizeT = 1;
    private ChannelType channelType = ChannelType.DEFAULT;
    private boolean isRGB = false;
    private PixelType pixelType = PixelType.UINT8;
    private ImageResolutionLevel[] levels;
    private Map<Integer, PathClass> classificationLabels;
    private List<ImageChannel> channels = new ArrayList<ImageChannel>();
    private Number minValue;
    private Number maxValue;
    private PixelCalibration pixelCalibration;
    private Double magnification = null;
    private int preferredTileWidth;
    private int preferredTileHeight;
    private transient List<ImageResolutionLevel> unmodifiableLevels;
    private transient double[] downsamples;

    ImageServerMetadata() {
    }

    ImageServerMetadata(String path) {
    }

    ImageServerMetadata(ImageServerMetadata metadata) {
        this.name = metadata.name;
        this.levels = metadata.levels == null || metadata.levels.length == 0 ? (ImageResolutionLevel[])new ImageResolutionLevel.Builder(metadata.width, metadata.height).addFullResolutionLevel().build().toArray(ImageResolutionLevel[]::new) : (ImageResolutionLevel[])metadata.levels.clone();
        this.width = metadata.width;
        this.height = metadata.height;
        this.sizeZ = metadata.sizeZ;
        this.sizeT = metadata.sizeT;
        this.isRGB = metadata.isRGB;
        this.pixelType = metadata.pixelType;
        this.pixelCalibration = metadata.pixelCalibration;
        if (metadata.classificationLabels != null) {
            this.classificationLabels = Collections.unmodifiableMap(new LinkedHashMap<Integer, PathClass>(metadata.classificationLabels));
        } else if (metadata.channelType == ChannelType.CLASSIFICATION) {
            throw new IllegalArgumentException("Classification labels are required whenever the channel type is CLASSIFICATION!");
        }
        this.channels = new ArrayList<ImageChannel>(metadata.getChannels());
        this.magnification = metadata.magnification;
        this.minValue = metadata.minValue;
        this.maxValue = metadata.maxValue;
        this.channelType = metadata.channelType;
        this.preferredTileWidth = metadata.preferredTileWidth;
        this.preferredTileHeight = metadata.preferredTileHeight;
    }

    public double[] getPreferredDownsamplesArray() {
        if (this.downsamples == null) {
            double[] temp = new double[this.nLevels()];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = this.getDownsampleForLevel(i);
            }
            this.downsamples = temp;
        }
        return (double[])this.downsamples.clone();
    }

    public List<ImageResolutionLevel> getLevels() {
        if (this.unmodifiableLevels == null) {
            this.unmodifiableLevels = Collections.unmodifiableList(Arrays.asList(this.levels));
        }
        return this.unmodifiableLevels;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int nLevels() {
        return this.levels.length;
    }

    public PixelCalibration getPixelCalibration() {
        return this.pixelCalibration;
    }

    public double getDownsampleForLevel(int level) {
        return this.levels[level].getDownsample();
    }

    public ImageResolutionLevel getLevel(int level) {
        return this.levels[level];
    }

    public boolean isRGB() {
        return this.isRGB;
    }

    public PixelType getPixelType() {
        return this.pixelType;
    }

    public Number getMinValue() {
        return this.minValue == null ? (Number)this.getPixelType().getLowerBound() : (Number)this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue == null ? (Number)this.getPixelType().getUpperBound() : (Number)this.maxValue;
    }

    public boolean pixelSizeCalibrated() {
        return this.pixelCalibration.hasPixelSizeMicrons();
    }

    public boolean zSpacingCalibrated() {
        return this.pixelCalibration.hasZSpacingMicrons();
    }

    public double getAveragedPixelSize() {
        return (this.getPixelWidthMicrons() + this.getPixelHeightMicrons()) / 2.0;
    }

    public double getPixelWidthMicrons() {
        return this.pixelCalibration.getPixelWidthMicrons();
    }

    public double getPixelHeightMicrons() {
        return this.pixelCalibration.getPixelHeightMicrons();
    }

    public double getZSpacingMicrons() {
        return this.pixelCalibration.getZSpacingMicrons();
    }

    public TimeUnit getTimeUnit() {
        return this.pixelCalibration.getTimeUnit();
    }

    public double getTimepoint(int ind) {
        return this.pixelCalibration.getTimepoint(ind);
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public int getSizeT() {
        return this.sizeT;
    }

    public int getSizeC() {
        return this.channels.size();
    }

    public double getMagnification() {
        return this.magnification == null ? Double.NaN : this.magnification;
    }

    public int getPreferredTileWidth() {
        return this.preferredTileWidth;
    }

    public int getPreferredTileHeight() {
        return this.preferredTileHeight;
    }

    public ImageServerMetadata duplicate() {
        return new ImageServerMetadata(this);
    }

    public String getName() {
        return this.name;
    }

    public ImageChannel getChannel(int n) {
        return this.channels.get(n);
    }

    public List<ImageChannel> getChannels() {
        return this.channels;
    }

    public Map<Integer, PathClass> getClassificationLabels() {
        return this.classificationLabels == null ? Collections.emptyMap() : this.classificationLabels;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public boolean isCompatibleMetadata(ImageServerMetadata metadata) {
        if (this.pixelType != metadata.pixelType) {
            logger.warn("Pixel types are not compatible: {} vs {}", (Object)this.pixelType, (Object)metadata.pixelType);
            return false;
        }
        if (this.sizeT != metadata.sizeT || this.getSizeC() != metadata.getSizeC() || this.sizeZ != metadata.sizeZ) {
            logger.warn(String.format("Metadata image dimensions (czt) are not the same! %dx%dx%d for original vs %dx%dx%d", this.getSizeC(), this.getSizeZ(), this.getSizeT(), metadata.getSizeC(), metadata.getSizeZ(), metadata.getSizeT()));
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ ");
        sb.append("\"name\": \"").append(this.name).append("\", ");
        sb.append("\"width\": ").append(this.getWidth()).append(", ");
        sb.append("\"height\": ").append(this.getHeight()).append(", ");
        sb.append("\"resolutions\": ").append(this.nLevels()).append(", ");
        sb.append("\"sizeC\": ").append(this.getSizeC());
        if (this.sizeZ != 1) {
            sb.append(", ").append("\"sizeZ\": ").append(this.sizeZ);
        }
        if (this.sizeT != 1) {
            sb.append(", ").append("\"sizeT\": ").append(this.sizeT);
            sb.append(", ").append("\"timeUnit\": ").append((Object)this.getTimeUnit());
        }
        if (this.pixelSizeCalibrated()) {
            sb.append(", ").append("\"pixelWidthMicrons\": ").append(this.getPixelWidthMicrons());
            sb.append(", ").append("\"pixelHeightMicrons\": ").append(this.getPixelHeightMicrons());
        }
        sb.append(" }");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channelType == null ? 0 : this.channelType.hashCode());
        result = 31 * result + (this.channels == null ? 0 : this.channels.hashCode());
        result = 31 * result + this.height;
        result = 31 * result + (this.isRGB ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.levels);
        result = 31 * result + (this.magnification == null ? 0 : this.magnification.hashCode());
        result = 31 * result + (this.maxValue == null ? 0 : this.maxValue.hashCode());
        result = 31 * result + (this.minValue == null ? 0 : this.minValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pixelCalibration == null ? 0 : this.pixelCalibration.hashCode());
        result = 31 * result + (this.pixelType == null ? 0 : this.pixelType.hashCode());
        result = 31 * result + this.preferredTileHeight;
        result = 31 * result + this.preferredTileWidth;
        result = 31 * result + this.sizeT;
        result = 31 * result + this.sizeZ;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageServerMetadata other = (ImageServerMetadata)obj;
        if (this.channelType != other.channelType) {
            return false;
        }
        if (this.channels == null ? other.channels != null : !this.channels.equals(other.channels)) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.isRGB != other.isRGB) {
            return false;
        }
        if (!Arrays.equals(this.levels, other.levels)) {
            return false;
        }
        if (this.magnification == null ? other.magnification != null : !this.magnification.equals(other.magnification)) {
            return false;
        }
        if (this.maxValue == null ? other.maxValue != null : !this.maxValue.equals(other.maxValue)) {
            return false;
        }
        if (this.minValue == null ? other.minValue != null : !this.minValue.equals(other.minValue)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pixelCalibration == null ? other.pixelCalibration != null : !this.pixelCalibration.equals(other.pixelCalibration)) {
            return false;
        }
        if (this.pixelType != other.pixelType) {
            return false;
        }
        if (this.preferredTileHeight != other.preferredTileHeight) {
            return false;
        }
        if (this.preferredTileWidth != other.preferredTileWidth) {
            return false;
        }
        if (this.sizeT != other.sizeT) {
            return false;
        }
        if (this.sizeZ != other.sizeZ) {
            return false;
        }
        return this.width == other.width;
    }

    public static enum ChannelType {
        DEFAULT,
        FEATURE,
        PROBABILITY,
        MULTICLASS_PROBABILITY,
        CLASSIFICATION,
        DENSITY;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Channel";
                }
                case 1: {
                    return "Feature";
                }
                case 2: {
                    return "Probability";
                }
                case 3: {
                    return "Multiclass probability";
                }
                case 4: {
                    return "Classification";
                }
                case 5: {
                    return "Density";
                }
            }
            return super.toString();
        }
    }

    public static class ImageResolutionLevel {
        private static final Logger logger = LoggerFactory.getLogger(ImageResolutionLevel.class);
        private double downsample;
        private final int width;
        private final int height;

        private ImageResolutionLevel(double downsample, int width, int height) {
            this.downsample = downsample;
            this.width = width;
            this.height = height;
        }

        public double getDownsample() {
            return this.downsample;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.downsample);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.height;
            result = 31 * result + this.width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageResolutionLevel other = (ImageResolutionLevel)obj;
            if (Double.doubleToLongBits(this.downsample) != Double.doubleToLongBits(other.downsample)) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            return this.width == other.width;
        }

        public String toString() {
            return "Level: " + this.width + "x" + this.height + " (" + GeneralTools.formatNumber(this.downsample, 5) + ")";
        }

        public static class Builder {
            private int fullWidth;
            private int fullHeight;
            private List<ImageResolutionLevel> levels = new ArrayList<ImageResolutionLevel>();
            private static double LOG2 = Math.log10(2.0);

            public Builder(int fullWidth, int fullHeight) {
                this.fullWidth = fullWidth;
                this.fullHeight = fullHeight;
            }

            public Builder addLevelByDownsample(double downsample) {
                int levelWidth = (int)((double)this.fullWidth / downsample);
                int levelHeight = (int)((double)this.fullHeight / downsample);
                return this.addLevel(downsample, levelWidth, levelHeight);
            }

            public Builder addFullResolutionLevel() {
                return this.addLevel(1.0, this.fullWidth, this.fullHeight);
            }

            public Builder addLevel(double downsample, int levelWidth, int levelHeight) {
                if (downsample <= 0.0) {
                    throw new IllegalArgumentException("Downsample must be > 0, but this one is " + downsample);
                }
                this.levels.add(new ImageResolutionLevel(downsample, levelWidth, levelHeight));
                return this;
            }

            public Builder addLevel(int levelWidth, int levelHeight) {
                double downsample = Builder.estimateDownsample(this.fullWidth, this.fullHeight, levelWidth, levelHeight, this.levels.size());
                return this.addLevel(downsample, levelWidth, levelHeight);
            }

            public Builder addLevel(ImageResolutionLevel level) {
                return this.addLevel(level.downsample, level.width, level.height);
            }

            public List<ImageResolutionLevel> build() {
                ArrayList<ImageResolutionLevel> output = new ArrayList<ImageResolutionLevel>();
                double lastDownsample = -1.0;
                for (ImageResolutionLevel level : this.levels) {
                    double downsample = level.getDownsample();
                    if (downsample <= lastDownsample) {
                        logger.warn("Resolution levels are out of order! Only {}/{} levels can be used.", (Object)output.size(), (Object)this.levels.size());
                        break;
                    }
                    output.add(level);
                    lastDownsample = downsample;
                }
                return output;
            }

            private static double estimateDownsample(int fullWidth, int fullHeight, int levelWidth, int levelHeight, int level) {
                double downsampleX = (double)fullWidth / (double)levelWidth;
                double downsampleY = (double)fullHeight / (double)levelHeight;
                double downsampleAverage = (downsampleX + downsampleY) / 2.0;
                double closestPow2 = Math.pow(2.0, Math.round(Math.log10(downsampleAverage) / LOG2));
                if (Math.abs((double)fullHeight / closestPow2 - (double)levelHeight) < 2.0 && Math.abs((double)fullWidth / closestPow2 - (double)levelWidth) < 2.0) {
                    return closestPow2;
                }
                if (Math.abs((double)fullWidth / (double)Math.round(downsampleX) - (double)levelWidth) <= 1.0) {
                    downsampleX = Math.round(downsampleX);
                }
                if (Math.abs((double)fullHeight / (double)Math.round(downsampleY) - (double)levelHeight) <= 1.0) {
                    downsampleY = Math.round(downsampleY);
                }
                if (downsampleX == downsampleY) {
                    return downsampleX;
                }
                if (downsampleX == closestPow2 || downsampleY == closestPow2) {
                    return closestPow2;
                }
                double downsample = (downsampleX + downsampleY) / 2.0;
                if (level >= 0 && !GeneralTools.almostTheSame(downsampleX, downsampleY, 0.001)) {
                    logger.warn("Calculated downsample values differ for x & y for level {}: x={} and y={} - will use value {}", new Object[]{level, downsampleX, downsampleY, downsample});
                }
                return downsample;
            }
        }
    }

    public static class Builder {
        private ImageServerMetadata metadata;
        private PixelCalibration.Builder pixelCalibrationBuilder = new PixelCalibration.Builder();

        public Builder(ImageServerMetadata metadata) {
            this.metadata = metadata.duplicate();
            this.pixelCalibrationBuilder = new PixelCalibration.Builder(metadata.pixelCalibration);
        }

        public Builder() {
            this.metadata = new ImageServerMetadata();
        }

        public Builder(Class<? extends ImageServer<?>> serverClass, String path, int width, int height) {
            this.metadata = new ImageServerMetadata();
            this.metadata.width = width;
            this.metadata.height = height;
        }

        public Builder width(int width) {
            this.metadata.width = width;
            return this;
        }

        public Builder height(int height) {
            this.metadata.height = height;
            return this;
        }

        public Builder minValue(Number val) {
            this.metadata.minValue = val;
            return this;
        }

        public Builder maxValue(Number val) {
            this.metadata.maxValue = val;
            return this;
        }

        public Builder channelType(ChannelType type) {
            this.metadata.channelType = type;
            if (type == ChannelType.CLASSIFICATION) {
                this.metadata.channels = Collections.singletonList(DEFAULT_CLASSIFICATION_LABELS_CHANNEL);
            }
            return this;
        }

        public Builder classificationLabels(Map<Integer, PathClass> classificationLabels) {
            this.metadata.classificationLabels = Collections.unmodifiableMap(new LinkedHashMap<Integer, PathClass>(classificationLabels));
            return this;
        }

        public Builder rgb(boolean isRGB) {
            this.metadata.isRGB = isRGB;
            return this;
        }

        public Builder pixelType(PixelType pixelType) {
            this.metadata.pixelType = pixelType;
            return this;
        }

        public Builder levelsFromDownsamples(double ... downsamples) {
            ImageResolutionLevel.Builder levelBuilder = new ImageResolutionLevel.Builder(this.metadata.width, this.metadata.height);
            for (double d : downsamples) {
                levelBuilder.addLevelByDownsample(d);
            }
            return this.levels(levelBuilder.build());
        }

        public Builder levels(Collection<ImageResolutionLevel> levels) {
            this.metadata.levels = (ImageResolutionLevel[])levels.toArray(ImageResolutionLevel[]::new);
            return this;
        }

        public Builder sizeZ(int sizeZ) {
            this.metadata.sizeZ = sizeZ;
            return this;
        }

        public Builder sizeT(int sizeT) {
            this.metadata.sizeT = sizeT;
            return this;
        }

        public Builder pixelSizeMicrons(Number pixelWidthMicrons, Number pixelHeightMicrons) {
            this.pixelCalibrationBuilder.pixelSizeMicrons(pixelWidthMicrons, pixelHeightMicrons);
            return this;
        }

        public Builder zSpacingMicrons(Number zSpacingMicrons) {
            this.pixelCalibrationBuilder.zSpacingMicrons(zSpacingMicrons);
            return this;
        }

        public Builder timepoints(TimeUnit timeUnit, double ... timepoints) {
            this.pixelCalibrationBuilder.timepoints(timeUnit, timepoints);
            return this;
        }

        public Builder magnification(double magnification) {
            this.metadata.magnification = Double.isFinite(magnification) ? Double.valueOf(magnification) : null;
            return this;
        }

        public Builder preferredTileSize(int tileWidth, int tileHeight) {
            this.metadata.preferredTileWidth = tileWidth;
            this.metadata.preferredTileHeight = tileHeight;
            return this;
        }

        public Builder channels(Collection<ImageChannel> channels) {
            this.metadata.channels = Collections.unmodifiableList(new ArrayList<ImageChannel>(channels));
            return this;
        }

        public Builder name(String name) {
            this.metadata.name = name;
            return this;
        }

        public ImageServerMetadata build() {
            this.metadata.pixelCalibration = this.pixelCalibrationBuilder.build();
            if (this.metadata.levels == null) {
                this.metadata.levels = new ImageResolutionLevel[]{new ImageResolutionLevel(1.0, this.metadata.width, this.metadata.height)};
            }
            if (this.metadata.width <= 0 && this.metadata.height <= 0) {
                throw new IllegalArgumentException("Invalid metadata - width & height must be > 0");
            }
            if (this.metadata.preferredTileWidth <= 0) {
                this.metadata.preferredTileWidth = this.metadata.levels.length == 1 ? this.metadata.width : Math.min(this.metadata.width, DEFAULT_TILE_SIZE);
            }
            if (this.metadata.preferredTileHeight <= 0) {
                this.metadata.preferredTileHeight = this.metadata.levels.length == 1 ? this.metadata.height : Math.min(this.metadata.height, DEFAULT_TILE_SIZE);
            }
            return new ImageServerMetadata(this.metadata);
        }
    }
}

