/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.images.servers.AffineTransformImageServer;
import qupath.lib.images.servers.ChannelTransformFeatureServer;
import qupath.lib.images.servers.ColorDeconvolutionImageServer;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ConcatChannelsImageServer;
import qupath.lib.images.servers.CroppedImageServer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.NormalizedImageServer;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.PyramidGeneratingImageServer;
import qupath.lib.images.servers.RearrangeRGBImageServer;
import qupath.lib.images.servers.RotatedImageServer;
import qupath.lib.images.servers.SlicedImageServer;
import qupath.lib.images.servers.SparseImageServer;
import qupath.lib.images.servers.TypeConvertImageServer;
import qupath.lib.images.servers.transforms.BufferedImageNormalizer;
import qupath.lib.images.servers.transforms.ColorDeconvolutionNormalizer;
import qupath.lib.images.servers.transforms.SubtractOffsetAndScaleNormalizer;
import qupath.lib.io.GsonTools;
import qupath.lib.regions.ImageRegion;

public class ImageServers {
    private static final Logger logger = LoggerFactory.getLogger(ImageServers.class);
    private static Set<String> loggedWarnings = new HashSet<String>();
    private static GsonTools.SubTypeAdapterFactory<ImageServerBuilder.ServerBuilder> serverBuilderFactory = GsonTools.createSubTypeAdapterFactory(ImageServerBuilder.ServerBuilder.class, "builderType").registerSubtype(ImageServerBuilder.DefaultImageServerBuilder.class, "uri").registerSubtype(RotatedImageServerBuilder.class, "rotated").registerSubtype(ConcatChannelsImageServerBuilder.class, "channels").registerSubtype(ChannelTransformFeatureServerBuilder.class, "color").registerSubtype(AffineTransformImageServerBuilder.class, "affine").registerSubtype(SparseImageServerBuilder.class, "sparse").registerSubtype(CroppedImageServerBuilder.class, "cropped").registerSubtype(PyramidGeneratingServerBuilder.class, "pyramidize").registerSubtype(ReorderRGBServerBuilder.class, "swapRedBlue").registerSubtype(ColorDeconvolutionServerBuilder.class, "color_deconvolved").registerSubtype(NormalizedImageServerBuilder.class, "normalized").registerSubtype(TypeConvertImageServerBuilder.class, "typeConvert");
    private static GsonTools.SubTypeAdapterFactory<BufferedImageNormalizer> normalizerFactory = GsonTools.createSubTypeAdapterFactory(BufferedImageNormalizer.class, "normalizerType").registerSubtype(ColorDeconvolutionNormalizer.class, "colorDeconvolution").registerSubtype(SubtractOffsetAndScaleNormalizer.class, "offsetAndScale");

    static void logFirstDeprecatedReadCall(Class<? extends ImageServer> cls) {
        String warning = cls.getSimpleName() + ".readBufferedImage(RegionRequest) is deprecated - please use " + cls.getSimpleName() + ".readRegion(RegionRequest) instead";
        if (loggedWarnings.add(warning)) {
            LoggerFactory.getLogger(cls).warn(warning);
        }
    }

    public static TypeAdapterFactory getServerBuilderFactory() {
        return serverBuilderFactory;
    }

    public static TypeAdapterFactory getNormalizerFactory() {
        return normalizerFactory;
    }

    public static ImageServer<BufferedImage> pyramidalize(ImageServer<BufferedImage> server, double ... downsamples) {
        ImageServerMetadata oldMetadata = server.getMetadata();
        int tileWidth = 256;
        int tileHeight = 256;
        if (oldMetadata.getPreferredTileWidth() < oldMetadata.getWidth()) {
            tileWidth = oldMetadata.getPreferredTileWidth();
        }
        if (oldMetadata.getPreferredTileHeight() < oldMetadata.getHeight()) {
            tileHeight = oldMetadata.getPreferredTileHeight();
        }
        return ImageServers.pyramidalizeTiled(server, tileWidth, tileHeight, downsamples);
    }

    public static ImageServer<BufferedImage> pyramidalizeTiled(ImageServer<BufferedImage> server, int tileWidth, int tileHeight, double ... downsamples) {
        ImageServerMetadata oldMetadata = server.getMetadata();
        if (downsamples.length == 0) {
            ArrayList<Double> downsampleList = new ArrayList<Double>();
            double downsample = oldMetadata.getDownsampleForLevel(0);
            double nextWidth = (double)server.getWidth() / downsample;
            double nextHeight = (double)server.getHeight() / downsample;
            do {
                downsampleList.add(downsample);
                nextWidth = (double)server.getWidth() / (downsample *= 4.0);
                nextHeight = (double)server.getHeight() / downsample;
            } while ((nextWidth > (double)tileWidth || nextHeight > (double)tileHeight) && nextWidth >= 8.0 && nextHeight >= 8.0);
            downsamples = downsampleList.stream().mapToDouble(d -> d).toArray();
        }
        return new PyramidGeneratingImageServer(server, tileWidth, tileHeight, downsamples);
    }

    public static ImageServer<BufferedImage> buildServer(String path, String ... args) throws IOException {
        return ImageServers.buildServer(ImageServerProvider.legacyPathToURI(path), args);
    }

    public static ImageServer<BufferedImage> buildServer(URI uri, String ... args) throws IOException {
        List<ImageServerBuilder.UriImageSupport<BufferedImage>> supports = ImageServers.getAllImageSupports(uri, args);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ImageServerBuilder.UriImageSupport<BufferedImage> support : supports) {
            try {
                List<ImageServerBuilder.ServerBuilder<BufferedImage>> builders = support.getBuilders();
                if (!builders.isEmpty()) {
                    return builders.get(0).build();
                }
                logger.debug("No builders available for {}", support);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        IOException exception = new IOException(ImageServers.buildBaseExceptionMessage(uri, args));
        for (Exception e : exceptions) {
            exception.addSuppressed(e);
        }
        throw exception;
    }

    private static String buildBaseExceptionMessage(URI uri, String ... args) {
        if (args.length == 0) {
            return "Unable to open " + String.valueOf(uri);
        }
        return "Unable to open " + String.valueOf(uri) + " with args [" + Arrays.stream(args).collect(Collectors.joining(", ")) + "]";
    }

    public static List<ImageServerBuilder.UriImageSupport<BufferedImage>> getAllImageSupports(URI uri, String ... args) throws IOException {
        ServerArgs serverArgs = ImageServers.parseServerArgs(args);
        String[] requestedClassnames = serverArgs.requestedClassnames;
        ArrayList<ImageServerBuilder.UriImageSupport<BufferedImage>> supports = new ArrayList<ImageServerBuilder.UriImageSupport<BufferedImage>>();
        List<ImageServerBuilder<BufferedImage>> availableBuilders = ImageServerProvider.getInstalledImageServerBuilders(BufferedImage.class);
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        if (requestedClassnames.length > 0) {
            for (ImageServerBuilder<BufferedImage> builder : availableBuilders) {
                if (!builder.matchClassName(requestedClassnames)) continue;
                try {
                    support = ImageServers.getImageSupport(builder, uri, serverArgs);
                    if (support != null) {
                        supports.add(support);
                        continue;
                    }
                    exceptions.add(new IOException("Unable to open " + String.valueOf(uri) + " with " + String.valueOf(builder)));
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
            if (supports.isEmpty()) {
                throw new IOException("No compatible readers found with classnames [" + Arrays.stream(requestedClassnames).collect(Collectors.joining(", ")) + "]");
            }
        } else {
            for (ImageServerBuilder<BufferedImage> builder : availableBuilders) {
                try {
                    support = ImageServers.getImageSupport(builder, uri, serverArgs);
                    if (support == null || !(support.getSupportLevel() > 0.0f)) continue;
                    supports.add(support);
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
        }
        if (supports.isEmpty()) {
            IOException exception;
            String message = ImageServers.buildBaseExceptionMessage(uri, args);
            if (exceptions.size() == 1) {
                exception = new IOException(message, (Throwable)exceptions.get(0));
            } else {
                exception = new IOException(message);
                for (Exception exception2 : exceptions) {
                    exception.addSuppressed(exception2);
                }
            }
            throw exception;
        }
        Comparator comparator = Collections.reverseOrder(new ImageServerProvider.UriImageSupportComparator());
        supports.sort(comparator);
        return supports;
    }

    private static ImageServerBuilder.UriImageSupport<BufferedImage> getImageSupport(ImageServerBuilder<BufferedImage> builder, URI uri, ServerArgs serverArgs) throws IOException {
        String[] extraArgs = (String[])serverArgs.unmatched.clone();
        ImageServerBuilder.UriImageSupport<BufferedImage> support = builder.checkImageSupport(uri, extraArgs);
        return ImageServers.transformSupport(support, serverArgs);
    }

    public static ImageServerBuilder.UriImageSupport<BufferedImage> getImageSupport(URI uri, String ... args) throws IOException {
        List<ImageServerBuilder.UriImageSupport<BufferedImage>> supports = ImageServers.getAllImageSupports(uri, args);
        return supports.isEmpty() ? null : supports.get(0);
    }

    public static ImageServerBuilder.UriImageSupport<BufferedImage> getImageSupport(ImageServerBuilder<BufferedImage> builder, URI uri, String ... args) throws IOException {
        ServerArgs serverArgs = ImageServers.parseServerArgs(args);
        return ImageServers.getImageSupport(builder, uri, serverArgs);
    }

    private static ServerArgs parseServerArgs(String ... args) {
        ServerArgs serverArgs = new ServerArgs();
        new CommandLine((Object)serverArgs).parseArgs(args);
        return serverArgs;
    }

    /*
     * WARNING - void declaration
     */
    static ImageServerBuilder.UriImageSupport<BufferedImage> transformSupport(ImageServerBuilder.UriImageSupport<BufferedImage> support, ServerArgs args) {
        String orderRGB;
        if (support == null) {
            return null;
        }
        ArrayList<Function<ImageServerBuilder.ServerBuilder, ImageServerBuilder.ServerBuilder>> functions = new ArrayList<Function<ImageServerBuilder.ServerBuilder, ImageServerBuilder.ServerBuilder>>();
        if (args.rotation != null && args.rotation != RotatedImageServer.Rotation.ROTATE_NONE) {
            functions.add(b -> RotatedImageServer.getRotatedBuilder(b, args.rotation));
        }
        if ((orderRGB = args.getOrderRGB()) != null) {
            functions.add(b -> RearrangeRGBImageServer.getSwapRedBlueBuilder(b, orderRGB));
        }
        if (functions.isEmpty()) {
            return support;
        }
        ArrayList buildersNew = new ArrayList();
        for (ImageServerBuilder.ServerBuilder<BufferedImage> serverBuilder : support.getBuilders()) {
            void var6_6;
            for (Function function : functions) {
                ImageServerBuilder.ServerBuilder serverBuilder2 = (ImageServerBuilder.ServerBuilder)function.apply(var6_6);
            }
            buildersNew.add(var6_6);
        }
        return new ImageServerBuilder.UriImageSupport<BufferedImage>(support.getProviderClass(), support.getSupportLevel(), buildersNew);
    }

    public static TypeAdapterFactory getImageServerTypeAdapterFactory(boolean includeMetadata) {
        return new ImageServerTypeAdapterFactory(includeMetadata);
    }

    private static TypeAdapter<ImageServer<BufferedImage>> getTypeAdapter(boolean includeMetadata) {
        return new ImageServerTypeAdapter(includeMetadata);
    }

    static {
        GsonTools.getDefaultBuilder().registerTypeAdapterFactory(ImageServers.getImageServerTypeAdapterFactory(true)).registerTypeAdapterFactory(ImageServers.getServerBuilderFactory()).registerTypeAdapterFactory(ImageServers.getNormalizerFactory());
    }

    static class ServerArgs {
        @CommandLine.Option(names={"--classname"}, description={"Requested classnames for the ImageServerProvider"})
        String[] requestedClassnames = new String[0];
        @CommandLine.Option(names={"--rotate"}, description={"Rotate the image during reading by an increment of 90 degrees."})
        RotatedImageServer.Rotation rotation = RotatedImageServer.Rotation.ROTATE_NONE;
        @CommandLine.Option(names={"--order"}, description={"Rearrange the channels of an RGB image (to correct errors in the image reader)"})
        String orderRGB = null;
        @CommandLine.Unmatched
        String[] unmatched = new String[0];

        ServerArgs() {
        }

        String getOrderRGB() {
            return this.orderRGB == null || this.orderRGB.isBlank() ? null : this.orderRGB.trim().toUpperCase();
        }
    }

    static class ImageServerTypeAdapterFactory
    implements TypeAdapterFactory {
        private boolean includeMetadata;

        ImageServerTypeAdapterFactory(boolean includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (ImageServer.class.isAssignableFrom(type.getRawType())) {
                return ImageServers.getTypeAdapter(this.includeMetadata);
            }
            return null;
        }
    }

    static class ImageServerTypeAdapter
    extends TypeAdapter<ImageServer<BufferedImage>> {
        private static Logger logger = LoggerFactory.getLogger(ImageServerTypeAdapter.class);
        private final boolean includeMetadata;

        ImageServerTypeAdapter() {
            this(true);
        }

        ImageServerTypeAdapter(boolean includeMetadata) {
            this.includeMetadata = includeMetadata;
        }

        public void write(JsonWriter out, ImageServer<BufferedImage> server) throws IOException {
            Strictness strictness = out.getStrictness();
            try {
                out.setStrictness(Strictness.LENIENT);
                ImageServerBuilder.ServerBuilder<BufferedImage> builder = server.getBuilder();
                out.beginObject();
                out.name("builder");
                GsonTools.getInstance().toJson(builder, ImageServerBuilder.ServerBuilder.class, out);
                if (this.includeMetadata) {
                    out.name("metadata");
                    ImageServerMetadata metadata = server.getMetadata();
                    GsonTools.getInstance().toJson((Object)metadata, ImageServerMetadata.class, out);
                }
                out.endObject();
                return;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                out.setStrictness(strictness);
            }
        }

        public ImageServer<BufferedImage> read(JsonReader in) throws IOException {
            Strictness strictness = in.getStrictness();
            try {
                ImageServer<BufferedImage> server;
                in.setStrictness(Strictness.LENIENT);
                JsonElement element = JsonParser.parseReader((JsonReader)in);
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("builder")) {
                    ImageServerMetadata metadata;
                    server = ((ImageServerBuilder.ServerBuilder)GsonTools.getInstance().fromJson(obj.get("builder"), ImageServerBuilder.ServerBuilder.class)).build();
                    if (obj.has("metadata") && (metadata = (ImageServerMetadata)GsonTools.getInstance().fromJson(obj.get("metadata"), ImageServerMetadata.class)) != null) {
                        server.setMetadata(metadata);
                    }
                } else if (obj.has("builderType")) {
                    ImageServerBuilder.ServerBuilder serverBuilder = (ImageServerBuilder.ServerBuilder)GsonTools.getInstance().fromJson((JsonElement)obj, ImageServerBuilder.ServerBuilder.class);
                    server = serverBuilder.build();
                } else {
                    logger.error("No ImageServer builder found in JSON object: {}", (Object)obj);
                    throw new IOException("No ImageServer builder found in JSON object");
                }
                ImageServer<BufferedImage> imageServer = server;
                return imageServer;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                in.setStrictness(strictness);
            }
        }
    }

    static class RotatedImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private RotatedImageServer.Rotation rotation;

        RotatedImageServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, RotatedImageServer.Rotation rotation) {
            super(metadata);
            this.builder = builder;
            this.rotation = rotation;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new RotatedImageServer(this.builder.build(), this.rotation);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new RotatedImageServerBuilder(this.getMetadata().orElse(null), newBuilder, this.rotation);
        }
    }

    static class ConcatChannelsImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private List<ImageServerBuilder.ServerBuilder<BufferedImage>> channels;

        ConcatChannelsImageServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, List<ImageServerBuilder.ServerBuilder<BufferedImage>> channels) {
            super(metadata);
            this.builder = builder;
            this.channels = channels;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            ArrayList<ImageServer<BufferedImage>> servers = new ArrayList<ImageServer<BufferedImage>>();
            ImageServer<BufferedImage> server = null;
            for (ImageServerBuilder.ServerBuilder<BufferedImage> channel : this.channels) {
                ImageServer<BufferedImage> temp = channel.build();
                servers.add(temp);
                if (!this.builder.equals(channel)) continue;
                server = temp;
            }
            if (server == null) {
                server = this.builder.build();
            }
            return new ConcatChannelsImageServer(server, servers);
        }

        @Override
        public Collection<URI> getURIs() {
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            uris.addAll(this.builder.getURIs());
            for (ImageServerBuilder.ServerBuilder<BufferedImage> temp : this.channels) {
                uris.addAll(temp.getURIs());
            }
            return uris;
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            boolean changes = newBuilder != this.builder;
            ArrayList<ImageServerBuilder.ServerBuilder<BufferedImage>> newChannels = new ArrayList<ImageServerBuilder.ServerBuilder<BufferedImage>>();
            for (ImageServerBuilder.ServerBuilder<BufferedImage> temp : this.channels) {
                ImageServerBuilder.ServerBuilder<BufferedImage> newChannel = temp.updateURIs(updateMap);
                newChannels.add(newChannel);
                changes = changes || newChannel != temp;
            }
            if (!changes) {
                return this;
            }
            return new ConcatChannelsImageServerBuilder(this.getMetadata().orElse(null), newBuilder, newChannels);
        }
    }

    static class ChannelTransformFeatureServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private List<ColorTransforms.ColorTransform> transforms;

        ChannelTransformFeatureServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, List<ColorTransforms.ColorTransform> transforms) {
            super(metadata);
            this.builder = builder;
            this.transforms = transforms;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new ChannelTransformFeatureServer(this.builder.build(), this.transforms);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new ChannelTransformFeatureServerBuilder(this.getMetadata().orElse(null), newBuilder, this.transforms);
        }
    }

    static class AffineTransformImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private AffineTransform transform;

        AffineTransformImageServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, AffineTransform transform) {
            super(metadata);
            this.builder = builder;
            this.transform = transform;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            double[] flat = new double[6];
            this.transform.getMatrix(flat);
            return new AffineTransformImageServer(this.builder.build(), new AffineTransform(flat));
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new AffineTransformImageServerBuilder(this.getMetadata().orElse(null), newBuilder, this.transform);
        }
    }

    static class SparseImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private List<SparseImageServer.SparseImageServerManagerRegion> regions;
        private String path;

        SparseImageServerBuilder(ImageServerMetadata metadata, Collection<SparseImageServer.SparseImageServerManagerRegion> regions, String path) {
            super(metadata);
            this.regions = new ArrayList<SparseImageServer.SparseImageServerManagerRegion>(regions);
            this.path = path;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new SparseImageServer(this.regions, this.path);
        }

        @Override
        public Collection<URI> getURIs() {
            LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
            for (SparseImageServer.SparseImageServerManagerRegion region : this.regions) {
                for (SparseImageServer.SparseImageServerManagerResolution res : region.getResolutions()) {
                    uris.addAll(res.getServerBuilder().getURIs());
                }
            }
            return uris;
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ArrayList<SparseImageServer.SparseImageServerManagerRegion> newRegions = new ArrayList<SparseImageServer.SparseImageServerManagerRegion>();
            for (SparseImageServer.SparseImageServerManagerRegion region : this.regions) {
                ArrayList<SparseImageServer.SparseImageServerManagerResolution> newResolutions = new ArrayList<SparseImageServer.SparseImageServerManagerResolution>();
                for (SparseImageServer.SparseImageServerManagerResolution res : region.getResolutions()) {
                    newResolutions.add(new SparseImageServer.SparseImageServerManagerResolution(res.getServerBuilder().updateURIs(updateMap), res.getDownsample()));
                }
                newRegions.add(new SparseImageServer.SparseImageServerManagerRegion(region.getRegion(), newResolutions));
            }
            return new SparseImageServerBuilder(this.getMetadata().orElse(null), newRegions, this.path);
        }
    }

    static class CroppedImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private ImageRegion region;

        CroppedImageServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, ImageRegion region) {
            super(metadata);
            this.builder = builder;
            this.region = region;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new CroppedImageServer(this.builder.build(), this.region);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new CroppedImageServerBuilder(this.getMetadata().orElse(null), newBuilder, this.region);
        }
    }

    static class PyramidGeneratingServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;

        PyramidGeneratingServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder) {
            super(metadata);
            this.builder = builder;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            ImageServerMetadata metadata = this.getMetadata().orElseThrow();
            return new PyramidGeneratingImageServer(this.builder.build(), metadata.getPreferredTileWidth(), metadata.getPreferredTileHeight(), metadata.getPreferredDownsamplesArray());
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new PyramidGeneratingServerBuilder(this.getMetadata().orElse(null), newBuilder);
        }
    }

    static class ReorderRGBServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private String order;

        ReorderRGBServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, String order) {
            super(metadata);
            this.builder = builder;
            this.order = order;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new RearrangeRGBImageServer(this.builder.build(), this.order);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new ReorderRGBServerBuilder(this.getMetadata().orElse(null), newBuilder, this.order);
        }
    }

    static class ColorDeconvolutionServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private ColorDeconvolutionStains stains;
        private int[] channels;

        ColorDeconvolutionServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, ColorDeconvolutionStains stains, int ... channels) {
            super(metadata);
            this.builder = builder;
            this.stains = stains;
            this.channels = channels == null ? null : (int[])channels.clone();
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new ColorDeconvolutionImageServer(this.builder.build(), this.stains, this.channels);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new ColorDeconvolutionServerBuilder(this.getMetadata().orElse(null), newBuilder, this.stains, this.channels);
        }
    }

    static class NormalizedImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private BufferedImageNormalizer normalizer;

        NormalizedImageServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, BufferedImageNormalizer normalizer) {
            super(metadata);
            this.builder = builder;
            this.normalizer = normalizer;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new NormalizedImageServer(this.builder.build(), this.normalizer);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new NormalizedImageServerBuilder(this.getMetadata().orElse(null), newBuilder, this.normalizer);
        }
    }

    static class TypeConvertImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private PixelType pixelType;

        TypeConvertImageServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, PixelType pixelType) {
            super(metadata);
            this.builder = builder;
            this.pixelType = pixelType;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new TypeConvertImageServer(this.builder.build(), this.pixelType);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new TypeConvertImageServerBuilder(this.getMetadata().orElse(null), newBuilder, this.pixelType);
        }
    }

    static class SlicedImageServerBuilder
    extends ImageServerBuilder.AbstractServerBuilder<BufferedImage> {
        private final ImageServerBuilder.ServerBuilder<BufferedImage> builder;
        private final int zStart;
        private final int zEnd;
        private final int tStart;
        private final int tEnd;

        public SlicedImageServerBuilder(ImageServerMetadata metadata, ImageServerBuilder.ServerBuilder<BufferedImage> builder, int zStart, int zEnd, int tStart, int tEnd) {
            super(metadata);
            this.builder = builder;
            this.zStart = zStart;
            this.zEnd = zEnd;
            this.tStart = tStart;
            this.tEnd = tEnd;
        }

        @Override
        protected ImageServer<BufferedImage> buildOriginal() throws Exception {
            return new SlicedImageServer(this.builder.build(), this.zStart, this.zEnd, this.tStart, this.tEnd);
        }

        @Override
        public Collection<URI> getURIs() {
            return this.builder.getURIs();
        }

        @Override
        public ImageServerBuilder.ServerBuilder<BufferedImage> updateURIs(Map<URI, URI> updateMap) {
            ImageServerBuilder.ServerBuilder<BufferedImage> newBuilder = this.builder.updateURIs(updateMap);
            if (newBuilder == this.builder) {
                return this;
            }
            return new SlicedImageServerBuilder(this.getMetadata().orElse(null), newBuilder, this.zStart, this.zEnd, this.tStart, this.tEnd);
        }
    }
}

