/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorMaps;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.common.ColorTools;
import qupath.lib.geom.Point2;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.GeneratingImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class LabeledImageServer
extends AbstractTileableImageServer
implements GeneratingImageServer<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(LabeledImageServer.class);
    private ImageServerMetadata originalMetadata;
    private static final ColorModel COLOR_MODEL_GRAY_UINT8 = new BufferedImage(1, 1, 10).getColorModel();
    private static final ColorModel COLOR_MODEL_GRAY_UINT16 = new BufferedImage(1, 1, 11).getColorModel();
    private PathObjectHierarchy hierarchy;
    private ColorModel colorModel;
    private boolean multichannelOutput;
    private LabeledServerParameters params;
    private int maxLabel;
    private Map<PathObject, Integer> instanceClassMap = null;
    private Map<Integer, PathObject> instanceClassMapInverse = null;

    /*
     * WARNING - void declaration
     */
    private LabeledImageServer(ImageData<BufferedImage> imageData, double downsample, int tileWidth, int tileHeight, LabeledServerParameters params, boolean multichannelOutput) {
        PathClass previousClass;
        Integer label;
        PathClass pathClass;
        this.multichannelOutput = multichannelOutput;
        this.hierarchy = imageData.getHierarchy();
        this.params = params;
        ImageServer<BufferedImage> server = imageData.getServer();
        TreeMap<Integer, PathClass> classificationLabels = new TreeMap<Integer, PathClass>();
        if (params.createInstanceLabels) {
            ArrayList pathObjects = imageData.getHierarchy().getObjects(null, null).stream().filter(params.objectFilter).collect(Collectors.toCollection(ArrayList::new));
            if (params.shuffleInstanceLabels) {
                Collections.shuffle(pathObjects, new Random(100L));
            }
            Integer n = multichannelOutput ? 0 : 1;
            this.instanceClassMap = new HashMap<PathObject, Integer>();
            this.instanceClassMapInverse = new HashMap<Integer, PathObject>();
            Iterator iterator = pathObjects.iterator();
            while (iterator.hasNext()) {
                void var11_11;
                PathObject pathObject = (PathObject)iterator.next();
                PathClass pathClass2 = LabeledImageServer.instanceLabelToClass((Integer)var11_11);
                this.instanceClassMap.put(pathObject, (Integer)var11_11);
                this.instanceClassMapInverse.put((Integer)var11_11, pathObject);
                classificationLabels.put((Integer)var11_11, pathClass2);
                params.labelColors.put((Integer)var11_11, pathClass2.getColor());
                params.labels.put(pathClass2, (Integer)var11_11);
                void var15_25 = var11_11;
                Integer n2 = var11_11.intValue() + 1;
            }
        } else {
            for (Map.Entry<PathClass, Integer> entry : params.labels.entrySet()) {
                pathClass = LabeledImageServer.getPathClass(entry.getKey());
                label = entry.getValue();
                previousClass = classificationLabels.put(label, pathClass);
                if (previousClass == null || previousClass == PathClass.NULL_CLASS) continue;
                classificationLabels.put(label, PathClass.getInstance(previousClass, pathClass.getName(), null));
            }
        }
        for (Map.Entry entry : params.boundaryLabels.entrySet()) {
            pathClass = LabeledImageServer.getPathClass((PathClass)entry.getKey());
            label = (Integer)entry.getValue();
            previousClass = classificationLabels.put(label, pathClass);
            if (previousClass == null || previousClass == PathClass.NULL_CLASS) continue;
            classificationLabels.put(label, PathClass.getInstance(previousClass, pathClass.getName(), null));
        }
        if (tileWidth <= 0) {
            tileWidth = 512;
        }
        if (tileHeight <= 0) {
            tileHeight = tileWidth;
        }
        ImageServerMetadata.Builder metadataBuilder = new ImageServerMetadata.Builder(server.getMetadata()).preferredTileSize(tileWidth, tileHeight).levelsFromDownsamples(downsample).pixelType(PixelType.UINT8).rgb(false);
        IntSummaryStatistics intSummaryStatistics = classificationLabels.keySet().stream().mapToInt(i -> i).summaryStatistics();
        int minLabel = intSummaryStatistics.getMin();
        this.maxLabel = intSummaryStatistics.getMax();
        if (minLabel < 0) {
            throw new IllegalArgumentException("Minimum possible label value is 0! Requested minimum was " + this.maxLabel);
        }
        if (multichannelOutput) {
            int nChannels = this.maxLabel + 1;
            if (params.maxOutputChannelLimit > 0 && nChannels > params.maxOutputChannelLimit) {
                throw new IllegalArgumentException("You've requested " + nChannels + " output channels, but the maximum supported number is " + params.maxOutputChannelLimit);
            }
        }
        if (multichannelOutput) {
            int nLabels = this.maxLabel - minLabel + 1;
            if (minLabel != 0 || nLabels != classificationLabels.size()) {
                throw new IllegalArgumentException("Labels for multichannel output must be consecutive integers starting from 0! Requested labels " + String.valueOf(classificationLabels.keySet()));
            }
            List<ImageChannel> channels = ServerTools.classificationLabelsToChannels(classificationLabels, false);
            if (params.grayscaleLut) {
                channels = channels.stream().map(c -> ImageChannel.getInstance(c.getName(), ColorTools.WHITE)).toList();
            }
            metadataBuilder = metadataBuilder.channelType(ImageServerMetadata.ChannelType.MULTICLASS_PROBABILITY).channels(channels).classificationLabels(classificationLabels);
            this.colorModel = ColorModelFactory.createColorModel(PixelType.UINT8, channels);
        } else {
            metadataBuilder = metadataBuilder.channelType(ImageServerMetadata.ChannelType.CLASSIFICATION).classificationLabels(classificationLabels);
            LinkedHashMap<Integer, Integer> colors = new LinkedHashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : params.labelColors.entrySet()) {
                Integer key = entry.getKey();
                Integer value = entry.getValue();
                if (key == null) {
                    logger.debug("Missing key in label map! Will be skipped.");
                    continue;
                }
                if (value == null) {
                    logger.debug("Missing color in label map! Will be derived from the background color.");
                    Integer backgroundColor = params.labelColors.get(params.labels.get(params.unannotatedClass));
                    value = backgroundColor == null ? 0 : ~backgroundColor.intValue();
                }
                colors.put(key, value);
            }
            if (params.grayscaleLut) {
                if (this.maxLabel < 255) {
                    this.colorModel = COLOR_MODEL_GRAY_UINT8;
                } else if (this.maxLabel < 65536) {
                    this.colorModel = COLOR_MODEL_GRAY_UINT16;
                    metadataBuilder.pixelType(PixelType.UINT16);
                } else {
                    this.colorModel = ColorModelFactory.createColorModel(PixelType.FLOAT32, ColorMaps.createColorMap("labels", 255, 255, 255), 0, 0.0, (double)this.maxLabel, -1, null);
                    metadataBuilder.pixelType(PixelType.FLOAT32);
                }
            } else if (this.maxLabel < 65536) {
                this.colorModel = ColorModelFactory.createIndexedColorModel(colors, false);
                if (this.maxLabel > 255) {
                    metadataBuilder.pixelType(PixelType.UINT16);
                }
            } else {
                this.colorModel = ColorModelFactory.getDummyColorModel(32);
                metadataBuilder.channels(ImageChannel.getDefaultRGBChannels());
            }
        }
        this.originalMetadata = metadataBuilder.build();
    }

    private static PathClass getPathClass(PathClass pathClass) {
        return pathClass == null ? PathClass.NULL_CLASS : pathClass;
    }

    private PathClass getPathClass(PathObject pathObject) {
        if (this.instanceClassMap != null) {
            return LabeledImageServer.instanceLabelToClass(this.instanceClassMap.get(pathObject));
        }
        return LabeledImageServer.getPathClass(pathObject.getPathClass());
    }

    private static PathClass instanceLabelToClass(Integer label) {
        if (label == null) {
            return null;
        }
        return PathClass.getInstance("Label " + label);
    }

    public Map<PathObject, Integer> getInstanceLabels() {
        if (this.instanceClassMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.instanceClassMap);
    }

    public Map<PathClass, Integer> getLabels() {
        if (this.params.createInstanceLabels) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.params.labels);
    }

    public Map<PathClass, Integer> getBoundaryLabels() {
        if (this.params.createInstanceLabels) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.params.boundaryLabels);
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return null;
    }

    @Override
    public Collection<URI> getURIs() {
        return Collections.emptyList();
    }

    @Override
    protected String createID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public boolean isEmptyRegion(RegionRequest request) {
        double thicknessScale = request.getDownsample() / this.getDownsampleForResolution(0);
        int pad = (int)Math.ceil((double)this.params.lineThickness * thicknessScale);
        RegionRequest request2 = pad > 0 ? request.pad2D(pad, pad) : request;
        return !this.getObjectsForRegion(request2).stream().anyMatch(p -> RoiTools.intersectsRegion(p.getROI(), request2));
    }

    public List<PathObject> getObjectsForRegion(ImageRegion region) {
        return this.hierarchy.getAllObjectsForRegion(region, null).stream().filter(this.params.objectFilter).filter(p -> this.params.createInstanceLabels || this.params.labels.containsKey(p.getPathClass()) || this.params.boundaryLabels.containsKey(p.getPathClass())).toList();
    }

    @Override
    public String getServerType() {
        return "Labelled image";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    @Override
    public void setMetadata(ImageServerMetadata metadata) {
        throw new IllegalArgumentException("Metadata cannot be set for a labelled image server!");
    }

    @Override
    protected BufferedImage createDefaultRGBImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        long startTime = System.currentTimeMillis();
        List<PathObject> pathObjects = this.hierarchy.getAllObjectsForRegion(tileRequest.getRegionRequest(), null).stream().filter(this.params.objectFilter).toList();
        BufferedImage img = this.multichannelOutput ? this.createMultichannelTile(tileRequest, pathObjects) : this.createIndexedColorTile(tileRequest, pathObjects);
        long endTime = System.currentTimeMillis();
        logger.trace("Labelled tile rendered in {} ms", (Object)(endTime - startTime));
        return img;
    }

    private BufferedImage createMultichannelTile(TileRequest tileRequest, Collection<PathObject> pathObjects) {
        int nChannels = this.nChannels();
        if (nChannels == 1) {
            return this.createBinaryTile(tileRequest, pathObjects, 0);
        }
        int tileWidth = tileRequest.getTileWidth();
        int tileHeight = tileRequest.getTileHeight();
        byte[][] dataArray = new byte[nChannels][];
        for (int i = 0; i < nChannels; ++i) {
            BufferedImage tile = this.createBinaryTile(tileRequest, pathObjects, i);
            dataArray[i] = ((DataBufferByte)tile.getRaster().getDataBuffer()).getData();
        }
        DataBufferByte buffer = new DataBufferByte(dataArray, tileWidth * tileHeight);
        int[] offsets = new int[nChannels];
        for (int b = 0; b < nChannels; ++b) {
            offsets[b] = b * tileWidth * tileHeight;
        }
        BandedSampleModel sampleModel = new BandedSampleModel(buffer.getDataType(), tileWidth, tileHeight, nChannels);
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, buffer, null);
        return new BufferedImage(this.colorModel, raster, false, null);
    }

    private BufferedImage createBinaryTile(TileRequest tileRequest, Collection<PathObject> pathObjects, int label) {
        int width = tileRequest.getTileWidth();
        int height = tileRequest.getTileHeight();
        BufferedImage img = new BufferedImage(width, height, 10);
        WritableRaster raster = img.getRaster();
        Graphics2D g2d = img.createGraphics();
        if (!pathObjects.isEmpty()) {
            ROI roi;
            RegionRequest request = tileRequest.getRegionRequest();
            double downsampleFactor = request.getDownsample();
            g2d.setClip(0, 0, width, height);
            double scale = 1.0 / downsampleFactor;
            g2d.scale(scale, scale);
            g2d.translate(-request.getX(), -request.getY());
            g2d.setColor(Color.WHITE);
            BasicStroke stroke = new BasicStroke((float)((double)this.params.lineThickness * tileRequest.getDownsample()));
            g2d.setStroke(stroke);
            for (Map.Entry<PathClass, Integer> entry : this.params.labels.entrySet()) {
                if (entry.getValue() != label) continue;
                PathClass pathClass = LabeledImageServer.getPathClass(entry.getKey());
                for (PathObject pathObject : pathObjects) {
                    if (this.getPathClass(pathObject) != pathClass) continue;
                    roi = this.params.roiFunction.apply(pathObject);
                    if (roi.isArea()) {
                        g2d.fill(roi.getShape());
                        continue;
                    }
                    if (roi.isLine()) {
                        g2d.draw(roi.getShape());
                        continue;
                    }
                    if (!roi.isPoint()) continue;
                    for (Point2 p : roi.getAllPoints()) {
                        int x = (int)((p.getX() - (double)request.getX()) / downsampleFactor);
                        int y = (int)((p.getY() - (double)request.getY()) / downsampleFactor);
                        if (x < 0 || x >= width || y < 0 || y >= height) continue;
                        raster.setSample(x, y, 0, 255);
                    }
                }
            }
            for (Map.Entry<PathClass, Integer> entry : this.params.boundaryLabels.entrySet()) {
                if (entry.getValue() != label) continue;
                for (PathObject pathObject : pathObjects) {
                    PathClass pathClass = this.getPathClass(pathObject);
                    if (!this.params.labels.containsKey(pathClass) || !(roi = this.params.roiFunction.apply(pathObject)).isArea()) continue;
                    Shape shape = roi.getShape();
                    g2d.draw(shape);
                }
            }
        }
        g2d.dispose();
        return img;
    }

    private static Color getColorForLabel(int label, boolean doRGB) {
        if (doRGB) {
            return new Color(label, false);
        }
        return ColorToolsAwt.getCachedColor(label, label, label);
    }

    private BufferedImage createIndexedColorTile(TileRequest tileRequest, Collection<PathObject> pathObjects) {
        RegionRequest request = tileRequest.getRegionRequest();
        double downsampleFactor = request.getDownsample();
        int width = tileRequest.getTileWidth();
        int height = tileRequest.getTileHeight();
        boolean doRGB = this.maxLabel > 255;
        BufferedImage img = doRGB ? new BufferedImage(width, height, 1) : new BufferedImage(width, height, 10);
        WritableRaster raster = img.getRaster();
        Graphics2D g2d = img.createGraphics();
        int bgLabel = this.params.labels.get(this.params.unannotatedClass);
        Color color = LabeledImageServer.getColorForLabel(bgLabel, doRGB);
        g2d.setColor(color);
        g2d.fillRect(0, 0, width, height);
        if (this.instanceClassMapInverse != null && pathObjects.size() > 5 && !(pathObjects instanceof Set)) {
            pathObjects = new HashSet<PathObject>(pathObjects);
        }
        if (!pathObjects.isEmpty()) {
            g2d.setClip(0, 0, width, height);
            double scale = 1.0 / downsampleFactor;
            g2d.scale(scale, scale);
            g2d.translate(-request.getX(), -request.getY());
            BasicStroke stroke = new BasicStroke((float)((double)this.params.lineThickness * tileRequest.getDownsample()));
            g2d.setStroke(stroke);
            for (Map.Entry<PathClass, Integer> entry : this.params.labels.entrySet()) {
                List<Object> toDraw;
                PathClass pathClass = LabeledImageServer.getPathClass(entry.getKey());
                int c = entry.getValue();
                color = LabeledImageServer.getColorForLabel(c, doRGB);
                if (this.instanceClassMapInverse != null) {
                    PathObject temp = this.instanceClassMapInverse.get(c);
                    if (temp == null || !pathObjects.contains(temp)) continue;
                    toDraw = Collections.singletonList(temp);
                } else {
                    toDraw = pathObjects.stream().filter(p -> this.getPathClass((PathObject)p) == pathClass).toList();
                }
                for (PathObject pathObject : toDraw) {
                    ROI roi = this.params.roiFunction.apply(pathObject);
                    g2d.setColor(color);
                    if (roi.isArea()) {
                        g2d.fill(roi.getShape());
                        continue;
                    }
                    if (roi.isLine()) {
                        g2d.draw(roi.getShape());
                        continue;
                    }
                    if (!roi.isPoint()) continue;
                    for (Point2 p2 : roi.getAllPoints()) {
                        int x = (int)((p2.getX() - (double)request.getX()) / downsampleFactor);
                        int y = (int)((p2.getY() - (double)request.getY()) / downsampleFactor);
                        if (x < 0 || x >= width || y < 0 || y >= height) continue;
                        if (doRGB) {
                            img.setRGB(x, y, color.getRGB());
                            continue;
                        }
                        raster.setSample(x, y, 0, c);
                    }
                }
            }
            for (Map.Entry<PathClass, Integer> entry : this.params.boundaryLabels.entrySet()) {
                int c = entry.getValue();
                color = LabeledImageServer.getColorForLabel(c, doRGB);
                for (PathObject pathObject : pathObjects) {
                    ROI roi;
                    PathClass pathClass = this.getPathClass(pathObject);
                    if (!this.params.labels.containsKey(pathClass) || !(roi = this.params.roiFunction.apply(pathObject)).isArea()) continue;
                    g2d.setColor(color);
                    g2d.draw(roi.getShape());
                }
            }
        }
        g2d.dispose();
        if (doRGB) {
            WritableRaster shortRaster = null;
            int w = img.getWidth();
            int h = img.getHeight();
            switch (this.getPixelType()) {
                case UINT8: {
                    return img;
                }
                case FLOAT32: {
                    shortRaster = WritableRaster.createWritableRaster(new BandedSampleModel(4, w, h, 1), null);
                    break;
                }
                case FLOAT64: {
                    shortRaster = WritableRaster.createWritableRaster(new BandedSampleModel(5, w, h, 1), null);
                    break;
                }
                case INT16: {
                    shortRaster = WritableRaster.createWritableRaster(new BandedSampleModel(2, w, h, 1), null);
                    break;
                }
                case INT8: 
                case UINT16: {
                    shortRaster = WritableRaster.createWritableRaster(new BandedSampleModel(1, w, h, 1), null);
                    break;
                }
                case INT32: 
                case UINT32: {
                    shortRaster = WritableRaster.createWritableRaster(new BandedSampleModel(3, w, h, 1), null);
                    break;
                }
            }
            if (this.maxLabel >= 65536 || shortRaster == null) {
                return img;
            }
            int[] samples = img.getRGB(0, 0, width, height, null, 0, width);
            shortRaster.setSamples(0, 0, width, height, 0, samples);
            raster = shortRaster;
        }
        return new BufferedImage(this.colorModel, raster, false, null);
    }

    private static class LabeledServerParameters {
        private PathClass unannotatedClass = PathClass.getInstance("*Background*");
        private Predicate<PathObject> objectFilter = PathObjectFilter.ANNOTATIONS;
        private Function<PathObject, ROI> roiFunction = p -> p.getROI();
        private boolean createInstanceLabels = false;
        private boolean shuffleInstanceLabels = true;
        private int maxOutputChannelLimit = 256;
        private boolean grayscaleLut = false;
        private float lineThickness = 1.0f;
        private Map<PathClass, Integer> labels = new LinkedHashMap<PathClass, Integer>();
        private Map<PathClass, Integer> boundaryLabels = new LinkedHashMap<PathClass, Integer>();
        private Map<Integer, Integer> labelColors = new LinkedHashMap<Integer, Integer>();

        LabeledServerParameters() {
            this.labels.put(this.unannotatedClass, 0);
            this.labelColors.put(0, ColorTools.WHITE);
        }

        LabeledServerParameters(LabeledServerParameters params) {
            this.unannotatedClass = params.unannotatedClass;
            this.lineThickness = params.lineThickness;
            this.objectFilter = params.objectFilter;
            this.labels = new LinkedHashMap<PathClass, Integer>(params.labels);
            this.boundaryLabels = new LinkedHashMap<PathClass, Integer>(params.boundaryLabels);
            this.labelColors = new LinkedHashMap<Integer, Integer>(params.labelColors);
            this.createInstanceLabels = params.createInstanceLabels;
            this.maxOutputChannelLimit = params.maxOutputChannelLimit;
            this.roiFunction = params.roiFunction;
            this.grayscaleLut = params.grayscaleLut;
            this.shuffleInstanceLabels = params.shuffleInstanceLabels;
        }
    }

    public static class Builder {
        private ImageData<BufferedImage> imageData;
        private double downsample = 1.0;
        private int tileWidth;
        private int tileHeight;
        private boolean multichannelOutput = false;
        private LabeledServerParameters params = new LabeledServerParameters();

        public Builder(ImageData<BufferedImage> imageData) {
            this.imageData = imageData;
        }

        public Builder useDetections() {
            this.params.objectFilter = PathObjectFilter.DETECTIONS_ALL;
            return this;
        }

        public Builder useCells() {
            this.params.objectFilter = PathObjectFilter.CELLS;
            return this;
        }

        public Builder useCellNuclei() {
            this.params.objectFilter = PathObjectFilter.CELLS;
            this.params.roiFunction = p -> PathObjectTools.getROI(p, true);
            return this;
        }

        public Builder useAnnotations() {
            this.params.objectFilter = PathObjectFilter.ANNOTATIONS;
            return this;
        }

        public Builder useFilter(Predicate<PathObject> filter) {
            this.params.objectFilter = filter;
            return this;
        }

        public Builder grayscale() {
            return this.grayscale(true);
        }

        public Builder grayscale(boolean grayscaleLut) {
            this.params.grayscaleLut = grayscaleLut;
            return this;
        }

        public Builder downsample(double downsample) {
            this.downsample = downsample;
            return this;
        }

        public Builder tileSize(int tileSize) {
            return this.tileSize(tileSize, tileSize);
        }

        public Builder tileSize(int tileWidth, int tileHeight) {
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            return this;
        }

        public Builder lineThickness(float thickness) {
            this.params.lineThickness = thickness;
            return this;
        }

        @Deprecated
        public Builder useUniqueLabels() {
            logger.warn("useUniqueLabels() is deprecated; please switch to useInstanceLabels() instead.");
            return this.useInstanceLabels();
        }

        public Builder useInstanceLabels() {
            return this.useInstanceLabels(true);
        }

        public Builder useInstanceLabels(boolean instanceLabels) {
            this.params.createInstanceLabels = instanceLabels;
            return this;
        }

        public Builder shuffleInstanceLabels(boolean doShuffle) {
            this.params.shuffleInstanceLabels = doShuffle;
            return this;
        }

        public Builder multichannelOutput(boolean doMultichannel) {
            this.multichannelOutput = doMultichannel;
            return this;
        }

        public Builder backgroundLabel(int label) {
            return this.backgroundLabel(label, ColorTools.packRGB(255, 255, 255));
        }

        public Builder backgroundLabel(int label, Integer color) {
            this.addLabel(this.params.unannotatedClass, label, color);
            return this;
        }

        public Builder addLabelsByName(Map<String, Integer> labelMap) {
            for (Map.Entry<String, Integer> entry : labelMap.entrySet()) {
                this.addLabel(entry.getKey(), (int)entry.getValue());
            }
            return this;
        }

        public Builder addLabels(Map<PathClass, Integer> labelMap) {
            for (Map.Entry<PathClass, Integer> entry : labelMap.entrySet()) {
                this.addLabel(entry.getKey(), (int)entry.getValue());
            }
            return this;
        }

        public Builder addLabel(String pathClassName, int label) {
            return this.addLabel(pathClassName, label, null);
        }

        public Builder addLabel(String pathClassName, int label, Integer color) {
            return this.addLabel(PathClass.fromString(pathClassName), label, color);
        }

        public Builder addLabel(PathClass pathClass, int label) {
            return this.addLabel(pathClass, label, null);
        }

        public Builder addLabel(PathClass pathClass, int label, Integer color) {
            return this.addLabel(this.params.labels, pathClass, label, color);
        }

        public Builder addUnclassifiedLabel(int label, Integer color) {
            return this.addLabel(this.params.labels, PathClass.NULL_CLASS, label, color);
        }

        public Builder addUnclassifiedLabel(int label) {
            return this.addLabel(this.params.labels, PathClass.NULL_CLASS, label, null);
        }

        public Builder setBoundaryLabel(PathClass pathClass, int label) {
            return this.setBoundaryLabel(pathClass, label, null);
        }

        public Builder setBoundaryLabel(PathClass pathClass, int label, Integer color) {
            this.params.boundaryLabels.clear();
            return this.addLabel(this.params.boundaryLabels, pathClass, label, color);
        }

        public Builder setBoundaryLabel(String pathClassName, int label) {
            return this.setBoundaryLabel(pathClassName, label, null);
        }

        public Builder setBoundaryLabel(String pathClassName, int label, Integer color) {
            return this.setBoundaryLabel(PathClass.fromString(pathClassName), label, color);
        }

        private Builder addLabel(Map<PathClass, Integer> map, PathClass pathClass, int label, Integer color) {
            pathClass = LabeledImageServer.getPathClass(pathClass);
            map.put(pathClass, label);
            if (color != null) {
                this.params.labelColors.put(label, color);
            } else if (!this.params.labelColors.containsKey(label)) {
                this.params.labelColors.put(label, pathClass.getColor());
            }
            return this;
        }

        public Builder maxOutputChannelLimit(int maxChannels) {
            this.params.maxOutputChannelLimit = maxChannels;
            return this;
        }

        public LabeledImageServer build() {
            if (this.params.createInstanceLabels) {
                if (!(this.params.labels.isEmpty() || this.params.labels.size() == 1 && this.params.labels.containsKey(this.params.unannotatedClass))) {
                    throw new IllegalArgumentException("You cannot use both useInstanceLabels() and addLabel() - please choose one or the other!");
                }
                if (this.params.objectFilter == null) {
                    throw new IllegalArgumentException("Please specify an object filter with useInstanceLabels(), for example useDetections(), useCells(), useAnnotations(), useFilter()");
                }
            }
            return new LabeledImageServer(this.imageData, this.downsample, this.tileWidth, this.tileHeight, new LabeledServerParameters(this.params), this.multichannelOutput);
        }
    }
}

