/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import qupath.lib.common.GeneralTools;

public class PixelCalibration {
    public static final String PIXEL = "px";
    public static final String MICROMETER = GeneralTools.micrometerSymbol();
    public static final String Z_SLICE = "z-slice";
    private SimpleQuantity pixelWidth = SimpleQuantity.DEFAULT_PIXEL_SIZE;
    private SimpleQuantity pixelHeight = SimpleQuantity.DEFAULT_PIXEL_SIZE;
    private SimpleQuantity zSpacing = SimpleQuantity.DEFAULT_Z_SPACING;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private double[] timepoints = new double[0];
    private static PixelCalibration DEFAULT_INSTANCE = new Builder().build();

    private PixelCalibration() {
    }

    private PixelCalibration duplicate() {
        PixelCalibration cal = new PixelCalibration();
        cal.pixelWidth = new SimpleQuantity(this.pixelWidth.value, this.pixelWidth.unit);
        cal.pixelHeight = new SimpleQuantity(this.pixelHeight.value, this.pixelHeight.unit);
        cal.zSpacing = new SimpleQuantity(this.zSpacing.value, this.zSpacing.unit);
        cal.timeUnit = this.timeUnit;
        cal.timepoints = this.timepoints == null ? null : (double[])this.timepoints.clone();
        return cal;
    }

    public PixelCalibration createScaledInstance(double scaleX, double scaleY) {
        return this.createScaledInstance(scaleX, scaleY, 1.0);
    }

    public PixelCalibration createScaledInstance(double scaleX, double scaleY, double scaleZ) {
        PixelCalibration cal2 = this.duplicate();
        cal2.pixelWidth = this.pixelWidth.scale(scaleX);
        cal2.pixelHeight = this.pixelHeight.scale(scaleY);
        cal2.zSpacing = this.zSpacing.scale(scaleZ);
        return cal2;
    }

    private static Number multiply(Number n1, double scale) {
        if (n1 instanceof BigInteger) {
            n1 = new BigDecimal((BigInteger)n1);
        }
        if (n1 instanceof BigDecimal) {
            return ((BigDecimal)n1).multiply(BigDecimal.valueOf(scale));
        }
        return n1.doubleValue() * scale;
    }

    private static Number average(Number n1, Number n2) {
        Number half1 = PixelCalibration.multiply(n1, 0.5);
        Number half2 = PixelCalibration.multiply(n2, 0.5);
        return PixelCalibration.add(half1, half2);
    }

    private static Number add(Number n1, Number n2) {
        if (n1 instanceof BigInteger) {
            n1 = new BigDecimal((BigInteger)n2);
        }
        if (n2 instanceof BigInteger) {
            n2 = new BigDecimal((BigInteger)n2);
        }
        if (n1 instanceof BigDecimal && n2 instanceof BigDecimal) {
            return ((BigDecimal)n1).add((BigDecimal)n2);
        }
        return n1.doubleValue() + n2.doubleValue();
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int nTimepoints() {
        return this.timepoints.length;
    }

    public double getTimepoint(int ind) {
        return ind >= this.timepoints.length ? Double.NaN : this.timepoints[ind];
    }

    public boolean hasPixelSizeMicrons() {
        return MICROMETER.equals(this.pixelWidth.unit) && MICROMETER.equals(this.pixelHeight.unit);
    }

    public boolean hasZSpacingMicrons() {
        return MICROMETER.equals(this.zSpacing.unit);
    }

    public double getAveragedPixelSizeMicrons() {
        return (this.getPixelWidthMicrons() + this.getPixelHeightMicrons()) / 2.0;
    }

    public double getZSpacingMicrons() {
        if (this.hasZSpacingMicrons()) {
            return this.zSpacing.value;
        }
        return Double.NaN;
    }

    public double getPixelWidthMicrons() {
        if (this.hasPixelSizeMicrons()) {
            return this.pixelWidth.value;
        }
        return Double.NaN;
    }

    public double getPixelHeightMicrons() {
        if (this.hasPixelSizeMicrons()) {
            return this.pixelHeight.value;
        }
        return Double.NaN;
    }

    public String getPixelWidthUnit() {
        return this.pixelWidth.unit;
    }

    public boolean unitsMatch2D() {
        return Objects.equals(this.getPixelHeightUnit(), this.getPixelHeightUnit());
    }

    public boolean unitsMatch3D() {
        return this.unitsMatch2D() && Objects.equals(this.getPixelHeightUnit(), this.getZSpacingUnit());
    }

    public String getPixelHeightUnit() {
        return this.pixelHeight.unit;
    }

    public String getZSpacingUnit() {
        return this.zSpacing.unit;
    }

    public Number getAveragedPixelSize() {
        return PixelCalibration.average(this.getPixelWidth(), this.getPixelHeight());
    }

    public Number getPixelWidth() {
        return this.pixelWidth.value;
    }

    public Number getPixelHeight() {
        return this.pixelHeight.value;
    }

    public Number getZSpacing() {
        return this.zSpacing.value;
    }

    public String toString() {
        return String.format("Pixel calibration: x=%s, y=%s, z=%s, t=%s", this.pixelWidth.toString(), this.pixelHeight.toString(), this.zSpacing.toString(), this.timeUnit.toString());
    }

    public static PixelCalibration getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pixelHeight == null ? 0 : this.pixelHeight.hashCode());
        result = 31 * result + (this.pixelWidth == null ? 0 : this.pixelWidth.hashCode());
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        result = 31 * result + Arrays.hashCode(this.timepoints);
        result = 31 * result + (this.zSpacing == null ? 0 : this.zSpacing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PixelCalibration other = (PixelCalibration)obj;
        if (this.pixelHeight == null ? other.pixelHeight != null : !this.pixelHeight.equals(other.pixelHeight)) {
            return false;
        }
        if (this.pixelWidth == null ? other.pixelWidth != null : !this.pixelWidth.equals(other.pixelWidth)) {
            return false;
        }
        if (this.timeUnit != other.timeUnit) {
            return false;
        }
        if (!Arrays.equals(this.timepoints, other.timepoints)) {
            return false;
        }
        return !(this.zSpacing == null ? other.zSpacing != null : !this.zSpacing.equals(other.zSpacing));
    }

    static class SimpleQuantity {
        private Double value;
        private String unit;
        private static SimpleQuantity DEFAULT_PIXEL_SIZE = new SimpleQuantity(1, "px");
        private static SimpleQuantity DEFAULT_Z_SPACING = new SimpleQuantity(1, "z-slice");

        static SimpleQuantity getLengthMicrometers(Number value) {
            return new SimpleQuantity(value, MICROMETER);
        }

        private SimpleQuantity(Number value, String unit) {
            this.value = value.doubleValue();
            this.unit = unit;
        }

        public String toString() {
            return this.value + " " + this.unit;
        }

        private SimpleQuantity scale(double scale) {
            return new SimpleQuantity(PixelCalibration.multiply(this.value, scale), this.unit);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleQuantity other = (SimpleQuantity)obj;
            if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class Builder {
        PixelCalibration cal = new PixelCalibration();

        public Builder() {
        }

        public Builder(PixelCalibration cal) {
            this.cal = cal.duplicate();
        }

        public Builder pixelSizeMicrons(Number pixelWidthMicrons, Number pixelHeightMicrons) {
            if ((pixelWidthMicrons == null || Double.isNaN(pixelWidthMicrons.doubleValue())) && (pixelHeightMicrons == null || Double.isNaN(pixelHeightMicrons.doubleValue()))) {
                this.cal.pixelWidth = SimpleQuantity.DEFAULT_PIXEL_SIZE;
                this.cal.pixelHeight = SimpleQuantity.DEFAULT_PIXEL_SIZE;
                return this;
            }
            if (!Double.isFinite(pixelWidthMicrons.doubleValue()) || pixelWidthMicrons.doubleValue() <= 0.0) {
                throw new IllegalArgumentException("Pixel width must be a finite number > 0, not " + String.valueOf(pixelWidthMicrons));
            }
            if (!Double.isFinite(pixelHeightMicrons.doubleValue()) || pixelHeightMicrons.doubleValue() <= 0.0) {
                throw new IllegalArgumentException("Pixel height must be a finite number > 0, not " + String.valueOf(pixelHeightMicrons));
            }
            this.cal.pixelWidth = SimpleQuantity.getLengthMicrometers(pixelWidthMicrons);
            this.cal.pixelHeight = SimpleQuantity.getLengthMicrometers(pixelHeightMicrons);
            return this;
        }

        public Builder timepoints(TimeUnit timeUnit, double ... timepoints) {
            this.cal.timeUnit = timeUnit;
            this.cal.timepoints = (double[])timepoints.clone();
            return this;
        }

        public Builder zSpacingMicrons(Number zSpacingMicrons) {
            if (zSpacingMicrons == null || Double.isNaN(zSpacingMicrons.doubleValue())) {
                this.cal.zSpacing = SimpleQuantity.DEFAULT_Z_SPACING;
                return this;
            }
            if (!Double.isFinite(zSpacingMicrons.doubleValue()) || zSpacingMicrons.doubleValue() <= 0.0) {
                throw new IllegalArgumentException("Z-spacing must be a finite number > 0, not " + String.valueOf(zSpacingMicrons));
            }
            this.cal.zSpacing = SimpleQuantity.getLengthMicrometers(zSpacingMicrons);
            return this;
        }

        public PixelCalibration build() {
            return this.cal;
        }
    }
}

