/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.regions.RegionRequest;

class RasterOpImageServer
extends TransformingImageServer<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(RasterOpImageServer.class);
    private String opName;
    private RasterOp op;
    private transient boolean tryInPlace = true;

    protected RasterOpImageServer(ImageServer<BufferedImage> server, String opName, RasterOp op) {
        super(server);
        this.opName = opName;
        this.op = op;
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return null;
    }

    @Override
    protected String createID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request);
        if (this.tryInPlace) {
            try {
                this.op.filter(img.getRaster(), img.getRaster());
                return img;
            }
            catch (Exception e) {
                logger.trace("Unable to apply op in place: {}", (Object)e.getLocalizedMessage());
                this.tryInPlace = false;
            }
        }
        WritableRaster raster = this.op.filter(img.getRaster(), null);
        return new BufferedImage(img.getColorModel(), raster, img.isAlphaPremultiplied(), null);
    }

    @Override
    public String getPath() {
        return this.getWrappedServer().getPath() + " (" + this.opName + ")";
    }

    @Override
    public String getServerType() {
        return super.getWrappedServer().getServerType() + " (" + this.opName + ")";
    }
}

