/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.regions.RegionRequest;

public class RotatedImageServer
extends TransformingImageServer<BufferedImage> {
    private ImageServerMetadata metadata;
    private Rotation rotation;

    public RotatedImageServer(ImageServer<BufferedImage> server, Rotation rotation) {
        super(server);
        this.rotation = rotation;
        switch (rotation.ordinal()) {
            case 1: 
            case 3: {
                this.metadata = this.getQuarterRotatedMetadata(server.getOriginalMetadata());
                break;
            }
            case 2: {
                this.metadata = new ImageServerMetadata.Builder(server.getOriginalMetadata()).build();
                break;
            }
            default: {
                this.metadata = server.getOriginalMetadata().duplicate();
            }
        }
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    private ImageServerMetadata getQuarterRotatedMetadata(ImageServerMetadata metadata) {
        ImageServerMetadata.ImageResolutionLevel.Builder levelBuilder = new ImageServerMetadata.ImageResolutionLevel.Builder(metadata.getHeight(), metadata.getWidth());
        for (int i = 0; i < metadata.nLevels(); ++i) {
            ImageServerMetadata.ImageResolutionLevel level = metadata.getLevel(i);
            levelBuilder.addLevel(level.getDownsample(), level.getHeight(), level.getWidth());
        }
        ImageServerMetadata.Builder builder = new ImageServerMetadata.Builder(metadata).width(metadata.getHeight()).height(metadata.getWidth()).preferredTileSize(metadata.getPreferredTileHeight(), metadata.getPreferredTileWidth()).levels(levelBuilder.build());
        if (metadata.pixelSizeCalibrated()) {
            builder.pixelSizeMicrons(metadata.getPixelHeightMicrons(), metadata.getPixelWidthMicrons());
        }
        return builder.build();
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        switch (this.rotation.ordinal()) {
            case 2: {
                return this.rotate180(request);
            }
            case 3: {
                return this.rotate270(request);
            }
            case 1: {
                return this.rotate90(request);
            }
        }
        return (BufferedImage)this.getWrappedServer().readRegion(request.updatePath(this.getWrappedServer().getPath()));
    }

    private BufferedImage rotate90(RegionRequest request) throws IOException {
        RegionRequest request2 = this.rotateRequest(request);
        if (request2.getWidth() <= 0 || request2.getHeight() <= 0 || this.getWrappedServer().isEmptyRegion(request2)) {
            return null;
        }
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request2);
        if (img == null) {
            return null;
        }
        WritableRaster raster = img.getRaster();
        int w = raster.getWidth();
        int h = raster.getHeight();
        WritableRaster raster2 = raster.createCompatibleWritableRaster(h, w);
        float[] samples = new float[w * h];
        float[] samples2 = new float[w * h];
        for (int b = 0; b < raster.getNumBands(); ++b) {
            samples = raster.getSamples(0, 0, w, h, b, samples);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int ind1 = y * w + x;
                    int ind2 = x * h + (h - y - 1);
                    float temp = samples[ind1];
                    samples[ind1] = samples[ind2];
                    samples2[ind2] = temp;
                }
            }
            raster2.setSamples(0, 0, h, w, b, samples2);
        }
        return new BufferedImage(img.getColorModel(), raster2, img.isAlphaPremultiplied(), null);
    }

    private BufferedImage rotate180(RegionRequest request) throws IOException {
        RegionRequest request2 = this.rotateRequest(request);
        if (request2.getWidth() <= 0 || request2.getHeight() <= 0 || this.getWrappedServer().isEmptyRegion(request2)) {
            return null;
        }
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request2);
        if (img == null) {
            return null;
        }
        WritableRaster raster = img.getRaster();
        int w = raster.getWidth();
        int h = raster.getHeight();
        float[] samples = new float[w * h];
        for (int b = 0; b < raster.getNumBands(); ++b) {
            samples = raster.getSamples(0, 0, w, h, b, samples);
            for (int ind1 = 0; ind1 < w * h / 2; ++ind1) {
                int ind2 = w * h - ind1 - 1;
                float temp = samples[ind1];
                samples[ind1] = samples[ind2];
                samples[ind2] = temp;
            }
            raster.setSamples(0, 0, w, h, b, samples);
        }
        return img;
    }

    private BufferedImage rotate270(RegionRequest request) throws IOException {
        RegionRequest request2 = this.rotateRequest(request);
        if (request2.getWidth() <= 0 || request2.getHeight() <= 0 || this.getWrappedServer().isEmptyRegion(request2)) {
            return null;
        }
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request2);
        if (img == null) {
            return null;
        }
        WritableRaster raster = img.getRaster();
        int w = raster.getWidth();
        int h = raster.getHeight();
        WritableRaster raster2 = raster.createCompatibleWritableRaster(h, w);
        float[] samples = new float[w * h];
        float[] samples2 = new float[w * h];
        for (int b = 0; b < raster.getNumBands(); ++b) {
            samples = raster.getSamples(0, 0, w, h, b, samples);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int ind1 = y * w + x;
                    int ind2 = (w - x - 1) * h + y;
                    float temp = samples[ind1];
                    samples[ind1] = samples[ind2];
                    samples2[ind2] = temp;
                }
            }
            raster2.setSamples(0, 0, h, w, b, samples2);
        }
        return new BufferedImage(img.getColorModel(), raster2, img.isAlphaPremultiplied(), null);
    }

    private RegionRequest rotateRequest(RegionRequest request) {
        String path = this.getWrappedServer().getPath();
        switch (this.rotation.ordinal()) {
            case 2: {
                return RegionRequest.createInstance(path, request.getDownsample(), this.getWidth() - request.getX() - request.getWidth(), this.getHeight() - request.getY() - request.getHeight(), request.getWidth(), request.getHeight(), request.getZ(), request.getT());
            }
            case 3: {
                return RegionRequest.createInstance(path, request.getDownsample(), this.getHeight() - request.getY() - request.getHeight(), request.getX(), request.getHeight(), request.getWidth(), request.getZ(), request.getT());
            }
            case 1: {
                return RegionRequest.createInstance(path, request.getDownsample(), request.getY(), this.getWidth() - request.getX() - request.getWidth(), request.getHeight(), request.getWidth(), request.getZ(), request.getT());
            }
        }
        return request;
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    protected String createID() {
        int rot = 0;
        switch (this.rotation.ordinal()) {
            case 2: {
                rot = 180;
                break;
            }
            case 3: {
                rot = 270;
                break;
            }
            case 1: {
                rot = 90;
                break;
            }
            default: {
                rot = 0;
            }
        }
        return this.getClass().getName() + ": " + this.getWrappedServer().getPath() + " (Rotate=" + rot + ")";
    }

    @Override
    public String getServerType() {
        return this.getWrappedServer().getServerType() + " (" + String.valueOf((Object)this.rotation) + ")";
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.RotatedImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.getRotation());
    }

    public static ImageServerBuilder.ServerBuilder<BufferedImage> getRotatedBuilder(ImageServerBuilder.ServerBuilder<BufferedImage> builder, Rotation rotation) {
        return new ImageServers.RotatedImageServerBuilder(null, builder, rotation);
    }

    public static enum Rotation {
        ROTATE_NONE,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270;


        public String toString() {
            switch (this.ordinal()) {
                case 2: {
                    return "Rotate 180";
                }
                case 3: {
                    return "Rotate 270";
                }
                case 1: {
                    return "Rotate 90";
                }
                case 0: {
                    return "No rotation";
                }
            }
            return "Unknown rotation";
        }
    }
}

