/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.io.GsonTools;
import qupath.lib.regions.RegionRequest;

public class SlicedImageServer
extends TransformingImageServer<BufferedImage> {
    private final ImageServerMetadata metadata;
    private final int zStart;
    private final int zEnd;
    private final int tStart;
    private final int tEnd;

    SlicedImageServer(ImageServer<BufferedImage> inputServer, int zStart, int zEnd, int tStart, int tEnd) {
        super(inputServer);
        this.zStart = SlicedImageServer.setNumberInRange(zStart, 0, inputServer.nZSlices() - 1);
        this.zEnd = SlicedImageServer.setNumberInRange(zEnd, 1, inputServer.nZSlices());
        this.tStart = SlicedImageServer.setNumberInRange(tStart, 0, inputServer.nTimepoints() - 1);
        this.tEnd = SlicedImageServer.setNumberInRange(tEnd, 1, inputServer.nTimepoints());
        SlicedImageServer.checkOrder(this.zStart, this.zEnd, "z-slice");
        SlicedImageServer.checkOrder(this.tStart, this.tEnd, "timepoint");
        this.metadata = new ImageServerMetadata.Builder(inputServer.getMetadata()).sizeZ(this.zEnd - this.zStart).sizeT(this.tEnd - this.tStart).build();
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.SlicedImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.zStart, this.zEnd, this.tStart, this.tEnd);
    }

    @Override
    protected String createID() {
        return this.getClass().getName() + ": + " + this.getWrappedServer().getPath() + " " + GsonTools.getInstance().toJson(Map.of("minZSlice", this.zStart, "maxZSlice", this.zEnd, "minTimepoint", this.tStart, "maxTimepoint", this.tEnd));
    }

    @Override
    public String getServerType() {
        return "Sliced image server";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        return (BufferedImage)this.getWrappedServer().readRegion(RegionRequest.createInstance(request.getPath(), request.getDownsample(), request.getX(), request.getY(), request.getWidth(), request.getHeight(), request.getZ() + this.zStart, request.getT() + this.tStart));
    }

    private static int setNumberInRange(int number, int min, int max) {
        return Math.max(min, Math.min(number, max));
    }

    private static void checkOrder(int min, int max, String name) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("The min %s is greater than the max %s", name, name));
        }
    }
}

