/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class TileRequest {
    private static final Logger logger = LoggerFactory.getLogger(TileRequest.class);
    private final int level;
    private final ImageRegion tileRegion;
    private final RegionRequest request;

    static Collection<TileRequest> getAllTileRequests(ImageServer<?> server) {
        LinkedHashSet<TileRequest> set = new LinkedHashSet<TileRequest>();
        int tileWidth = server.getMetadata().getPreferredTileWidth();
        int tileHeight = server.getMetadata().getPreferredTileHeight();
        double[] downsamples = server.getPreferredDownsamples();
        for (int level = 0; level < downsamples.length; ++level) {
            ImageServerMetadata.ImageResolutionLevel resolutionLevel = server.getMetadata().getLevel(level);
            int height = resolutionLevel.getHeight();
            int width = resolutionLevel.getWidth();
            for (int t = 0; t < server.nTimepoints(); ++t) {
                for (int z = 0; z < server.nZSlices(); ++z) {
                    for (int y = 0; y < height; y += tileHeight) {
                        int th = tileHeight;
                        if (y + th > height) {
                            th = height - y;
                        }
                        for (int x = 0; x < width; x += tileWidth) {
                            int tw = tileWidth;
                            if (x + tw > width) {
                                tw = width - x;
                            }
                            TileRequest tile = TileRequest.createInstance(server, level, ImageRegion.createInstance(x, y, tw, th, z, t));
                            set.add(tile);
                        }
                    }
                }
            }
        }
        return set;
    }

    public static TileRequest createInstance(ImageServer<?> server, int level, ImageRegion tileRegion) {
        return TileRequest.createInstance(server.getPath(), level, server.getDownsampleForResolution(level), tileRegion);
    }

    public static TileRequest createInstance(String path, int level, double downsample, ImageRegion tileRegion) {
        return new TileRequest(TileRequest.getRegionRequest(path, downsample, tileRegion), level, tileRegion);
    }

    private static RegionRequest getRegionRequest(String path, double downsample, ImageRegion tileRegion) {
        double x1 = (double)tileRegion.getX() * downsample;
        double y1 = (double)tileRegion.getY() * downsample;
        double x2 = (double)(tileRegion.getX() + tileRegion.getWidth()) * downsample;
        double y2 = (double)(tileRegion.getY() + tileRegion.getHeight()) * downsample;
        return RegionRequest.createInstance(path, downsample, (int)Math.round(x1), (int)Math.round(y1), (int)Math.round(x2 - (double)Math.round(x1)), (int)Math.round(y2 - (double)Math.round(y1)), tileRegion.getZ(), tileRegion.getT());
    }

    public RegionRequest getRegionRequest() {
        return this.request;
    }

    private TileRequest(RegionRequest request, int level, ImageRegion tileRegion) {
        this.request = request;
        this.level = level;
        this.tileRegion = tileRegion;
    }

    public double getDownsample() {
        return this.request.getDownsample();
    }

    public int getLevel() {
        return this.level;
    }

    public int getImageX() {
        return this.request.getX();
    }

    public int getImageY() {
        return this.request.getY();
    }

    public int getImageWidth() {
        return this.request.getWidth();
    }

    public int getImageHeight() {
        return this.request.getHeight();
    }

    public int getTileX() {
        return this.tileRegion.getX();
    }

    public int getTileY() {
        return this.tileRegion.getY();
    }

    public int getTileWidth() {
        return this.tileRegion.getWidth();
    }

    public int getTileHeight() {
        return this.tileRegion.getHeight();
    }

    public int getZ() {
        return this.tileRegion.getZ();
    }

    public int getT() {
        return this.tileRegion.getT();
    }

    public ImagePlane getImagePlane() {
        return this.tileRegion.getImagePlane();
    }

    @Deprecated
    public ImagePlane getPlane() {
        LogTools.warnOnce(logger, "TileRequest.getPlane() is deprecated in v0.4.0 - use getImagePlane() instead");
        return this.getImagePlane();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.level;
        result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
        result = 31 * result + (this.tileRegion == null ? 0 : this.tileRegion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TileRequest other = (TileRequest)obj;
        if (this.level != other.level) {
            return false;
        }
        if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
            return false;
        }
        return !(this.tileRegion == null ? other.tileRegion != null : !this.tileRegion.equals(other.tileRegion));
    }

    public String toString() {
        return String.format("Tile: level=%d, bounds=(%d, %d, %d, %d), %s", this.level, this.tileRegion.getX(), this.tileRegion.getY(), this.tileRegion.getWidth(), this.tileRegion.getHeight(), this.request.toString());
    }
}

