/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;

public class TypeConvertImageServer
extends AbstractTileableImageServer {
    private static final Set<PixelType> INVALID_TYPES = Set.of(PixelType.INT8, PixelType.UINT32);
    private final ImageServer<BufferedImage> server;
    private final PixelType pixelType;
    private final ImageServerMetadata metadata;

    protected TypeConvertImageServer(ImageServer<BufferedImage> server, PixelType outputType) {
        if (INVALID_TYPES.contains((Object)outputType)) {
            throw new IllegalArgumentException("Invalid pixel type: " + String.valueOf((Object)outputType));
        }
        this.server = server;
        this.pixelType = outputType;
        this.metadata = new ImageServerMetadata.Builder(server.getMetadata()).pixelType(outputType).rgb(outputType == PixelType.UINT8 && Objects.equals(server.getMetadata().getChannels(), ImageChannel.getDefaultRGBChannels())).name(server.getMetadata().getName() + " (" + String.valueOf((Object)outputType) + ")").build();
    }

    protected ImageServer<BufferedImage> getWrappedServer() {
        return this.server;
    }

    @Override
    public Collection<URI> getURIs() {
        return this.getWrappedServer().getURIs();
    }

    @Override
    public String getServerType() {
        return "Type convert (" + String.valueOf((Object)this.pixelType) + ")";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        BufferedImage img = this.getWrappedServer().readRegion(tileRequest.getRegionRequest());
        return BufferedImageTools.convertImageType(img, this.pixelType, this.getMetadata().getChannels());
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.TypeConvertImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.pixelType);
    }

    @Override
    protected String createID() {
        return "Type converted: " + this.getWrappedServer().getPath() + " (" + String.valueOf((Object)this.pixelType) + ")";
    }
}

