/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.writers.ImageWriter;
import qupath.lib.regions.RegionRequest;

abstract class AbstractImageIOWriter
implements ImageWriter<BufferedImage> {
    AbstractImageIOWriter() {
    }

    @Override
    public Class<BufferedImage> getImageClass() {
        return BufferedImage.class;
    }

    @Override
    public boolean supportsT() {
        return false;
    }

    @Override
    public boolean supportsZ() {
        return false;
    }

    @Override
    public boolean supportsPyramidal() {
        return false;
    }

    @Override
    public boolean supportsPixelSize() {
        return false;
    }

    @Override
    public boolean supportsImageType(ImageServer<BufferedImage> server) {
        return server.isRGB() || server.nChannels() == 1 && server.getPixelType() == PixelType.UINT8;
    }

    @Override
    public boolean supportsRGB() {
        return true;
    }

    @Override
    public void writeImage(ImageServer<BufferedImage> server, RegionRequest request, String pathOutput) throws IOException {
        BufferedImage img = server.readRegion(request);
        this.writeImage(img, pathOutput);
    }

    @Override
    public void writeImage(BufferedImage img, String pathOutput) throws IOException {
        File file = new File(pathOutput);
        String ext = this.getDefaultExtension();
        if (!ImageIO.write((RenderedImage)img, ext, file)) {
            throw new IOException("Unable to write using ImageIO with extension " + ext);
        }
    }

    @Override
    public void writeImage(ImageServer<BufferedImage> server, String pathOutput) throws IOException {
        this.writeImage(server, RegionRequest.createInstance(server), pathOutput);
    }

    @Override
    public void writeImage(ImageServer<BufferedImage> server, RegionRequest request, OutputStream stream) throws IOException {
        BufferedImage img = server.readRegion(request);
        this.writeImage(img, stream);
    }

    @Override
    public void writeImage(BufferedImage img, OutputStream stream) throws IOException {
        String ext = this.getDefaultExtension();
        if (!ImageIO.write((RenderedImage)img, ext, stream)) {
            throw new IOException("Unable to write using ImageIO with extension " + ext);
        }
    }

    @Override
    public void writeImage(ImageServer<BufferedImage> server, OutputStream stream) throws IOException {
        this.writeImage(server, RegionRequest.createInstance(server), stream);
    }
}

