/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.regions.RegionRequest;

public interface ImageWriter<T> {
    public String getName();

    public Collection<String> getExtensions();

    default public String getDefaultExtension() {
        return this.getExtensions().iterator().next();
    }

    public boolean supportsT();

    public boolean supportsZ();

    public boolean supportsRGB();

    public boolean supportsImageType(ImageServer<T> var1);

    public boolean supportsPyramidal();

    public boolean supportsPixelSize();

    public String getDetails();

    public Class<T> getImageClass();

    public void writeImage(ImageServer<T> var1, RegionRequest var2, String var3) throws IOException;

    public void writeImage(T var1, String var2) throws IOException;

    public void writeImage(ImageServer<T> var1, String var2) throws IOException;

    public void writeImage(ImageServer<T> var1, RegionRequest var2, OutputStream var3) throws IOException;

    public void writeImage(T var1, OutputStream var2) throws IOException;

    public void writeImage(ImageServer<T> var1, OutputStream var2) throws IOException;
}

