/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.Strictness;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.io.FeatureCollection;
import qupath.lib.io.QuPathTypeAdapters;
import qupath.lib.io.ROITypeAdapters;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.interfaces.ROI;

public class GsonTools {
    private static final Logger logger = LoggerFactory.getLogger(GsonTools.class);
    private static GsonBuilder builder = new GsonBuilder().serializeSpecialFloatingPointValues().setStrictness(Strictness.LENIENT).registerTypeAdapterFactory((TypeAdapterFactory)new QuPathTypeAdapterFactory()).registerTypeAdapter(AffineTransform.class, (Object)AffineTransformTypeAdapter.INSTANCE);

    public static GsonBuilder getDefaultBuilder() {
        logger.trace("Requesting GsonBuilder from {}", (Object)Thread.currentThread().getStackTrace()[0]);
        return builder;
    }

    public static <T> SubTypeAdapterFactory<T> createSubTypeAdapterFactory(Class<T> baseType, String typeFieldName) {
        return new SubTypeAdapterFactory<T>(baseType, typeFieldName);
    }

    public static Gson getInstance() {
        return builder.create();
    }

    public static Gson getPrettyPrintInstance() {
        return GsonTools.getInstance().newBuilder().setPrettyPrinting().create();
    }

    public static Gson getInstance(boolean pretty) {
        if (pretty) {
            return GsonTools.getPrettyPrintInstance();
        }
        return GsonTools.getInstance();
    }

    public static List<PathObject> parseObjectsFromGeoJSON(JsonElement element) throws JsonParseException {
        Gson gson = GsonTools.getInstance();
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        GsonTools.addPathObjects(element, pathObjects, gson);
        return pathObjects;
    }

    private static boolean addPathObjects(JsonElement element, List<PathObject> pathObjects, Gson gson) {
        JsonObject jsonObject;
        if (element == null) {
            return false;
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            boolean changes = false;
            for (int i = 0; i < array.size(); ++i) {
                changes |= GsonTools.addPathObjects(array.get(i), pathObjects, gson);
            }
            return changes;
        }
        if (element.isJsonObject() && (jsonObject = element.getAsJsonObject()).has("type")) {
            String type;
            switch (type = jsonObject.get("type").getAsString()) {
                case "Feature": {
                    PathObject pathObject = (PathObject)gson.fromJson((JsonElement)jsonObject, PathObject.class);
                    if (pathObject == null) {
                        return false;
                    }
                    return pathObjects.add(pathObject);
                }
                case "FeatureCollection": {
                    FeatureCollection featureCollection = (FeatureCollection)gson.fromJson((JsonElement)jsonObject, FeatureCollection.class);
                    return pathObjects.addAll(featureCollection.getPathObjects());
                }
                case "Point": 
                case "MultiPoint": 
                case "LineString": 
                case "MultiLineString": 
                case "Polygon": 
                case "MultiPolygon": 
                case "GeometryCollection": {
                    logger.warn("Creating annotation from GeoJSON geometry {}", (Object)type);
                    Geometry geometry = (Geometry)gson.fromJson((JsonElement)jsonObject, Geometry.class);
                    geometry = GeometryTools.homogenizeGeometryCollection(geometry);
                    ROI roi = GeometryTools.geometryToROI(geometry, ImagePlane.getDefaultPlane());
                    PathObject annotation = PathObjects.createAnnotationObject(roi);
                    return pathObjects.add(annotation);
                }
            }
        }
        return false;
    }

    private static Integer arrayToRgb(int[] rgb) {
        if (rgb == null || rgb.length == 0) {
            return null;
        }
        if (rgb.length == 1) {
            return rgb[0];
        }
        if (rgb.length == 3) {
            return ColorTools.packRGB(rgb[0], rgb[1], rgb[2]);
        }
        if (rgb.length == 4) {
            return ColorTools.packARGB(rgb[3], rgb[0], rgb[1], rgb[2]);
        }
        throw new IllegalArgumentException("RGB array should have length 0, 1, 3 or 4 - not " + rgb.length);
    }

    public static class SubTypeAdapterFactory<T>
    implements TypeAdapterFactory {
        private static final Logger logger = LoggerFactory.getLogger(SubTypeAdapterFactory.class);
        private final Class<?> baseType;
        private final String typeFieldName;
        private final Map<String, Class<?>> labelToSubtype = new LinkedHashMap();
        private final Map<Class<?>, String> subtypeToLabel = new LinkedHashMap();
        private final Map<String, Class<?>> aliasToSubtype = new LinkedHashMap();

        private SubTypeAdapterFactory(Class<T> baseType, String typeFieldName) {
            Objects.requireNonNull(baseType, "baseType must not be null!");
            Objects.requireNonNull(typeFieldName, "typeFieldName must not be null!");
            this.typeFieldName = typeFieldName;
            this.baseType = baseType;
        }

        public synchronized <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
            if (!Objects.equals(type.getRawType(), this.baseType)) {
                return null;
            }
            return new SubTypeAdapter(gson).nullSafe();
        }

        public synchronized SubTypeAdapterFactory<T> registerSubtype(Class<? extends T> subtype, String label) {
            Objects.requireNonNull(subtype, "subtype must not be null!");
            Objects.requireNonNull(label, "label must not be null!");
            if (this.labelToSubtype.containsKey(label)) {
                throw new IllegalArgumentException("Label " + label + " is already assigned! Did you want to register an alias instead?");
            }
            this.labelToSubtype.put(label, subtype);
            this.subtypeToLabel.put(subtype, label);
            return this;
        }

        public synchronized SubTypeAdapterFactory<T> registerAlias(Class<? extends T> subtype, String alias) {
            Objects.requireNonNull(subtype, "subtype must not be null!");
            Objects.requireNonNull(alias, "label must not be null!");
            if (this.aliasToSubtype.containsKey(alias)) {
                if (Objects.equals(this.aliasToSubtype.get(alias), subtype)) {
                    return this;
                }
                logger.warn("Alias {} is already assigned to subtype {}, request will be ignored", (Object)alias, subtype);
            }
            this.aliasToSubtype.put(alias, subtype);
            return this;
        }

        public synchronized SubTypeAdapterFactory<T> registerSubtype(Class<? extends T> subtype) {
            return this.registerSubtype(subtype, subtype.getSimpleName());
        }

        private class SubTypeAdapter
        extends TypeAdapter<T> {
            private final Gson gson;
            private final Map<Class<?>, TypeAdapter<?>> subtypeToDelegate = new LinkedHashMap();

            private SubTypeAdapter(Gson gson) {
                this.gson = gson;
                for (Map.Entry<String, Class<?>> entry : SubTypeAdapterFactory.this.labelToSubtype.entrySet()) {
                    TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)SubTypeAdapterFactory.this, TypeToken.get(entry.getValue()));
                    this.subtypeToDelegate.put(entry.getValue(), delegate);
                }
            }

            public void write(JsonWriter out, T value) throws IOException {
                Class<?> srcType = value.getClass();
                String label = SubTypeAdapterFactory.this.subtypeToLabel.get(srcType);
                TypeAdapter<?> delegate = this.subtypeToDelegate.get(srcType);
                if (delegate == null) {
                    throw new JsonParseException("Cannot serialize " + String.valueOf(SubTypeAdapterFactory.this.baseType) + " subtype named " + srcType.getName() + "; did you forget to register a subtype?");
                }
                JsonObject jsonObject = delegate.toJsonTree(value).getAsJsonObject();
                if (jsonObject.has(SubTypeAdapterFactory.this.typeFieldName)) {
                    throw new JsonParseException("Cannot serialize " + srcType.getName() + " because it already defines a field named " + SubTypeAdapterFactory.this.typeFieldName);
                }
                JsonObject clone = new JsonObject();
                clone.add(SubTypeAdapterFactory.this.typeFieldName, (JsonElement)new JsonPrimitive(label));
                for (Map.Entry entry : jsonObject.entrySet()) {
                    clone.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                logger.trace("Writing {} for {} ", (Object)label, value);
                this.gson.toJson((JsonElement)clone, out);
            }

            public T read(JsonReader in) throws IOException {
                TypeAdapter<?> delegate;
                JsonElement jsonElement = (JsonElement)this.gson.fromJson(in, JsonElement.class);
                JsonElement labelElement = jsonElement.getAsJsonObject().remove(SubTypeAdapterFactory.this.typeFieldName);
                if (labelElement == null) {
                    throw new JsonParseException("Cannot deserialize " + String.valueOf(SubTypeAdapterFactory.this.baseType) + " because there is no field named " + SubTypeAdapterFactory.this.typeFieldName);
                }
                String label = labelElement.getAsString();
                Class<?> subtype = SubTypeAdapterFactory.this.labelToSubtype.get(label);
                if (subtype == null) {
                    subtype = SubTypeAdapterFactory.this.aliasToSubtype.get(label);
                }
                if ((delegate = this.subtypeToDelegate.get(subtype)) == null) {
                    throw new JsonParseException("Cannot deserialize " + String.valueOf(SubTypeAdapterFactory.this.baseType) + " subtype named " + label);
                }
                logger.trace("Reading {} for {} ", (Object)label, SubTypeAdapterFactory.this.baseType);
                return delegate.fromJsonTree(jsonElement);
            }
        }
    }

    static class QuPathTypeAdapterFactory
    implements TypeAdapterFactory {
        QuPathTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return QuPathTypeAdapterFactory.getTypeAdaptor(type.getRawType());
        }

        static <T> TypeAdapter<T> getTypeAdaptor(Class<T> cls) {
            if (PathRootObject.class.isAssignableFrom(cls)) {
                return QuPathTypeAdapters.PathObjectTypeAdapter.INSTANCE_HIERARCHY;
            }
            if (PathObject.class.isAssignableFrom(cls)) {
                return QuPathTypeAdapters.PathObjectTypeAdapter.INSTANCE;
            }
            if (MeasurementList.class.isAssignableFrom(cls)) {
                return QuPathTypeAdapters.MeasurementListTypeAdapter.INSTANCE;
            }
            if (FeatureCollection.class.isAssignableFrom(cls)) {
                return QuPathTypeAdapters.PathObjectCollectionTypeAdapter.INSTANCE;
            }
            if (PathObjectHierarchy.class.isAssignableFrom(cls)) {
                return QuPathTypeAdapters.HierarchyTypeAdapter.INSTANCE;
            }
            if (ROI.class.isAssignableFrom(cls)) {
                return ROITypeAdapters.ROI_ADAPTER_INSTANCE;
            }
            if (Geometry.class.isAssignableFrom(cls)) {
                return ROITypeAdapters.GEOMETRY_ADAPTER_INSTANCE;
            }
            if (PathClass.class.isAssignableFrom(cls)) {
                return PathClassTypeAdapter.INSTANCE;
            }
            if (ImagePlane.class.isAssignableFrom(cls)) {
                return ImagePlaneTypeAdapter.INSTANCE;
            }
            return null;
        }
    }

    static class AffineTransformTypeAdapter
    extends TypeAdapter<AffineTransform> {
        static AffineTransformTypeAdapter INSTANCE = new AffineTransformTypeAdapter();
        private static Gson gson = new Gson();

        AffineTransformTypeAdapter() {
        }

        public void write(JsonWriter out, AffineTransform value) throws IOException {
            gson.toJson((Object)new AffineTransformProxy(value), AffineTransformProxy.class, out);
        }

        public AffineTransform read(JsonReader in) throws IOException {
            AffineTransformProxy proxy = (AffineTransformProxy)gson.fromJson(in, AffineTransformProxy.class);
            AffineTransform transform = new AffineTransform();
            proxy.fill(transform);
            return transform;
        }

        static class AffineTransformProxy {
            public final double m00;
            public final double m10;
            public final double m01;
            public final double m11;
            public final double m02;
            public final double m12;

            AffineTransformProxy(AffineTransform transform) {
                double[] flatmatrix = new double[6];
                transform.getMatrix(flatmatrix);
                this.m00 = flatmatrix[0];
                this.m10 = flatmatrix[1];
                this.m01 = flatmatrix[2];
                this.m11 = flatmatrix[3];
                this.m02 = flatmatrix[4];
                this.m12 = flatmatrix[5];
            }

            void fill(AffineTransform transform) {
                transform.setTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
            }
        }
    }

    static class ImagePlaneTypeAdapter
    extends TypeAdapter<ImagePlane> {
        static ImagePlaneTypeAdapter INSTANCE = new ImagePlaneTypeAdapter();

        ImagePlaneTypeAdapter() {
        }

        public void write(JsonWriter out, ImagePlane plane) throws IOException {
            out.beginObject();
            out.name("c");
            out.value((long)plane.getC());
            out.name("z");
            out.value((long)plane.getZ());
            out.name("t");
            out.value((long)plane.getT());
            out.endObject();
        }

        public ImagePlane read(JsonReader in) throws IOException {
            in.beginObject();
            ImagePlane plane = ImagePlane.getDefaultPlane();
            int c = plane.getC();
            int z = plane.getZ();
            int t = plane.getT();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "c": {
                        c = in.nextInt();
                        break;
                    }
                    case "z": {
                        z = in.nextInt();
                        break;
                    }
                    case "t": {
                        t = in.nextInt();
                    }
                }
            }
            in.endObject();
            return ImagePlane.getPlaneWithChannel(c, z, t);
        }
    }

    static class PathClassTypeAdapter
    extends TypeAdapter<PathClass> {
        static PathClassTypeAdapter INSTANCE = new PathClassTypeAdapter();
        private static Gson gson = new Gson();

        PathClassTypeAdapter() {
        }

        public void write(JsonWriter out, PathClass value) throws IOException {
            if (value == null || value == PathClass.NULL_CLASS) {
                gson.toJson((Object)value, PathClass.class, out);
            } else {
                out.beginObject();
                List<String> names = PathClassTools.splitNames(value);
                if (names.size() == 1) {
                    out.name("name");
                    out.value(names.get(0));
                } else {
                    out.name("names");
                    out.beginArray();
                    for (String name : names) {
                        out.value(name);
                    }
                    out.endArray();
                }
                Integer color = value.getColor();
                if (color != null) {
                    out.name("color");
                    int alpha = ColorTools.alpha(color);
                    try {
                        if (alpha != 0 && alpha != 255) {
                            out.jsonValue(String.format("[%d, %d, %d, %d]", ColorTools.red(color), ColorTools.green(color), ColorTools.blue(color), ColorTools.alpha(color)));
                        } else {
                            out.jsonValue(String.format("[%d, %d, %d]", ColorTools.red(color), ColorTools.green(color), ColorTools.blue(color)));
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        out.beginArray();
                        out.value((long)ColorTools.red(color));
                        out.value((long)ColorTools.green(color));
                        out.value((long)ColorTools.blue(color));
                        if (alpha != 0 && alpha != 255) {
                            ColorTools.alpha(color);
                        }
                        out.endArray();
                    }
                }
                out.endObject();
            }
        }

        public PathClass read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                return null;
            }
            if (token == JsonToken.STRING) {
                return PathClass.fromString(in.nextString());
            }
            if (token == JsonToken.BEGIN_OBJECT) {
                JsonObject pathClassObject = (JsonObject)gson.fromJson(in, JsonObject.class);
                if (pathClassObject.size() == 0 || pathClassObject.has("colorRGB") || pathClassObject.has("parentClass")) {
                    PathClass pathClass = (PathClass)gson.fromJson((JsonElement)pathClassObject, PathClass.class);
                    return PathClass.getSingleton(pathClass);
                }
                if ((pathClassObject.has("name") || pathClassObject.has("names")) && pathClassObject.has("color")) {
                    PathClassProxy proxy = (PathClassProxy)gson.fromJson((JsonElement)pathClassObject, PathClassProxy.class);
                    return proxy.getPathClass();
                }
            }
            throw new JsonParseException("Unable to parse PathClass from " + String.valueOf(in));
        }

        private static class PathClassProxy {
            private List<String> names;
            private String name;
            private int[] color;

            private PathClassProxy() {
            }

            private PathClass getPathClass() {
                Integer rgb;
                Integer n = rgb = this.color == null ? null : GsonTools.arrayToRgb(this.color);
                if (this.name == null) {
                    if (this.names == null || this.names.isEmpty()) {
                        return null;
                    }
                    return PathClass.fromCollection(this.names, rgb);
                }
                return PathClass.fromString(this.name, rgb);
            }
        }
    }
}

