/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.io;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.LogTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.io.FeatureCollection;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.workflow.Workflow;

public class PathIO {
    private static final Logger logger = LoggerFactory.getLogger(PathIO.class);
    private static final int DATA_FILE_VERSION = 3;
    private static final ObjectInputFilter QUPATH_INPUT_FILTER = PathIO::qupathInputFilter;
    private static int requestedDataFileVersion = 2;
    private static final String EXT_ZIP = ".zip";
    private static final String EXT_GZIP = ".gz";
    private static final String EXT_JSON = ".json";
    private static final String EXT_GEOJSON = ".geojson";
    private static final String EXT_DATA = ".qpdata";

    private PathIO() {
    }

    public static int getRequestedDataFileVersion() {
        return requestedDataFileVersion;
    }

    public static int getCurrentDataFileVersion() {
        return 3;
    }

    public static void setRequestedDataFileVersion(int version) throws IllegalArgumentException {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("Requested data file version must be between 2 and 3");
        }
        requestedDataFileVersion = version;
    }

    @Deprecated
    public static String readSerializedServerPath(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        String serverPath = null;
        try (FileInputStream fileIn = new FileInputStream(file);){
            ObjectInputStream inStream = PathIO.createObjectInputStream(new BufferedInputStream(fileIn));
            String firstLine = inStream.readUTF();
            if (firstLine.startsWith("Data file version")) {
                serverPath = (String)inStream.readObject();
                serverPath = serverPath.substring("Image path: ".length()).trim();
            }
        }
        return serverPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> ImageServerBuilder.ServerBuilder<T> extractServerBuilder(Path file) throws IOException {
        try (InputStream fileIn = Files.newInputStream(file, new OpenOption[0]);){
            ObjectInputStream inStream = PathIO.createObjectInputStream(new BufferedInputStream(fileIn));
            String firstLine = inStream.readUTF();
            if (!firstLine.startsWith("Data file version")) throw new IOException(String.valueOf(file) + " does not appear to be a valid QuPath data file");
            ImageServerBuilder.ServerBuilder<T> serverBuilder = PathIO.extractServerBuilder((String)inStream.readObject(), true);
            return serverBuilder;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static ObjectInputStream createObjectInputStream(InputStream stream) throws IOException {
        ObjectInputStream inStream = new ObjectInputStream(stream);
        inStream.setObjectInputFilter(QUPATH_INPUT_FILTER);
        return inStream;
    }

    private static <T> ImageServerBuilder.ServerBuilder<T> extractServerBuilder(String serverString, boolean warnIfInvalid) throws IOException {
        if (serverString.startsWith("Image path: ")) {
            String serverPath = serverString.substring("Image path: ".length()).trim();
            URI uri = ImageServerProvider.legacyPathToURI(serverPath);
            if (warnIfInvalid) {
                logger.warn("Attempting to extract server from legacy data file - this may result in errors");
            }
            return ImageServerBuilder.DefaultImageServerBuilder.createInstance(null, uri, new String[0]);
        }
        String json = serverString;
        ServerBuilderWrapper wrapper = (ServerBuilderWrapper)GsonTools.getInstance().fromJson(json, ServerBuilderWrapper.class);
        if (warnIfInvalid && !Objects.equals(wrapper.dataVersion, 3)) {
            logger.warn("Attempting to read data file version {} written by QuPath {} (expected data file version {})", new Object[]{wrapper.dataVersion, wrapper.qupathVersion, 3});
        }
        return wrapper.server;
    }

    private static <T> ImageData<T> readImageDataSerialized(Path path, ImageServer<T> server) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ImageData<T> imageData = PathIO.readImageDataSerialized(stream, server);
            imageData.setLastSavedPath(path.toAbsolutePath().toString(), true);
            ImageData<T> imageData2 = imageData;
            return imageData2;
        }
    }

    private static <T> ImageData<T> readImageDataSerialized(InputStream stream, ImageServer<T> server) throws FileNotFoundException, IOException {
        return PathIO.readImageDataSerialized(stream, server, null);
    }

    private static <T> ImageData<T> readImageDataSerialized(InputStream stream, ImageServer<T> server, ImageServerBuilder.ServerBuilder<T> requestedServerBuilder) throws IOException {
        long startTime = System.currentTimeMillis();
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        boolean localeChanged = false;
        try {
            ImageData<T> imageData;
            block37: {
                ObjectInputStream inStream = PathIO.createObjectInputStream(new BufferedInputStream(stream));
                try {
                    ImageData<T> imageData2;
                    ImageServerBuilder.ServerBuilder<T> serverBuilder = requestedServerBuilder;
                    PathObjectHierarchy hierarchy = null;
                    ImageData.ImageType imageType = null;
                    ColorDeconvolutionStains stains = null;
                    Workflow workflow = null;
                    Map propertyMap = null;
                    String firstLine = inStream.readUTF();
                    if (!firstLine.startsWith("Data file version")) {
                        logger.error("Input stream does not contain valid QuPath data!");
                    }
                    String serverString = (String)inStream.readObject();
                    if (serverBuilder == null) {
                        serverBuilder = PathIO.extractServerBuilder(serverString, true);
                    }
                    block14: while (true) {
                        try {
                            while (true) {
                                Object input = inStream.readObject();
                                logger.trace("Read object: {}", input);
                                if (input instanceof Locale) {
                                    if (input == locale) continue;
                                    Locale.setDefault(Locale.Category.FORMAT, (Locale)input);
                                    localeChanged = true;
                                    continue;
                                }
                                if (input instanceof PathObjectHierarchy) {
                                    PathObjectHierarchy readHierarchy = (PathObjectHierarchy)input;
                                    hierarchy = new PathObjectHierarchy();
                                    hierarchy.setHierarchy(readHierarchy);
                                    continue;
                                }
                                if (input instanceof ImageData.ImageType) {
                                    ImageData.ImageType readImageType;
                                    imageType = readImageType = (ImageData.ImageType)((Object)input);
                                    continue;
                                }
                                if ("EOF".equals(input)) break block14;
                                if (input instanceof ColorDeconvolutionStains) {
                                    ColorDeconvolutionStains readStains;
                                    stains = readStains = (ColorDeconvolutionStains)input;
                                    continue;
                                }
                                if (input instanceof Workflow) {
                                    Workflow readWorkflow;
                                    workflow = readWorkflow = (Workflow)input;
                                    continue;
                                }
                                if (input instanceof Map) {
                                    Map readPropertyMap;
                                    propertyMap = readPropertyMap = (Map)input;
                                    continue;
                                }
                                if (input == null) {
                                    logger.debug("Null object will be skipped");
                                    continue;
                                }
                                logger.warn("Unsupported object of class {} will be skipped: {}", (Object)input.getClass().getName(), input);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("Unable to find class: {}", (Object)e.getLocalizedMessage(), (Object)e);
                            continue;
                        }
                        catch (EOFException e) {
                            logger.error("Reached end of file...");
                            if (hierarchy != null) break;
                            throw e;
                        }
                        catch (Exception e) {
                            if (e instanceof IOException) {
                                IOException ioe = (IOException)e;
                                throw ioe;
                            }
                            throw new IOException(e);
                        }
                        break;
                    }
                    if (server != null) {
                        imageData2 = new ImageData<T>(server, hierarchy, imageType);
                    } else if (serverBuilder != null) {
                        imageData2 = new ImageData<T>(serverBuilder, hierarchy, imageType);
                    } else {
                        throw new IOException("Can't read ImageData without a server or server builder");
                    }
                    if (workflow != null) {
                        imageData2.getHistoryWorkflow().addSteps(workflow.getSteps());
                    }
                    if (stains != null) {
                        imageData2.setColorDeconvolutionStains(stains);
                    }
                    if (propertyMap != null) {
                        for (Map.Entry entry : propertyMap.entrySet()) {
                            imageData2.setProperty((String)entry.getKey(), entry.getValue());
                        }
                    }
                    long endTime = System.currentTimeMillis();
                    if (hierarchy != null) {
                        logger.debug(String.format("Hierarchy with %d object(s) read in %.2f seconds", hierarchy.nObjects(), (double)(endTime - startTime) / 1000.0));
                    }
                    imageData = imageData2;
                    if (inStream == null) break block37;
                }
                catch (Throwable throwable) {
                    try {
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ClassNotFoundException e1) {
                        logger.warn("Stream does not appear to be a valid .qpdata file", (Throwable)e1);
                        throw new IOException("Cannot read ImageData from stream", e1);
                    }
                }
                inStream.close();
            }
            return imageData;
        }
        finally {
            if (localeChanged) {
                Locale.setDefault(Locale.Category.FORMAT, locale);
            }
        }
    }

    private static <T> ImageData<T> tryToUpdateImageData(ImageData<T> imageDataOriginal, ImageData<T> imageDataNew) {
        if (Objects.equals(imageDataOriginal.getServerBuilder(), imageDataNew.getServerBuilder())) {
            imageDataOriginal.setImageType(imageDataNew.getImageType());
            imageDataOriginal.getHierarchy().setHierarchy(imageDataNew.getHierarchy());
            imageDataOriginal.getHistoryWorkflow().clear();
            imageDataOriginal.getHistoryWorkflow().addSteps(imageDataNew.getHistoryWorkflow().getSteps());
            imageDataOriginal.setColorDeconvolutionStains(imageDataNew.getColorDeconvolutionStains());
            for (Map.Entry<String, Object> entry : imageDataNew.getProperties().entrySet()) {
                imageDataOriginal.setProperty(entry.getKey(), entry.getValue());
            }
            imageDataOriginal.setLastSavedPath(imageDataNew.getLastSavedPath(), false);
            return imageDataOriginal;
        }
        return imageDataNew;
    }

    @Deprecated
    public static <T> ImageData<T> readImageData(File file, ImageData<T> imageData, ImageServer<T> server, Class<T> cls) throws IOException {
        return PathIO.readImageData(file.toPath(), imageData, server, cls);
    }

    @Deprecated
    public static <T> ImageData<T> readImageData(Path path, ImageData<T> imageData, ImageServer<T> server, Class<T> cls) throws IOException {
        LogTools.warnOnce(logger, "readImageData(Path, ImageData, ImageServer, Class) is deprecated and will be removed in a future version");
        ImageData<T> newImageData = PathIO.readImageDataSerialized(path, server);
        if (imageData != null) {
            return PathIO.tryToUpdateImageData(imageData, newImageData);
        }
        return newImageData;
    }

    @Deprecated
    public static <T> ImageData<T> readImageData(InputStream stream, ImageData<T> imageData, ImageServer<T> server, Class<T> cls) throws IOException {
        LogTools.warnOnce(logger, "readImageData(InputStream, ImageData, ImageServer, Class) is deprecated and will be removed in a future version");
        ImageData<T> newImageData = PathIO.readImageDataSerialized(stream, server);
        if (imageData != null) {
            return PathIO.tryToUpdateImageData(imageData, newImageData);
        }
        return newImageData;
    }

    public static <T> ImageData<T> readImageData(Path path, ImageServerBuilder.ServerBuilder<T> serverBuilder) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ImageData<T> imageData = PathIO.readImageDataSerialized(stream, null, serverBuilder);
            imageData.setLastSavedPath(path.toAbsolutePath().toString(), true);
            ImageData<T> imageData2 = imageData;
            return imageData2;
        }
    }

    public static <T> ImageData<T> readImageData(InputStream stream, ImageServerBuilder.ServerBuilder<T> serverBuilder) throws IOException {
        return PathIO.readImageDataSerialized(stream, null, serverBuilder);
    }

    public static <T> ImageData<T> readImageData(File file) throws IOException {
        return PathIO.readImageData(file.toPath());
    }

    public static <T> ImageData<T> readImageData(Path path) throws IOException {
        return PathIO.readImageDataSerialized(path, null);
    }

    public static <T> ImageData<T> readImageData(File file, ImageServer<T> server) throws IOException {
        return PathIO.readImageData(file.toPath(), server);
    }

    public static <T> ImageData<T> readImageData(Path path, ImageServer<T> server) throws IOException {
        return PathIO.readImageDataSerialized(path, server);
    }

    public static void writeImageData(Path path, ImageData<?> imageData) throws FileNotFoundException, IOException {
        PathIO.writeImageData(path.toFile(), imageData);
    }

    public static void writeImageData(File file, ImageData<?> imageData) throws FileNotFoundException, IOException {
        File backup = null;
        if (file.exists()) {
            File fileCopy = Paths.get(file.toURI()).toFile();
            backup = new File(fileCopy.getAbsolutePath() + ".backup");
            fileCopy.renameTo(backup);
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            PathIO.writeImageDataSerialized(stream, imageData);
            imageData.setLastSavedPath(file.getAbsolutePath(), true);
        }
        if (backup != null && !backup.equals(file)) {
            backup.delete();
        }
    }

    public static void writeImageData(OutputStream stream, ImageData<?> imageData) throws IOException {
        PathIO.writeImageDataSerialized(stream, imageData);
    }

    private static void writeImageDataSerialized(OutputStream stream, ImageData<?> imageData) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(stream);){
            String serverPath;
            long startTime = System.currentTimeMillis();
            ObjectOutputStream outStream = new ObjectOutputStream(outputStream);
            outStream.writeUTF("Data file version 3");
            ImageServerBuilder.ServerBuilder<?> builder = imageData.getServerBuilder();
            if (builder == null) {
                ImageServer<?> server = imageData.getServer();
                logger.warn("Server {} does not provide a builder - it will not be possible to recover the ImageServer from this data file", server);
                serverPath = server.getPath();
            } else {
                serverPath = imageData.getLastSavedPath();
            }
            ServerBuilderWrapper<?> wrapper = ServerBuilderWrapper.create(builder, serverPath);
            String json = GsonTools.getInstance().toJson(wrapper);
            outStream.writeObject(json);
            outStream.writeObject(Locale.getDefault(Locale.Category.FORMAT));
            outStream.writeObject((Object)imageData.getImageType());
            outStream.writeObject(imageData.getColorDeconvolutionStains());
            outStream.writeObject(imageData.getHistoryWorkflow());
            PathObjectHierarchy hierarchy = imageData.getHierarchy();
            logger.info(String.format("Writing object hierarchy with %d object(s)...", hierarchy.nObjects()));
            outStream.writeObject(hierarchy);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : imageData.getProperties().entrySet()) {
                if (PathIO.serializableObject(entry.getValue())) {
                    map.put(entry.getKey(), entry.getValue());
                    continue;
                }
                logger.warn("Property not serializable and will not be saved!  Key: " + entry.getKey() + ", Value: " + String.valueOf(entry.getValue()));
            }
            if (map != null) {
                outStream.writeObject(map);
            }
            outStream.writeObject("EOF");
            long endTime = System.currentTimeMillis();
            logger.info(String.format("Image data written in %.2f seconds", (double)(endTime - startTime) / 1000.0));
        }
    }

    public static PathObjectHierarchy readHierarchy(File file) throws IOException {
        return PathIO.readHierarchy(file.toPath());
    }

    public static PathObjectHierarchy readHierarchy(Path path) throws IOException {
        logger.info("Reading hierarchy from {}", (Object)path.getFileName().toString());
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            PathObjectHierarchy pathObjectHierarchy = PathIO.readHierarchy(stream);
            return pathObjectHierarchy;
        }
    }

    public static PathObjectHierarchy readHierarchy(InputStream fileIn) throws IOException {
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        boolean localeChanged = false;
        try (ObjectInputStream inStream = PathIO.createObjectInputStream(new BufferedInputStream(fileIn));){
            if (!inStream.readUTF().startsWith("Data file version")) {
                logger.error("Input stream is not from a valid QuPath data file!");
            }
            while (true) {
                try {
                    Object input = inStream.readObject();
                    logger.trace("Read object: {}", input);
                    if (input instanceof Locale) {
                        if (input != locale) {
                            Locale.setDefault(Locale.Category.FORMAT, (Locale)input);
                            localeChanged = true;
                        }
                    } else if (input instanceof PathObjectHierarchy) {
                        PathObjectHierarchy newHierarchy = (PathObjectHierarchy)input;
                        PathObjectHierarchy hierarchy = new PathObjectHierarchy();
                        hierarchy.setHierarchy(newHierarchy);
                        PathObjectHierarchy pathObjectHierarchy = hierarchy;
                        return pathObjectHierarchy;
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error("Unable to find class", (Throwable)e);
                }
                catch (EOFException e) {
                    logger.error("Reached end of file unexpectedly...");
                }
            }
        }
        finally {
            if (localeChanged) {
                Locale.setDefault(Locale.Category.FORMAT, locale);
            }
        }
    }

    public static List<PathObject> readObjects(File file) throws IOException {
        return PathIO.readObjects(file.toPath());
    }

    public static List<PathObject> readObjects(Path path) throws IOException {
        String name = path.getFileName().toString().toLowerCase();
        if (name.endsWith(EXT_ZIP)) {
            try (FileSystem zipfs = FileSystems.newFileSystem(path, (ClassLoader)null);){
                ArrayList allObjects = new ArrayList();
                for (Path root : zipfs.getRootDirectories()) {
                    List tempObjects = Files.walk(root, new FileVisitOption[0]).flatMap(p -> {
                        if (Files.isRegularFile(p, new LinkOption[0])) {
                            try {
                                List<PathObject> pathObjects = PathIO.readObjects(p);
                                if (pathObjects != null) {
                                    return pathObjects.stream();
                                }
                            }
                            catch (Exception e) {
                                logger.debug("Exception reading objects from {}", p);
                            }
                        }
                        return new ArrayList().stream();
                    }).toList();
                    allObjects.addAll(tempObjects);
                }
                ArrayList arrayList = allObjects;
                return arrayList;
            }
        }
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            FilterInputStream stream2;
            if (name.endsWith(EXT_GZIP)) {
                stream2 = new GZIPInputStream(stream);
                name = name.substring(0, name.length() - EXT_GZIP.length());
            } else {
                stream2 = stream;
            }
            if (name.endsWith(EXT_JSON) || name.endsWith(EXT_GEOJSON)) {
                List<PathObject> list = PathIO.readObjectsFromGeoJSON(stream2);
                return list;
            }
            if (name.endsWith(EXT_DATA)) {
                ArrayList<PathObject> arrayList = new ArrayList<PathObject>(PathIO.readHierarchy(stream2).getRootObject().getChildObjects());
                return arrayList;
            }
        }
        logger.debug("Unable to read objects from {}", (Object)path);
        return Collections.emptyList();
    }

    public static List<PathObject> readObjectsFromGeoJSON(InputStream stream) throws IOException, JsonSyntaxException, JsonParseException {
        Gson gson = GsonTools.getInstance();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(stream), StandardCharsets.UTF_8);){
            JsonElement element = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            List<PathObject> list = GsonTools.parseObjectsFromGeoJSON(element);
            return list;
        }
    }

    public static List<String> getObjectFileExtensions(boolean includeCompressed) {
        if (includeCompressed) {
            return Arrays.asList(EXT_JSON, EXT_GEOJSON, EXT_DATA, EXT_ZIP, EXT_GZIP);
        }
        return Arrays.asList(EXT_JSON, EXT_GEOJSON, EXT_DATA);
    }

    @Deprecated
    public static List<String> getObjectFileExtensions() {
        return PathIO.getObjectFileExtensions(true);
    }

    public static void exportObjectsAsGeoJSON(File file, Collection<? extends PathObject> pathObjects, GeoJsonExportOptions ... options) throws IOException {
        PathIO.exportObjectsAsGeoJSON(file.toPath(), pathObjects, options);
    }

    public static void exportObjectsAsGeoJSON(Path path, Collection<? extends PathObject> pathObjects, GeoJsonExportOptions ... options) throws IOException {
        String name = path.getFileName().toString();
        if (name.toLowerCase().endsWith(EXT_ZIP)) {
            try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
                ZipEntry entry = new ZipEntry(GeneralTools.stripExtension(name) + EXT_GEOJSON);
                zos.putNextEntry(entry);
                PathIO.exportObjectsAsGeoJSON(zos, pathObjects, options);
                zos.closeEntry();
            }
        }
        if (name.toLowerCase().endsWith(EXT_GZIP)) {
            try (GZIPOutputStream gzos = new GZIPOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
                PathIO.exportObjectsAsGeoJSON(gzos, pathObjects, options);
            }
        }
        try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
            PathIO.exportObjectsAsGeoJSON(stream, pathObjects, options);
        }
    }

    public static void exportObjectsAsGeoJSON(OutputStream stream, Collection<? extends PathObject> pathObjects, GeoJsonExportOptions ... options) throws IOException {
        List<GeoJsonExportOptions> optionList = Arrays.asList(options);
        if (optionList.contains((Object)GeoJsonExportOptions.EXCLUDE_MEASUREMENTS)) {
            pathObjects = pathObjects.stream().map(e -> PathObjectTools.transformObject(e, null, false)).toList();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(stream), StandardCharsets.UTF_8);
        Gson gson = GsonTools.getInstance(optionList.contains((Object)GeoJsonExportOptions.PRETTY_JSON));
        if (optionList.contains((Object)GeoJsonExportOptions.FEATURE_COLLECTION)) {
            gson.toJson((Object)FeatureCollection.wrap(pathObjects), (Appendable)writer);
        } else if (pathObjects.size() == 1) {
            gson.toJson((Object)pathObjects.iterator().next(), (Appendable)writer);
        } else {
            gson.toJson(pathObjects, new TypeToken<List<PathObject>>(){}.getType(), (Appendable)writer);
        }
        writer.flush();
    }

    public static Set<String> unzippedExtensions(Path path, String ... zipExtensions) throws IOException {
        String ext = GeneralTools.getExtension(path.getFileName().toString()).orElse(null);
        if (ext == null) {
            return Collections.emptySet();
        }
        Set<String> zipExts = zipExtensions.length == 0 ? Collections.singleton(EXT_ZIP) : Arrays.stream(zipExtensions).map(z -> z.toLowerCase()).collect(Collectors.toSet());
        if (zipExts.contains(ext = ext.toLowerCase())) {
            LinkedHashSet<String> extensions = new LinkedHashSet<String>();
            try (FileSystem zipfs = FileSystems.newFileSystem(path, (ClassLoader)null);){
                for (Path root : zipfs.getRootDirectories()) {
                    Set currentExtensions = Files.walk(root, new FileVisitOption[0]).map(p -> {
                        if (Files.isRegularFile(p, new LinkOption[0])) {
                            return GeneralTools.getExtension(p.getFileName().toString()).orElse(null);
                        }
                        return null;
                    }).filter(e -> e != null).collect(Collectors.toSet());
                    extensions.addAll(currentExtensions);
                }
            }
            return extensions;
        }
        if (ext.endsWith(EXT_GZIP)) {
            return Collections.singleton(ext.substring(0, ext.length() - 3));
        }
        return Collections.singleton(ext);
    }

    private static boolean serializableObject(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Serializable) {
            return PathIO.checkQuPathSerializableClass(obj.getClass());
        }
        return false;
    }

    private static boolean checkQuPathSerializableClass(Class<?> serialClass) {
        if (serialClass == null) {
            return true;
        }
        if (!Serializable.class.isAssignableFrom(serialClass)) {
            return false;
        }
        if (PathIO.checkClassLoader(serialClass)) {
            Module module = serialClass.getModule();
            if (module != null && Objects.equals(module.getName(), "java.base")) {
                return true;
            }
            String packageName = serialClass.getPackageName();
            if (packageName != null && packageName.startsWith("qupath.lib")) {
                return true;
            }
        }
        logger.debug("Serialization not permitted for {}", serialClass);
        return false;
    }

    private static boolean checkClassLoader(Class<?> serialClass) {
        if (serialClass == null) {
            return true;
        }
        ClassLoader classloader = serialClass.getClassLoader();
        return classloader == null || classloader == ClassLoader.getPlatformClassLoader() || classloader == ClassLoader.getSystemClassLoader();
    }

    private static ObjectInputFilter.Status classLoaderInputFilter(ObjectInputFilter.FilterInfo filterInfo) {
        return PathIO.checkClassLoader(filterInfo.serialClass()) ? ObjectInputFilter.Status.ALLOWED : ObjectInputFilter.Status.REJECTED;
    }

    private static ObjectInputFilter.Status qupathInputFilter(ObjectInputFilter.FilterInfo filterInfo) {
        return PathIO.checkQuPathSerializableClass(filterInfo.serialClass()) ? ObjectInputFilter.Status.ALLOWED : ObjectInputFilter.Status.REJECTED;
    }

    static class ServerBuilderWrapper<T> {
        private int dataVersion = -1;
        private String qupathVersion = null;
        private ImageServerBuilder.ServerBuilder<T> server;
        private String id;

        ServerBuilderWrapper() {
        }

        static <T> ServerBuilderWrapper<T> create(ImageServerBuilder.ServerBuilder<T> builder, String id) {
            ServerBuilderWrapper<T> wrapper = new ServerBuilderWrapper<T>();
            wrapper.dataVersion = 3;
            wrapper.qupathVersion = GeneralTools.getVersion();
            wrapper.server = builder;
            wrapper.id = id;
            return wrapper;
        }
    }

    public static enum GeoJsonExportOptions {
        PRETTY_JSON,
        EXCLUDE_MEASUREMENTS,
        FEATURE_COLLECTION;

    }
}

