/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.io;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.Point2;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

public class PointIO {
    private static final Logger logger = LoggerFactory.getLogger(PointIO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PathObject> readPoints(InputStream stream) throws IOException {
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        HashMap<String[], List<Point2>> pointsMap = new HashMap<String[], List<Point2>>();
        String[] cols = null;
        try (Scanner scanner = null;){
            scanner = new Scanner(stream);
            cols = scanner.nextLine().split("\t");
            while (scanner.hasNextLine()) {
                PointIO.putPointObjectFromString(scanner.nextLine(), cols, pointsMap);
            }
        }
        ImagePlane defaultPlane = ImagePlane.getDefaultPlane();
        for (Map.Entry entry : pointsMap.entrySet()) {
            String colorTemp;
            List<String> temp = Arrays.asList(cols);
            String pathClass = temp.contains("class") ? ((String[])entry.getKey())[temp.indexOf("class") - 2] : "";
            String name = temp.contains("name") ? ((String[])entry.getKey())[temp.indexOf("name") - 2] : "";
            Integer color = null;
            if (temp.contains("color") && (colorTemp = ((String[])entry.getKey())[temp.indexOf("color") - 2]) != null && !colorTemp.isEmpty()) {
                color = Integer.parseInt(colorTemp);
            }
            int c = temp.indexOf("c") > defaultPlane.getC() ? Integer.parseInt(((String[])entry.getKey())[temp.indexOf("c") - 2]) : defaultPlane.getC();
            int z = temp.indexOf("z") > defaultPlane.getZ() ? Integer.parseInt(((String[])entry.getKey())[temp.indexOf("z") - 2]) : defaultPlane.getZ();
            int t = temp.indexOf("t") > defaultPlane.getT() ? Integer.parseInt(((String[])entry.getKey())[temp.indexOf("t") - 2]) : defaultPlane.getT();
            ROI points = ROIs.createPointsROI((List)entry.getValue(), ImagePlane.getPlaneWithChannel(c, z, t));
            PathObject pathObject = PathObjects.createAnnotationObject(points);
            if (name != null && name.length() > 0 && !"null".equals(name)) {
                pathObject.setName(name);
            }
            if (pathClass != null && pathClass.length() > 0 && !"null".equals(pathClass)) {
                pathObject.setPathClass(PathClass.fromString(pathClass, color));
            }
            pathObject.setColor(color);
            if (pathObject == null) continue;
            pathObjects.add(pathObject);
        }
        return pathObjects;
    }

    public static List<PathObject> readPoints(File file) throws IOException {
        List<PathObject> list;
        FileInputStream fis = new FileInputStream(file);
        try {
            list = PointIO.readPoints(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
        fis.close();
        return list;
    }

    public static void writePoints(OutputStream stream, Collection<? extends PathObject> pathObjects) throws IOException {
        int filteredSize;
        int unfilteredSize = pathObjects.size();
        if (unfilteredSize != (filteredSize = (pathObjects = pathObjects.stream().filter(p -> p.getROI() instanceof PointsROI).toList()).size())) {
            logger.warn(unfilteredSize - filteredSize + " of the " + filteredSize + " elements in list is/are not point annotations. These will be skipped.");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));){
            ArrayList<String> cols = new ArrayList<String>();
            cols.addAll(Arrays.asList("x", "y"));
            String sep = "\t";
            ImagePlane defaultPlane = ImagePlane.getDefaultPlane();
            boolean hasClass = pathObjects.stream().anyMatch(p -> p.getPathClass() != null);
            boolean hasName = pathObjects.stream().anyMatch(p -> p.getName() != null);
            boolean hasColor = pathObjects.stream().anyMatch(p -> p.getColor() != null);
            boolean hasC = pathObjects.stream().anyMatch(p -> p.getROI().getC() > defaultPlane.getC());
            boolean hasZ = pathObjects.stream().anyMatch(p -> p.getROI().getZ() > defaultPlane.getZ());
            boolean hasT = pathObjects.stream().anyMatch(p -> p.getROI().getT() > defaultPlane.getT());
            if (hasC) {
                cols.add("c");
            }
            if (hasZ) {
                cols.add("z");
            }
            if (hasT) {
                cols.add("t");
            }
            if (hasClass) {
                cols.add("class");
            }
            if (hasName) {
                cols.add("name");
            }
            if (hasColor) {
                cols.add("color");
            }
            for (String string : cols) {
                writer.write(string + sep);
            }
            writer.write(System.lineSeparator());
            for (PathObject pathObject : pathObjects) {
                if (!PathObjectTools.hasPointROI(pathObject)) continue;
                PointsROI points = (PointsROI)pathObject.getROI();
                for (Point2 point : points.getAllPoints()) {
                    String[] row = new String[cols.size()];
                    row[cols.indexOf((Object)"x")] = "" + point.getX();
                    row[cols.indexOf((Object)"y")] = sep + point.getY();
                    if (hasC) {
                        row[cols.indexOf((Object)"c")] = sep + points.getC();
                    }
                    if (hasZ) {
                        row[cols.indexOf((Object)"z")] = sep + points.getZ();
                    }
                    if (hasT) {
                        row[cols.indexOf((Object)"t")] = sep + points.getT();
                    }
                    if (hasClass) {
                        String string = row[cols.indexOf((Object)"class")] = pathObject.getPathClass() != null ? sep + String.valueOf(pathObject.getPathClass()) : sep;
                    }
                    if (hasName) {
                        String string = row[cols.indexOf((Object)"name")] = pathObject.getName() != null ? sep + pathObject.getName() : sep;
                    }
                    if (hasColor) {
                        row[cols.indexOf((Object)"color")] = pathObject.getColor() != null ? sep + pathObject.getColor() : sep;
                    }
                    for (String val : row) {
                        writer.write(val);
                    }
                    writer.write(System.lineSeparator());
                }
            }
        }
    }

    public static void writePoints(File file, Collection<? extends PathObject> pathObjects) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            PointIO.writePoints(fos, pathObjects);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static void putPointObjectFromString(String line, String[] cols, Map<String[], List<Point2>> pointsMap) {
        Object[] info = new String[cols.length - 2];
        String[] values = line.split("(?<=\t)");
        double x = Double.parseDouble(values[0].trim());
        double y = Double.parseDouble(values[1].trim());
        for (int i = 2; i < values.length; ++i) {
            info[i - 2] = values[i].trim();
        }
        boolean found = false;
        for (Object[] objectArray : pointsMap.keySet()) {
            if (!Arrays.equals(objectArray, info)) continue;
            pointsMap.get(objectArray).add(new Point2(x, y));
            found = true;
            break;
        }
        if (!found) {
            ArrayList<Point2> newArray = new ArrayList<Point2>();
            newArray.add(new Point2(x, y));
            pointsMap.put((String[])info, newArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static List<PathObject> readPointsObjectList(File file) throws ZipException, IOException {
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        try (Scanner s = null;
             ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                s = new Scanner(new BufferedInputStream(zipFile.getInputStream(entry)));
                s.useDelimiter("\\A");
                PathObject pathObject = PointIO.readPointsObjectFromString(s.next());
                if (pathObject != null) {
                    pathObjects.add(pathObject);
                }
                s.close();
            }
            zipFile.close();
        }
        return pathObjects;
    }

    @Deprecated
    private static PathObject readPointsObjectFromString(String s) {
        String line;
        ArrayList<Point2> pointsList = new ArrayList<Point2>();
        Scanner scanner = new Scanner(s);
        String name = scanner.nextLine().split("\t")[1].trim();
        Integer color = Integer.parseInt(scanner.nextLine().split("\t")[1]);
        int count = Integer.parseInt(scanner.nextLine().split("\t")[1]);
        while (scanner.hasNextLine() && (line = scanner.nextLine().trim()).length() != 0) {
            String[] splits = line.split("\t");
            double x = Double.parseDouble(splits[0]);
            double y = Double.parseDouble(splits[1]);
            pointsList.add(new Point2(x, y));
        }
        scanner.close();
        if (count != pointsList.size()) {
            logger.warn("Warning: {} points expected, {} points found", (Object)count, (Object)pointsList.size());
        }
        ROI points = ROIs.createPointsROI(pointsList, ImagePlane.getDefaultPlane());
        PathObject pathObject = PathObjects.createAnnotationObject(points);
        if (name != null && name.length() > 0 && !"null".equals(name)) {
            pathObject.setName(name);
        }
        pathObject.setColor(color);
        return pathObject;
    }
}

