/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.Strictness;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.common.LogTools;
import qupath.lib.io.FeatureCollection;
import qupath.lib.io.GsonTools;
import qupath.lib.io.ROITypeAdapters;
import qupath.lib.measurements.Measurement;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.measurements.MeasurementListFactory;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.DefaultTMAGrid;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.roi.interfaces.ROI;

class QuPathTypeAdapters {
    static Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeSpecialFloatingPointValues().create();

    QuPathTypeAdapters() {
    }

    static class MeasurementListTypeAdapter
    extends TypeAdapter<MeasurementList> {
        private static final Logger logger = LoggerFactory.getLogger(MeasurementListTypeAdapter.class);
        static MeasurementListTypeAdapter INSTANCE = new MeasurementListTypeAdapter();

        MeasurementListTypeAdapter() {
        }

        public void write(JsonWriter out, MeasurementList value) throws IOException {
            out.beginObject();
            if (value != null) {
                for (Map.Entry<String, Number> entry : value.asMap().entrySet()) {
                    out.name(entry.getKey());
                    Number measurementValue = entry.getValue();
                    if (measurementValue == null || Double.isNaN(measurementValue.doubleValue())) {
                        out.value("NaN");
                        continue;
                    }
                    if (Double.POSITIVE_INFINITY == measurementValue.doubleValue()) {
                        out.value("Infinity");
                        continue;
                    }
                    if (Double.NEGATIVE_INFINITY == measurementValue.doubleValue()) {
                        out.value("-Infinity");
                        continue;
                    }
                    out.value(measurementValue);
                }
            }
            out.endObject();
        }

        public MeasurementList read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.BEGIN_ARRAY) {
                JsonArray array = (JsonArray)gson.fromJson(in, JsonArray.class);
                MeasurementList list = MeasurementListFactory.createMeasurementList(array.size(), MeasurementList.MeasurementListType.DOUBLE);
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject obj = array.get(i).getAsJsonObject();
                    list.put(obj.get("name").getAsString(), obj.get("value").getAsDouble());
                }
                list.close();
                return list;
            }
            if (token == JsonToken.BEGIN_OBJECT) {
                Map map = (Map)gson.fromJson(in, Map.class);
                MeasurementList list = MeasurementListFactory.createMeasurementList(map.size(), MeasurementList.MeasurementListType.DOUBLE);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof Number) {
                        Number number = (Number)value;
                        list.put(key, number.doubleValue());
                        continue;
                    }
                    if (value instanceof String) {
                        String string = (String)value;
                        String lower = string.toLowerCase();
                        if (lower.equals("nan")) {
                            list.put(key, Double.NaN);
                            continue;
                        }
                        if (lower.equals("inf")) {
                            list.put(key, Double.POSITIVE_INFINITY);
                            continue;
                        }
                        if (lower.equals("-inf")) {
                            list.put(key, Double.NEGATIVE_INFINITY);
                            continue;
                        }
                        list.put(key, Double.parseDouble(string));
                        continue;
                    }
                    logger.warn("Cannot parse measurement value for key {}: {}", (Object)key, value);
                }
                list.close();
                return list;
            }
            return null;
        }
    }

    static class PathObjectTypeAdapter
    extends TypeAdapter<PathObject> {
        private static final Logger logger = LoggerFactory.getLogger(PathObjectTypeAdapter.class);
        static PathObjectTypeAdapter INSTANCE = new PathObjectTypeAdapter(false);
        static PathObjectTypeAdapter INSTANCE_HIERARCHY = new PathObjectTypeAdapter(true);
        private static Collection<String> LEGACY_TYPE_IDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("PathTileObject", "PathCellObject", "TMACoreObject", "PathDetectionObject", "PathRootObject", "PathAnnotationObject")));
        private static Map<Class<?>, String> MAP_TYPES = Map.of(PathTileObject.class, "tile", PathCellObject.class, "cell", PathDetectionObject.class, "detection", PathAnnotationObject.class, "annotation", TMACoreObject.class, "tmaCore", PathRootObject.class, "root");
        private boolean flattenProperties = false;
        private boolean doHierarchy = false;

        private PathObjectTypeAdapter(boolean doHierarchy) {
            this.doHierarchy = doHierarchy;
        }

        public void write(JsonWriter out, PathObject value) throws IOException {
            Map<String, String> metadata;
            PathClass pathClass;
            Integer color;
            ROI roiNucleus;
            out.beginObject();
            out.name("type");
            out.value("Feature");
            UUID id = value.getID();
            if (id != null) {
                out.name("id");
                out.value(id.toString());
            }
            out.name("geometry");
            ROITypeAdapters.ROI_ADAPTER_INSTANCE.write(out, value.getROI());
            if (value instanceof PathCellObject && (roiNucleus = ((PathCellObject)value).getNucleusROI()) != null) {
                out.name("nucleusGeometry");
                ROITypeAdapters.ROI_ADAPTER_INSTANCE.write(out, roiNucleus);
            }
            out.name("properties");
            out.beginObject();
            String objectType = MAP_TYPES.getOrDefault(value.getClass(), null);
            if (objectType != null) {
                out.name("objectType");
                out.value(objectType);
            } else {
                logger.warn("Unknown object type {}", (Object)value.getClass().getSimpleName());
            }
            String name = value.getName();
            if (name != null) {
                out.name("name");
                out.value(name);
            }
            if ((color = value.getColor()) != null) {
                out.name("color");
                out.jsonValue(String.format("[%d, %d, %d]", ColorTools.red(color), ColorTools.green(color), ColorTools.blue(color)));
            }
            if ((pathClass = value.getPathClass()) != null) {
                out.name("classification");
                GsonTools.PathClassTypeAdapter.INSTANCE.write(out, pathClass);
            }
            if (value.isLocked()) {
                out.name("isLocked");
                out.value(true);
            }
            if (value instanceof TMACoreObject) {
                out.name("isMissing");
                out.value(((TMACoreObject)value).isMissing());
            }
            MeasurementList measurements = value.getMeasurementList();
            if (this.flattenProperties) {
                if (!measurements.isEmpty()) {
                    out.name("Measurement count");
                    out.value((long)measurements.size());
                    for (Measurement m : measurements.getMeasurements()) {
                        out.name(m.getName());
                        out.value(m.getValue());
                    }
                }
                if (!(map = value.getMetadata()).isEmpty()) {
                    out.name("Metadata count");
                    out.value((long)map.size());
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        out.name(entry.getKey());
                        out.value(entry.getValue());
                    }
                }
            } else {
                if (!measurements.isEmpty()) {
                    out.name("measurements");
                    MeasurementListTypeAdapter.INSTANCE.write(out, measurements);
                }
                if (!(map = value.getMetadata()).isEmpty()) {
                    out.name("metadata");
                    gson.toJson(map, Map.class, out);
                }
            }
            if (this.doHierarchy && value.hasChildObjects()) {
                out.name("childObjects");
                out.beginArray();
                for (PathObject child : value.getChildObjectsAsArray()) {
                    this.write(out, child);
                }
                out.endArray();
            }
            if (!(metadata = value.getMetadata()).isEmpty()) {
                out.name("metadata");
                gson.toJson(metadata, Map.class, out);
            }
            out.endObject();
            out.endObject();
        }

        public PathObject read(JsonReader in) throws IOException {
            JsonObject obj = (JsonObject)gson.fromJson(in, JsonObject.class);
            return this.parseObject(obj);
        }

        private PathObject parseObject(JsonObject obj) {
            String type = "unknown";
            String id = null;
            UUID uuid = null;
            if (obj.has("id")) {
                id = obj.get("id").getAsString();
                if (LEGACY_TYPE_IDS.contains(id)) {
                    type = id;
                } else {
                    try {
                        uuid = UUID.fromString(id);
                        id = null;
                    }
                    catch (Exception e) {
                        logger.debug("Invalid ID found in GeoJSON");
                    }
                }
            }
            ROI roi = (ROI)ROITypeAdapters.ROI_ADAPTER_INSTANCE.fromJsonTree(obj.get("geometry"));
            PathClass pathClass = null;
            boolean isMissing = false;
            boolean isLocked = false;
            String name = null;
            Integer color = null;
            ArrayList<PathObject> childObjects = null;
            MeasurementList measurementList = null;
            JsonObject metadata = null;
            if (obj.has("properties")) {
                String childObjectsName;
                JsonObject properties = obj.get("properties").getAsJsonObject();
                if (properties.has("name")) {
                    name = properties.get("name").getAsString();
                }
                if (properties.has("color")) {
                    JsonArray colorArray;
                    JsonElement colorObj = properties.get("color");
                    if (colorObj.isJsonPrimitive()) {
                        color = colorObj.getAsInt();
                    } else if (colorObj.isJsonArray() && (colorArray = colorObj.getAsJsonArray()).size() == 3) {
                        color = ColorTools.packRGB(colorArray.get(0).getAsInt(), colorArray.get(1).getAsInt(), colorArray.get(2).getAsInt());
                    }
                }
                if (properties.has("classification")) {
                    pathClass = (PathClass)GsonTools.PathClassTypeAdapter.INSTANCE.fromJsonTree(properties.get("classification"));
                }
                if (properties.has("isMissing") && properties.get("isMissing").isJsonPrimitive()) {
                    isMissing = properties.get("isMissing").getAsBoolean();
                }
                if (properties.has("isLocked") && properties.get("isLocked").isJsonPrimitive()) {
                    isLocked = properties.get("isLocked").getAsBoolean();
                }
                if (properties.has("measurements") && (properties.get("measurements").isJsonArray() || properties.get("measurements").isJsonObject())) {
                    measurementList = (MeasurementList)MeasurementListTypeAdapter.INSTANCE.fromJsonTree(properties.get("measurements"));
                }
                if (properties.has("metadata") && properties.get("metadata").isJsonObject()) {
                    metadata = properties.get("metadata").getAsJsonObject();
                }
                if (properties.has("objectType")) {
                    type = properties.get("objectType").getAsString();
                } else if (properties.has("object_type")) {
                    LogTools.warnOnce(logger, "PathObject using 'object_type' property - this should be updated to 'objectType'");
                    type = properties.get("object_type").getAsString();
                } else if (properties.has("type")) {
                    type = properties.get("type").getAsString();
                }
                String string = childObjectsName = properties.has("childObjects") ? "childObjects" : "children";
                if (properties.has(childObjectsName) && properties.get(childObjectsName).isJsonArray()) {
                    String children = properties.get(childObjectsName).getAsJsonArray();
                    childObjects = new ArrayList<PathObject>();
                    Iterator iterator = children.iterator();
                    while (iterator.hasNext()) {
                        JsonElement child = (JsonElement)iterator.next();
                        PathObject childObject = this.parseObject(child.getAsJsonObject());
                        if (childObject == null) continue;
                        childObjects.add(childObject);
                    }
                }
            }
            ROI roiNucleus = null;
            if (obj.has("nucleusGeometry")) {
                roiNucleus = (ROI)ROITypeAdapters.ROI_ADAPTER_INSTANCE.fromJsonTree(obj.get("nucleusGeometry"));
            }
            PathObject pathObject = null;
            switch (type) {
                case "PathTileObject": 
                case "tile": {
                    pathObject = PathObjects.createTileObject(roi);
                    break;
                }
                case "PathCellObject": 
                case "cell": {
                    pathObject = PathObjects.createCellObject(roi, roiNucleus, null, null);
                    break;
                }
                case "TMACoreObject": 
                case "tmaCore": 
                case "tma_core": {
                    pathObject = PathObjects.createTMACoreObject(roi.getBoundsX(), roi.getBoundsY(), roi.getBoundsWidth(), roi.getBoundsHeight(), isMissing);
                    break;
                }
                case "PathDetectionObject": 
                case "detection": {
                    pathObject = PathObjects.createDetectionObject(roi);
                    break;
                }
                case "PathRootObject": 
                case "root": {
                    pathObject = new PathRootObject();
                    break;
                }
                case "PathAnnotationObject": 
                case "annotation": 
                case "unknown": {
                    pathObject = PathObjects.createAnnotationObject(roi);
                    break;
                }
                default: {
                    logger.warn("Unknown object type {}, I will create an annotation", (Object)type);
                    pathObject = PathObjects.createAnnotationObject(roi);
                }
            }
            if (uuid != null) {
                pathObject.setID(uuid);
            }
            if (measurementList != null && !measurementList.isEmpty()) {
                try (MeasurementList ml = pathObject.getMeasurementList();){
                    ml.putAll(measurementList);
                }
            }
            if (pathClass != null) {
                pathObject.setPathClass(pathClass);
            }
            if (name != null) {
                pathObject.setName(name);
            }
            if (color != null) {
                pathObject.setColor(color);
            }
            if (isLocked && !pathObject.isRootObject()) {
                pathObject.setLocked(isLocked);
            }
            if (metadata != null && !metadata.isEmpty()) {
                try {
                    for (Map.Entry entry : metadata.entrySet()) {
                        JsonElement value = (JsonElement)entry.getValue();
                        if (!value.isJsonPrimitive()) continue;
                        pathObject.getMetadata().put((String)entry.getKey(), value.getAsString());
                    }
                }
                catch (UnsupportedOperationException e) {
                    logger.warn("Exception setting metadata values: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (childObjects != null) {
                pathObject.addChildObjects(childObjects);
            }
            return pathObject;
        }
    }

    static class PathObjectCollectionTypeAdapter
    extends TypeAdapter<FeatureCollection> {
        static PathObjectCollectionTypeAdapter INSTANCE = new PathObjectCollectionTypeAdapter();
        static Type TYPE = new TypeToken<Collection<PathObject>>(){}.getType();

        PathObjectCollectionTypeAdapter() {
        }

        public void write(JsonWriter out, FeatureCollection value) throws IOException {
            out.beginObject();
            out.name("type");
            out.value("FeatureCollection");
            PathObjectTypeAdapter adapter = value.getIncludeChildren() ? PathObjectTypeAdapter.INSTANCE_HIERARCHY : PathObjectTypeAdapter.INSTANCE;
            out.name("features");
            out.beginArray();
            for (PathObject pathObject : value.getPathObjects()) {
                adapter.write(out, pathObject);
            }
            out.endArray();
            out.endObject();
        }

        public FeatureCollection read(JsonReader in) throws IOException {
            ArrayList<PathObject> list = new ArrayList<PathObject>();
            JsonArray array = null;
            JsonToken token = in.peek();
            if (token == JsonToken.BEGIN_ARRAY) {
                array = (JsonArray)gson.fromJson(in, JsonArray.class);
            } else {
                JsonObject obj = (JsonObject)gson.fromJson(in, JsonObject.class);
                if (obj.has("features") && obj.get("features").isJsonArray()) {
                    array = obj.get("features").getAsJsonArray();
                }
            }
            if (array != null) {
                for (JsonElement element : array) {
                    list.add((PathObject)PathObjectTypeAdapter.INSTANCE.fromJsonTree(element));
                }
            }
            return FeatureCollection.wrap(list);
        }
    }

    static class TMAGridProxy {
        private int width;
        private List<UUID> cores;

        TMAGridProxy(TMAGrid grid) {
            this.width = grid.getGridWidth();
            this.cores = grid.getTMACoreList().stream().map(c -> c.getID()).toList();
        }
    }

    static class HierarchyTypeAdapter
    extends TypeAdapter<PathObjectHierarchy> {
        private static final Logger logger = LoggerFactory.getLogger(HierarchyTypeAdapter.class);
        static HierarchyTypeAdapter INSTANCE = new HierarchyTypeAdapter();

        HierarchyTypeAdapter() {
        }

        public void write(JsonWriter out, PathObjectHierarchy value) throws IOException {
            if (value == null && out.getSerializeNulls()) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("root");
            PathObjectTypeAdapter.INSTANCE_HIERARCHY.write(out, value.getRootObject());
            TMAGrid tmaGrid = value.getTMAGrid();
            if (tmaGrid != null) {
                out.name("tmaGrid");
                TMAGridProxy proxy = new TMAGridProxy(tmaGrid);
                gson.toJson((Object)proxy, proxy.getClass(), out);
            }
            out.endObject();
        }

        public PathObjectHierarchy read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                return null;
            }
            if (token != JsonToken.BEGIN_OBJECT) {
                throw new IOException("Expected BEGIN_OBJECT but found " + String.valueOf(token));
            }
            PathObjectHierarchy hierarchy = new PathObjectHierarchy();
            JsonObject obj = (JsonObject)gson.fromJson(in, JsonObject.class);
            if (obj.has("root")) {
                PathObject rootObject = (PathObject)PathObjectTypeAdapter.INSTANCE_HIERARCHY.fromJsonTree(obj.get("root"));
                hierarchy.getRootObject().addChildObjects(new ArrayList<PathObject>(rootObject.getChildObjects()));
            }
            if (obj.has("tmaGrid")) {
                TMAGridProxy proxy = (TMAGridProxy)gson.fromJson((JsonElement)obj.get("tmaGrid").getAsJsonObject(), TMAGridProxy.class);
                Map<UUID, PathObject> allCores = hierarchy.getAllObjects(false).stream().collect(Collectors.toMap(c -> c.getID(), c -> c));
                List<TMACoreObject> sortedCores = proxy.cores.stream().map(i -> allCores.getOrDefault(i, null)).filter(c -> c != null).toList();
                if (sortedCores.size() == proxy.cores.size()) {
                    TMAGrid tmaGrid = DefaultTMAGrid.create(sortedCores, proxy.width);
                    hierarchy.setTMAGrid(tmaGrid);
                } else {
                    logger.warn("Cannot deserialize TMA grid - matched {}/{} cores", (Object)sortedCores.size(), (Object)allCores.size());
                }
            }
            return hierarchy;
        }
    }

    static class ROICollection
    extends AbstractCollection<ROI> {
        private List<ROI> rois = new ArrayList<ROI>();

        ROICollection(Collection<? extends ROI> rois) {
            this.rois.addAll(rois);
        }

        @Override
        public Iterator<ROI> iterator() {
            return this.rois.iterator();
        }

        @Override
        public int size() {
            return this.rois.size();
        }
    }

    static class PathObjectCollection
    extends AbstractCollection<PathObject> {
        private List<PathObject> pathObjects = new ArrayList<PathObject>();

        PathObjectCollection(Collection<? extends PathObject> pathObjects) {
            this.pathObjects.addAll(pathObjects);
        }

        @Override
        public Iterator<PathObject> iterator() {
            return this.pathObjects.iterator();
        }

        @Override
        public int size() {
            return this.pathObjects.size();
        }
    }
}

