/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.measurements;

import qupath.lib.measurements.Measurement;
import qupath.lib.measurements.MeasurementFactory;

class FloatMeasurement
implements Measurement {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final float value;

    FloatMeasurement(String name, double value) {
        this.name = name.intern();
        this.value = (float)value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Measurement) {
            Measurement that = (Measurement)o;
            return MeasurementFactory.isEqual(this, that);
        }
        return false;
    }

    public int hashCode() {
        return MeasurementFactory.hash(this);
    }
}

