/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.measurements;

import java.util.Objects;
import qupath.lib.measurements.DoubleMeasurement;
import qupath.lib.measurements.FloatMeasurement;
import qupath.lib.measurements.Measurement;

class MeasurementFactory {
    MeasurementFactory() {
    }

    public static Measurement createMeasurement(String name, double value) {
        return new DoubleMeasurement(name, value);
    }

    public static Measurement createMeasurement(String name, float value) {
        return new FloatMeasurement(name, value);
    }

    static boolean isEqual(Measurement m1, Measurement m2) {
        if (m1 == m2) {
            return true;
        }
        return Objects.equals(m1.getName(), m2.getName()) && m1.getValue() == m2.getValue();
    }

    static int hash(Measurement m) {
        return Objects.hash(m.getName(), m.getValue());
    }
}

