/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.measurements;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import qupath.lib.measurements.Measurement;
import qupath.lib.measurements.MeasurementList;

class MeasurementsMap
extends AbstractMap<String, Number>
implements Map<String, Number> {
    private final MeasurementList list;

    public MeasurementsMap(MeasurementList list) {
        this.list = list;
    }

    @Override
    public Set<Map.Entry<String, Number>> entrySet() {
        return new MeasurementEntrySet();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.list.containsKey((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof Number)) {
            return false;
        }
        Number number = (Number)value;
        double val = number.doubleValue();
        return this.list.getMeasurements().stream().anyMatch(m -> m.getValue() == val);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double get(Object key) {
        if (key instanceof String) {
            String name = (String)key;
            MeasurementList measurementList = this.list;
            synchronized (measurementList) {
                if (this.list.containsKey(name)) {
                    return this.list.get(name);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number put(String name, Number value) {
        Objects.requireNonNull(value);
        Double current = null;
        MeasurementList measurementList = this.list;
        synchronized (measurementList) {
            if (this.list.containsKey(name)) {
                current = this.list.get(name);
            }
            this.list.put(name, value.doubleValue());
            this.list.close();
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends String, ? extends Number> map) {
        MeasurementList measurementList = this.list;
        synchronized (measurementList) {
            for (Map.Entry<? extends String, ? extends Number> e : map.entrySet()) {
                Objects.requireNonNull(e.getValue());
                this.list.put(e.getKey(), e.getValue().doubleValue());
            }
            this.list.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double remove(Object key) {
        MeasurementList measurementList = this.list;
        synchronized (measurementList) {
            String name;
            if (key instanceof String && this.list.containsKey(name = (String)key)) {
                return this.list.remove(name);
            }
            return null;
        }
    }

    class MeasurementEntrySet
    extends AbstractSet<Map.Entry<String, Number>> {
        MeasurementEntrySet() {
        }

        @Override
        public int size() {
            return MeasurementsMap.this.list.size();
        }

        @Override
        public Iterator<Map.Entry<String, Number>> iterator() {
            return new Iterator<Map.Entry<String, Number>>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < MeasurementEntrySet.this.size();
                }

                @Override
                public Map.Entry<String, Number> next() {
                    Measurement measurement = MeasurementsMap.this.list.getByIndex(this.i);
                    AbstractMap.SimpleImmutableEntry<String, Number> entry = new AbstractMap.SimpleImmutableEntry<String, Number>(measurement.getName(), measurement.getValue());
                    ++this.i;
                    return entry;
                }

                @Override
                public void remove() {
                    if (this.i <= 0) {
                        throw new IllegalStateException();
                    }
                    MeasurementsMap.this.list.remove(MeasurementsMap.this.list.getNames().get(this.i - 1));
                    --this.i;
                }
            };
        }
    }
}

