/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.measurements;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.measurements.Measurement;
import qupath.lib.measurements.MeasurementFactory;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.measurements.MeasurementsMap;

class NumericMeasurementList {
    private static final Logger logger = LoggerFactory.getLogger(NumericMeasurementList.class);
    private static final Map<List<String>, NameMap> namesPool = Collections.synchronizedMap(new WeakHashMap());

    NumericMeasurementList() {
    }

    public static class FloatList
    extends AbstractNumericMeasurementList {
        private static final long serialVersionUID = 1L;
        private float[] values;

        public FloatList(int capacity) {
            super(capacity);
            this.values = new float[capacity];
            this.close();
        }

        private synchronized void ensureArraySize(int length) {
            if (this.values.length < length) {
                this.values = Arrays.copyOf(this.values, Math.max(this.values.length + 8, length));
            }
        }

        @Override
        protected synchronized void setValue(int index, double value) {
            this.ensureArraySize(index + 1);
            this.values[index] = (float)value;
        }

        @Override
        public synchronized void compactStorage() {
            super.compactStorage();
            int size = this.size();
            if (size < this.values.length) {
                this.values = Arrays.copyOf(this.values, size);
            }
        }

        @Override
        public synchronized double get(String name) {
            int ind = this.getMeasurementIndex(name);
            if (ind >= 0 && ind < this.size()) {
                return this.values[ind];
            }
            return Double.NaN;
        }

        @Override
        public synchronized List<Measurement> getMeasurements() {
            int n = this.size();
            if (n == 0) {
                return Collections.emptyList();
            }
            if (n == 1) {
                return List.of(this.getByIndex(0));
            }
            return IntStream.range(0, n).mapToObj(this::getByIndex).toList();
        }

        @Override
        public synchronized Measurement getByIndex(int ind) {
            return MeasurementFactory.createMeasurement((String)this.names.get(ind), this.values[ind]);
        }

        @Override
        protected Object getValuesArray() {
            return this.values;
        }

        @Override
        public synchronized double[] values() {
            int n = this.size();
            double[] result = new double[n];
            for (int i = 0; i < n; ++i) {
                result[i] = this.values[i];
            }
            return result;
        }
    }

    public static class DoubleList
    extends AbstractNumericMeasurementList {
        private static final long serialVersionUID = 1L;
        private double[] values;

        public DoubleList(int capacity) {
            super(capacity);
            this.values = new double[capacity];
            this.close();
        }

        @Override
        public synchronized double get(String name) {
            int ind = this.getMeasurementIndex(name);
            if (ind >= 0 && ind < this.size()) {
                return this.values[ind];
            }
            return Double.NaN;
        }

        @Override
        public synchronized List<Measurement> getMeasurements() {
            int n = this.size();
            if (n == 0) {
                return Collections.emptyList();
            }
            if (n == 1) {
                return List.of(this.getByIndex(0));
            }
            return IntStream.range(0, n).mapToObj(this::getByIndex).toList();
        }

        @Override
        public synchronized Measurement getByIndex(int ind) {
            return MeasurementFactory.createMeasurement((String)this.names.get(ind), this.values[ind]);
        }

        @Override
        public synchronized double[] values() {
            return Arrays.copyOf(this.values, this.size());
        }

        private void ensureArraySize(int length) {
            if (this.values.length < length) {
                this.values = Arrays.copyOf(this.values, Math.max(this.values.length + 8, length));
            }
        }

        @Override
        protected synchronized void setValue(int index, double value) {
            this.ensureArraySize(index + 1);
            this.values[index] = (float)value;
        }

        @Override
        public synchronized void compactStorage() {
            super.compactStorage();
            int size = this.size();
            if (size < this.values.length) {
                this.values = Arrays.copyOf(this.values, size);
            }
        }

        @Override
        protected Object getValuesArray() {
            return this.values;
        }
    }

    private static abstract class AbstractNumericMeasurementList
    implements MeasurementList {
        private static final long serialVersionUID = 1L;
        protected static final int EXPAND = 8;
        List<String> names;
        transient List<String> namesUnmodifiable;
        boolean isClosed = false;
        private Map<String, Integer> map;
        private volatile transient Map<String, Number> mapView;

        AbstractNumericMeasurementList(int capacity) {
            this.names = new ArrayList<String>(capacity);
            this.namesUnmodifiable = null;
        }

        protected abstract void setValue(int var1, double var2);

        boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public synchronized void close() {
            if (this.isClosed()) {
                return;
            }
            this.compactStorage();
            NameMap nameMap = this.getNameMap();
            this.names = nameMap.getUnmodifiableNames();
            this.namesUnmodifiable = this.names;
            this.map = nameMap.getMap();
            this.isClosed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NameMap getNameMap() {
            NameMap nameMap = namesPool.get(this.names);
            if (nameMap != null) {
                return nameMap;
            }
            Map<List<String>, NameMap> map = namesPool;
            synchronized (map) {
                nameMap = namesPool.get(this.names);
                if (nameMap == null) {
                    nameMap = new NameMap(this.names);
                    namesPool.put(nameMap.names, nameMap);
                }
                return nameMap;
            }
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.names.isEmpty();
        }

        int getMeasurementIndex(String name) {
            if (this.map != null) {
                Integer ind = this.map.get(name);
                return ind == null ? -1 : ind;
            }
            return this.names.indexOf(name);
        }

        @Override
        public final synchronized int size() {
            return this.names.size();
        }

        @Override
        public synchronized List<String> getNames() {
            if (this.names.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.isClosed() && this.namesUnmodifiable == null) {
                NameMap nameMap = this.getNameMap();
                this.namesUnmodifiable = nameMap.getUnmodifiableNames();
            }
            if (this.namesUnmodifiable == null) {
                return List.copyOf(this.names);
            }
            assert (this.names.size() == this.namesUnmodifiable.size());
            return this.namesUnmodifiable;
        }

        @Override
        public synchronized boolean containsKey(String measurementName) {
            if (!this.isClosed) {
                logger.trace("containsKey called on open NumericMeasurementList - consider closing list earlier for efficiency");
            }
            return this.names.contains(measurementName);
        }

        @Override
        public synchronized void clear() {
            this.ensureListOpen();
            this.names.clear();
            this.namesUnmodifiable = null;
            this.compactStorage();
        }

        void ensureListOpen() {
            if (this.isClosed()) {
                this.isClosed = false;
                this.map = null;
                this.names = new ArrayList<String>(this.names);
                this.namesUnmodifiable = null;
            }
        }

        @Override
        public synchronized void put(String name, double value) {
            int index = this.getMeasurementIndex(name);
            if (index >= 0) {
                this.setValue(index, value);
            } else {
                this.ensureListOpen();
                this.names.add(name.intern());
                this.setValue(this.size() - 1, value);
            }
        }

        void compactStorage() {
            if (this.isClosed()) {
                return;
            }
            if (this.names instanceof ArrayList) {
                ((ArrayList)this.names).trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Number> asMap() {
            if (this.mapView == null) {
                AbstractNumericMeasurementList abstractNumericMeasurementList = this;
                synchronized (abstractNumericMeasurementList) {
                    if (this.mapView == null) {
                        this.mapView = Collections.synchronizedMap(new MeasurementsMap(this));
                    }
                }
            }
            return this.mapView;
        }

        public synchronized String toString() {
            return "[" + this.getMeasurements().stream().map(AbstractNumericMeasurementList::toString).collect(Collectors.joining(", ")) + "]";
        }

        private static String toString(Measurement m) {
            return m.getName() + ": " + m.getValue();
        }

        protected abstract Object getValuesArray();

        @Override
        public synchronized double remove(String name) {
            int ind = this.getMeasurementIndex(name);
            if (ind < 0) {
                return Double.NaN;
            }
            this.ensureListOpen();
            Object values = this.getValuesArray();
            this.names.remove(ind);
            double value = Array.getDouble(values, ind);
            System.arraycopy(values, ind + 1, values, ind, Array.getLength(values) - ind - 1);
            return value;
        }

        @Override
        public synchronized void removeAll(String ... measurementNames) {
            this.isClosed = this.isClosed();
            for (String name : measurementNames) {
                this.remove(name);
            }
            if (this.isClosed) {
                this.close();
            }
        }
    }

    private static class NameMap {
        private List<String> names;
        private Map<String, Integer> map;

        NameMap(List<String> names) {
            this.names = List.copyOf(names);
            this.createHashMap();
        }

        private void createHashMap() {
            this.map = new HashMap<String, Integer>();
            int i = 0;
            for (String s : this.names) {
                this.map.put(s, i);
                ++i;
            }
        }

        List<String> getUnmodifiableNames() {
            return this.names;
        }

        Map<String, Integer> getMap() {
            return this.map;
        }
    }
}

