/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.util.Comparator;
import java.util.Objects;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.roi.DefaultROIComparator;

public class DefaultPathObjectComparator
implements Comparator<PathObject> {
    private static final DefaultPathObjectComparator instance = new DefaultPathObjectComparator();

    @Override
    public int compare(PathObject o1, PathObject o2) {
        Objects.requireNonNull(o1);
        Objects.requireNonNull(o2);
        if (o1 == o2) {
            return 0;
        }
        int temp = -Boolean.compare(o1.isRootObject(), o2.isRootObject());
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1.isTMACore(), o2.isTMACore());
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1.isAnnotation(), o2.isAnnotation());
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1.isDetection(), o2.isDetection());
        if (temp != 0) {
            return temp;
        }
        temp = o1.getClass().getName().compareTo(o2.getClass().getName());
        if (temp != 0) {
            return temp;
        }
        temp = DefaultROIComparator.getInstance().compare(o1.getROI(), o2.getROI());
        if (temp != 0) {
            return temp;
        }
        PathClass pc1 = o1.getPathClass();
        PathClass pc2 = o2.getPathClass();
        if (pc1 != null && pc2 != null) {
            return pc1.compareTo(pc2);
        }
        if (pc1 == null) {
            return -1;
        }
        if (pc2 != null) {
            return 1;
        }
        return o1.getID().compareTo(o2.getID());
    }

    public static Comparator<PathObject> getInstance() {
        return instance;
    }
}

