/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectConnectionGroup;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

@Deprecated
public class DefaultPathObjectConnectionGroup
implements PathObjectConnectionGroup,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultPathObjectConnectionGroup.class);
    private Map<PathObject, ObjectConnector> map = new LinkedHashMap<PathObject, ObjectConnector>();
    private transient SpatialIndex index;
    public static final String KEY_OBJECT_CONNECTIONS = "OBJECT_CONNECTIONS";

    public DefaultPathObjectConnectionGroup() {
    }

    public DefaultPathObjectConnectionGroup(PathObjectConnectionGroup connections) {
        connections.getPathObjects().stream().forEach(p -> this.map.put((PathObject)p, new ObjectConnector((PathObject)p, (Collection<PathObject>)connections.getConnectedObjects((PathObject)p))));
    }

    @Override
    public Collection<PathObject> getPathObjects() {
        return this.map.keySet();
    }

    @Override
    public List<PathObject> getConnectedObjects(PathObject pathObject) {
        ObjectConnector connector = this.map.get(pathObject);
        if (connector == null) {
            return Collections.emptyList();
        }
        return connector.getConnections();
    }

    private static double centroidDistanceSquared(PathObject pathObject1, PathObject pathObject2) {
        return DefaultPathObjectConnectionGroup.centroidDistanceSquared(PathObjectTools.getROI(pathObject1, true), PathObjectTools.getROI(pathObject2, true));
    }

    private static double centroidDistanceSquared(ROI roi1, ROI roi2) {
        double dx = roi1.getCentroidX() - roi2.getCentroidX();
        double dy = roi1.getCentroidY() - roi2.getCentroidY();
        return dx * dx + dy * dy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PathObject> getPathObjectsForRegion(ImageRegion region) {
        if (this.index == null) {
            DefaultPathObjectConnectionGroup defaultPathObjectConnectionGroup = this;
            synchronized (defaultPathObjectConnectionGroup) {
                if (this.index == null) {
                    this.index = this.buildIndex();
                }
            }
        }
        Envelope envelope = DefaultPathObjectConnectionGroup.getEnvelope(region);
        return this.index.query(envelope).stream().filter(p -> p.getROI().getZ() == region.getZ() && p.getROI().getT() == region.getT()).collect(Collectors.toSet());
    }

    private SpatialIndex buildIndex() {
        long startTime = System.currentTimeMillis();
        Quadtree index = new Quadtree();
        for (Map.Entry<PathObject, ObjectConnector> entry : this.map.entrySet()) {
            PathObject pathObject = entry.getKey();
            Envelope envelope = DefaultPathObjectConnectionGroup.getEnvelope(pathObject.getROI());
            ObjectConnector connector = entry.getValue();
            if (connector != null) {
                List<PathObject> connectedObjects = connector.getConnections();
                for (PathObject connected : connectedObjects) {
                    envelope.expandToInclude(DefaultPathObjectConnectionGroup.getEnvelope(connected.getROI()));
                }
            }
            index.insert(envelope, (Object)pathObject);
        }
        long endTime = System.currentTimeMillis();
        logger.debug("Spatial index built in {} ms", (Object)(endTime - startTime));
        return index;
    }

    private static Envelope getEnvelope(ImageRegion region) {
        return new Envelope((double)region.getMinX(), (double)region.getMaxX(), (double)region.getMinY(), (double)region.getMaxY());
    }

    private static Envelope getEnvelope(ROI roi) {
        return new Envelope(roi.getBoundsX(), roi.getBoundsX() + roi.getBoundsWidth(), roi.getBoundsY(), roi.getBoundsY() + roi.getBoundsHeight());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeObject(this.map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 1L) {
            logger.warn("Unexpected {} version number {}", DefaultPathObjectConnectionGroup.class, (Object)version);
        }
        Map readMap = (Map)in.readObject();
        this.map.putAll(readMap);
    }

    @Override
    public boolean containsObject(PathObject pathObject) {
        return this.map.containsKey(pathObject);
    }

    static class ObjectConnector
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private PathObject pathObject;
        private List<PathObject> connections = new ArrayList<PathObject>();
        private transient List<PathObject> connectionsUnmodifiable;

        public ObjectConnector() {
        }

        ObjectConnector(PathObject pathObject) {
            this.pathObject = pathObject;
        }

        ObjectConnector(PathObject pathObject, Collection<PathObject> connections) {
            this.pathObject = pathObject;
            this.connections.addAll(connections);
        }

        public boolean addConnection(PathObject newObject) {
            return this.connections.add(newObject);
        }

        public boolean breakConnection(PathObject newObject) {
            return this.connections.remove(newObject);
        }

        public PathObject getPathObject() {
            return this.pathObject;
        }

        public List<PathObject> getConnections() {
            return this.connections;
        }

        public List<PathObject> getConnectionsUnmodifiable() {
            if (this.connectionsUnmodifiable == null) {
                this.connectionsUnmodifiable = Collections.unmodifiableList(this.connections);
            }
            return this.connectionsUnmodifiable;
        }

        public void sortConnectionsByDistance() {
            Collections.sort(this.connections, (o1, o2) -> Double.compare(DefaultPathObjectConnectionGroup.centroidDistanceSquared(this.pathObject, o1), DefaultPathObjectConnectionGroup.centroidDistanceSquared(this.pathObject, o2)));
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(1L);
            out.writeObject(this.pathObject);
            out.writeObject(this.connections);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            long version = in.readLong();
            if (version != 1L) {
                logger.warn("Unexpected {} version number {}", ObjectConnector.class, (Object)version);
            }
            this.pathObject = (PathObject)in.readObject();
            this.connections = (List)in.readObject();
        }
    }
}

