/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.roi.interfaces.ROI;

public class PathCellObject
extends PathDetectionObject {
    private static final long serialVersionUID = 1L;
    private ROI nucleus;

    public PathCellObject() {
    }

    PathCellObject(ROI pathROI, ROI nucleusROI, PathClass pathClass, MeasurementList measurementList) {
        super(pathROI, pathClass, measurementList);
        this.nucleus = nucleusROI;
    }

    PathCellObject(ROI pathROI, ROI nucleusROI, PathClass pathClass) {
        this(pathROI, nucleusROI, pathClass, null);
    }

    public boolean hasNucleus() {
        return this.nucleus != null;
    }

    public ROI getNucleusROI() {
        return this.nucleus;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.nucleus);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.nucleus = (ROI)in.readObject();
    }
}

