/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectConnectionGroup;

public class PathObjectConnections
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PathObjectConnections.class);
    private List<PathObjectConnectionGroup> connections = new ArrayList<PathObjectConnectionGroup>();

    public List<PathObject> getConnections(PathObject pathObject) {
        for (PathObjectConnectionGroup group : this.connections) {
            if (!group.containsObject(pathObject)) continue;
            return group.getConnectedObjects(pathObject);
        }
        return Collections.emptyList();
    }

    public List<PathObjectConnectionGroup> getConnectionGroups() {
        return Collections.unmodifiableList(this.connections);
    }

    public void addGroup(PathObjectConnectionGroup group) {
        this.connections.add(group);
    }

    public boolean removeGroup(PathObjectConnectionGroup group) {
        return this.connections.remove(group);
    }

    public boolean isEmpty() {
        return this.connections.isEmpty();
    }

    public void clear() {
        this.connections.clear();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeObject(this.connections);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 1L) {
            logger.warn("Unexpected {} version number {}", PathObjectConnections.class, (Object)version);
        }
        List list = (List)in.readObject();
        this.connections.addAll(list);
    }
}

