/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.util.function.Predicate;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;

public enum PathObjectFilter implements Predicate<PathObject>
{
    ANNOTATIONS,
    DETECTIONS,
    DETECTIONS_ALL,
    CELLS,
    TILES,
    TMA_CORES,
    UNLOCKED,
    ROI,
    ROI_LINE,
    ROI_AREA,
    ROI_POINT;


    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "Annotations";
            }
            case 3: {
                return "Cells";
            }
            case 1: {
                return "Detections (no subtypes)";
            }
            case 2: {
                return "Detections (all)";
            }
            case 4: {
                return "Tiles";
            }
            case 5: {
                return "TMA cores";
            }
            case 6: {
                return "Unlocked";
            }
            case 7: {
                return "Has ROI";
            }
            case 8: {
                return "Has line ROI";
            }
            case 9: {
                return "Has area ROI";
            }
            case 10: {
                return "Has point ROI";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean test(PathObject p) {
        switch (this.ordinal()) {
            case 0: {
                return p.isAnnotation();
            }
            case 3: {
                return p.isCell();
            }
            case 2: {
                return p.isDetection();
            }
            case 1: {
                return p.isDetection() && PathDetectionObject.class.equals(p.getClass());
            }
            case 4: {
                return p.isTile();
            }
            case 5: {
                return p.isTMACore();
            }
            case 6: {
                return !p.isLocked();
            }
            case 7: {
                return p.hasROI();
            }
            case 8: {
                return p.hasROI() && p.getROI().isLine();
            }
            case 9: {
                return p.hasROI() && p.getROI().isArea();
            }
            case 10: {
                return p.hasROI() && p.getROI().isPoint();
            }
        }
        throw new IllegalArgumentException();
    }
}

