/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

public class PathObjects {
    public static PathObject createAnnotationObject(ROI roi, PathClass pathClass, MeasurementList measurements) {
        if (roi == null) {
            throw new IllegalArgumentException("A ROI is required to create an annotation object!");
        }
        return new PathAnnotationObject(roi, pathClass, measurements);
    }

    public static PathObject createAnnotationObject(ROI roi, PathClass pathClass) {
        return PathObjects.createAnnotationObject(roi, pathClass, null);
    }

    public static PathObject createAnnotationObject(ROI roi) {
        return PathObjects.createAnnotationObject(roi, null);
    }

    public static TMACoreObject createTMACoreObject(double xCenter, double yCenter, double diameter, boolean isMissing, ImagePlane plane) {
        return PathObjects.createTMACoreObject(xCenter - diameter / 2.0, yCenter - diameter / 2.0, diameter, diameter, isMissing, plane);
    }

    public static TMACoreObject createTMACoreObject(double xCenter, double yCenter, double diameter, boolean isMissing) {
        return PathObjects.createTMACoreObject(xCenter - diameter / 2.0, yCenter - diameter / 2.0, diameter, diameter, isMissing);
    }

    public static TMACoreObject createTMACoreObject(double x, double y, double width, double height, boolean isMissing) {
        return PathObjects.createTMACoreObject(x, y, width, height, isMissing, ImagePlane.getDefaultPlane());
    }

    public static TMACoreObject createTMACoreObject(double x, double y, double width, double height, boolean isMissing, ImagePlane plane) {
        ROI roi = ROIs.createEllipseROI(x, y, width, height, plane);
        return new TMACoreObject(roi, isMissing);
    }

    public static PathObject createDetectionObject(ROI roi, PathClass pathClass, MeasurementList measurements) {
        if (roi == null) {
            throw new IllegalArgumentException("A ROI is required to create a detection object!");
        }
        return new PathDetectionObject(roi, pathClass, measurements);
    }

    public static PathObject createDetectionObject(ROI roi, PathClass pathClass) {
        return PathObjects.createDetectionObject(roi, pathClass, null);
    }

    public static PathObject createDetectionObject(ROI roi) {
        return PathObjects.createDetectionObject(roi, null);
    }

    public static PathObject createTileObject(ROI roi, PathClass pathClass, MeasurementList measurements) {
        if (roi == null) {
            throw new IllegalArgumentException("A ROI is required to create a detection object!");
        }
        return new PathTileObject(roi, pathClass, measurements);
    }

    public static PathObject createTileObject(ROI roi, PathClass pathClass) {
        return PathObjects.createTileObject(roi, pathClass, null);
    }

    public static PathObject createTileObject(ROI roi) {
        if (roi == null) {
            throw new IllegalArgumentException("A ROI is required to create a detection object!");
        }
        return new PathTileObject(roi);
    }

    public static PathObject createCellObject(ROI roiCell, ROI roiNucleus, PathClass pathClass, MeasurementList measurements) {
        return new PathCellObject(roiCell, roiNucleus, pathClass, measurements);
    }

    public static PathObject createCellObject(ROI roiCell, ROI roiNucleus, PathClass pathClass) {
        return PathObjects.createCellObject(roiCell, roiNucleus, pathClass, null);
    }

    public static PathObject createCellObject(ROI roiCell, ROI roiNucleus) {
        return PathObjects.createCellObject(roiCell, roiNucleus, null);
    }
}

