/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.classes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import qupath.lib.common.ColorTools;
import qupath.lib.objects.classes.PathClass;

public final class PathClassTools {
    private static Set<String> gradedIntensityClassNames = Set.of("1+", "2+", "3+");

    private PathClassTools() {
        throw new AssertionError();
    }

    public static boolean isGradedIntensityClass(PathClass pathClass) {
        return pathClass != null && pathClass != PathClass.NULL_CLASS && gradedIntensityClassNames.contains(pathClass.getName());
    }

    public static boolean isIgnoredClass(PathClass pathClass) {
        return PathClassTools.isNullClass(pathClass) || pathClass.getName().endsWith("*");
    }

    public static boolean isNullClass(PathClass pathClass) {
        return pathClass == null || pathClass == PathClass.NULL_CLASS || pathClass.getName() == null;
    }

    public static boolean isValidClass(PathClass pathClass) {
        return pathClass != null && pathClass != PathClass.NULL_CLASS && pathClass.getName() != null;
    }

    public static boolean isOnePlus(PathClass pathClass) {
        return pathClass != null && "1+".equals(pathClass.getName());
    }

    public static boolean isTwoPlus(PathClass pathClass) {
        return pathClass != null && "2+".equals(pathClass.getName());
    }

    public static boolean isThreePlus(PathClass pathClass) {
        return pathClass != null && "3+".equals(pathClass.getName());
    }

    public static boolean isPositiveClass(PathClass pathClass) {
        return pathClass != null && "Positive".equals(pathClass.getName());
    }

    public static boolean isPositiveOrGradedIntensityClass(PathClass pathClass) {
        return pathClass != null && (PathClassTools.isPositiveClass(pathClass) || PathClassTools.isGradedIntensityClass(pathClass));
    }

    public static boolean isNegativeClass(PathClass pathClass) {
        return pathClass != null && "Negative".equals(pathClass.getName());
    }

    public static PathClass getNonIntensityAncestorClass(PathClass pathClass) {
        while (pathClass != null && (PathClassTools.isPositiveOrGradedIntensityClass(pathClass) || PathClassTools.isNegativeClass(pathClass))) {
            pathClass = pathClass.getParentClass();
        }
        return pathClass;
    }

    public static List<String> splitNames(PathClass pathClass) {
        if (pathClass == null || pathClass == PathClass.NULL_CLASS) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        while (pathClass != null) {
            names.add(pathClass.getName());
            pathClass = pathClass.getParentClass();
        }
        Collections.reverse(names);
        return names;
    }

    public static PathClass uniqueNames(PathClass pathClass) {
        List<String> namesUnique;
        List<String> names = PathClassTools.splitNames(pathClass);
        if (names.equals(namesUnique = names.stream().distinct().toList())) {
            return pathClass;
        }
        return PathClass.fromCollection(namesUnique);
    }

    public static PathClass sortNames(PathClass pathClass) {
        return PathClassTools.sortNames(pathClass, Comparator.naturalOrder());
    }

    public static PathClass sortNames(PathClass pathClass, Comparator<String> comparator) {
        List<String> names = PathClassTools.splitNames(pathClass);
        names.sort(comparator);
        return PathClass.fromCollection(names);
    }

    public static PathClass removeNames(PathClass pathClass, Collection<String> namesToRemove) {
        List<String> names = PathClassTools.splitNames(pathClass);
        if (names.removeAll(namesToRemove)) {
            return PathClass.fromCollection(names);
        }
        return pathClass;
    }

    public static PathClass removeNames(PathClass pathClass, String ... namesToRemove) {
        return PathClassTools.removeNames(pathClass, Arrays.asList(namesToRemove));
    }

    public static PathClass mergeClasses(PathClass baseClass, PathClass additionalClass) {
        if (Objects.equals(baseClass, additionalClass)) {
            return baseClass;
        }
        if (baseClass == PathClass.NULL_CLASS) {
            baseClass = null;
        }
        if (additionalClass == PathClass.NULL_CLASS) {
            additionalClass = null;
        }
        if (baseClass == null) {
            return additionalClass;
        }
        if (additionalClass == null) {
            return baseClass;
        }
        List<String> names = PathClassTools.splitNames(additionalClass);
        PathClass output = baseClass;
        for (String name : names) {
            if (PathClassTools.containsName(baseClass, name)) continue;
            output = PathClass.getInstance(output, name, PathClassTools.averageColors(baseClass.getColor(), additionalClass.getColor()));
        }
        return output;
    }

    static Integer averageColors(Integer rgb1, Integer rgb2) {
        if (Objects.equals(rgb1, rgb2)) {
            return rgb1;
        }
        int r = (ColorTools.red(rgb1) + ColorTools.red(rgb2)) / 2;
        int g = (ColorTools.green(rgb1) + ColorTools.green(rgb2)) / 2;
        int b = (ColorTools.blue(rgb1) + ColorTools.blue(rgb2)) / 2;
        return ColorTools.packRGB(r, g, b);
    }

    public static boolean containsName(PathClass pathClass, String name) {
        if (pathClass == null) {
            return false;
        }
        while (pathClass != null) {
            if (name.equals(pathClass.getName())) {
                return true;
            }
            pathClass = pathClass.getParentClass();
        }
        return false;
    }
}

