/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.classes;

import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;

public class Reclassifier {
    private PathObject pathObject;
    private PathClass pathClass;
    private double probability = Double.NaN;
    private boolean retainIntensityClass;

    public Reclassifier(PathObject pathObject, PathClass pathClass, boolean retainIntensityClass) {
        this(pathObject, pathClass, retainIntensityClass, Double.NaN);
    }

    public Reclassifier(PathObject pathObject, PathClass pathClass, boolean retainIntensityClass, double probability) {
        this.pathObject = pathObject;
        this.pathClass = pathClass;
        this.retainIntensityClass = retainIntensityClass;
        this.probability = probability;
    }

    public boolean apply() {
        PathClass previousClass = this.pathObject.getPathClass();
        PathClass pathClass = this.pathClass;
        if (pathClass == PathClass.NULL_CLASS) {
            pathClass = null;
        } else if (this.retainIntensityClass && previousClass != null && (PathClassTools.isPositiveOrGradedIntensityClass(previousClass) || PathClassTools.isNegativeClass(previousClass)) && (!previousClass.isDerivedClass() || previousClass.getBaseClass() == previousClass.getParentClass())) {
            pathClass = PathClass.getInstance(pathClass, previousClass.getName(), null);
        }
        this.pathObject.setPathClass(pathClass, this.probability);
        return previousClass != pathClass;
    }

    public PathObject getPathObject() {
        return this.pathObject;
    }
}

