/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.hierarchy;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.TMAGrid;

public class DefaultTMAGrid
implements TMAGrid {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultTMAGrid.class);
    private List<TMACoreObject> cores = new ArrayList<TMACoreObject>();
    private int gridWidth = -1;
    private int gridHeight = -1;

    private DefaultTMAGrid(List<TMACoreObject> cores, int gridWidth) {
        this.cores.addAll(cores);
        this.gridWidth = gridWidth;
        this.gridHeight = cores.size() / gridWidth;
    }

    public static TMAGrid create(List<TMACoreObject> cores, int gridWidth) {
        return new DefaultTMAGrid(cores, gridWidth);
    }

    int getCoreIndex(String coreName) {
        int ind = 0;
        for (TMACoreObject core : this.cores) {
            String name = core.getName();
            if (coreName == null ? name == null : coreName.equals(name)) {
                return ind;
            }
            ++ind;
        }
        return -1;
    }

    @Override
    public int nCores() {
        return this.cores.size();
    }

    int getNMissingCores() {
        int missing = 0;
        for (TMACoreObject core : this.cores) {
            if (!core.isMissing()) continue;
            ++missing;
        }
        return missing;
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public TMACoreObject getTMACore(int row, int col) {
        return this.cores.get(row * this.gridWidth + col);
    }

    @Override
    public List<TMACoreObject> getTMACoreList() {
        ArrayList<TMACoreObject> list = new ArrayList<TMACoreObject>();
        list.addAll(this.cores);
        return list;
    }

    @Override
    public TMACoreObject getTMACore(String coreName) {
        if (coreName == null) {
            logger.warn("Cannot find match to unnamed TMA core!");
            return null;
        }
        for (TMACoreObject core : this.cores) {
            if (!coreName.equals(core.getName())) continue;
            return core;
        }
        return null;
    }

    public String toString() {
        return "TMA Grid: " + this.nCores() + " cores (" + this.getGridWidth() + " x " + this.getGridHeight() + "), " + this.getNMissingCores() + " missing";
    }
}

