/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.hierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.DelaunayTools;
import qupath.lib.common.LogTools;
import qupath.lib.objects.DefaultPathObjectComparator;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectTileCache;
import qupath.lib.objects.hierarchy.TMAGrid;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

public final class PathObjectHierarchy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PathObjectHierarchy.class);
    private TMAGrid tmaGrid = null;
    private PathObject rootObject = new PathRootObject();
    private final transient PathObjectSelectionModel selectionModel = new PathObjectSelectionModel();
    private final transient List<PathObjectHierarchyListener> listeners = new ArrayList<PathObjectHierarchyListener>();
    private final transient PathObjectTileCache tileCache = new PathObjectTileCache(this);
    private transient SubdivisionManager subdivisionManager = new SubdivisionManager();
    public static final Comparator<PathObject> HIERARCHY_COMPARATOR = Comparator.comparingDouble(p -> {
        if (!p.hasROI()) {
            return Double.POSITIVE_INFINITY;
        }
        return p.getROI().getArea();
    }).thenComparing(Comparator.comparingInt(PathObject::getLevel).reversed()).thenComparing(DefaultPathObjectComparator.getInstance());

    public synchronized boolean isEmpty() {
        return (this.tmaGrid == null || this.tmaGrid.nCores() == 0) && !this.rootObject.hasChildObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PathObjectHierarchyListener listener) {
        List<PathObjectHierarchyListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PathObjectHierarchyListener listener) {
        List<PathObjectHierarchyListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public PathObject getRootObject() {
        return this.rootObject;
    }

    public synchronized TMAGrid getTMAGrid() {
        return this.tmaGrid;
    }

    public PathObjectSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public synchronized void setTMAGrid(TMAGrid tmaGrid) {
        if (this.tmaGrid == tmaGrid) {
            return;
        }
        if (this.tmaGrid != null) {
            this.removeObjects(new ArrayList<TMACoreObject>(this.tmaGrid.getTMACoreList()), false);
        }
        this.tmaGrid = tmaGrid;
        if (tmaGrid != null) {
            this.addObjects(tmaGrid.getTMACoreList());
        }
        this.fireHierarchyChangedEvent(this.getRootObject());
    }

    public synchronized boolean insertPathObject(PathObject pathObject, boolean fireChangeEvents) {
        return this.insertPathObject(this.getRootObject(), pathObject, fireChangeEvents, !fireChangeEvents);
    }

    public synchronized boolean insertPathObjects(Collection<? extends PathObject> pathObjects) {
        ArrayList<? extends PathObject> selectedObjects = new ArrayList<PathObject>(pathObjects);
        int nObjects = selectedObjects.size();
        selectedObjects.removeIf(PathObject::isTMACore);
        if (selectedObjects.size() < nObjects) {
            logger.warn("TMA core objects cannot be inserted - use resolveHierarchy() instead");
        }
        if (selectedObjects.isEmpty()) {
            return false;
        }
        this.removeObjects(selectedObjects, true);
        selectedObjects.sort(HIERARCHY_COMPARATOR.reversed());
        boolean singleObject = selectedObjects.size() == 1;
        boolean allDetections = selectedObjects.stream().allMatch(PathObject::isDetection);
        for (PathObject pathObject : selectedObjects) {
            this.insertPathObject(this.getRootObject(), pathObject, singleObject, !singleObject && !allDetections);
        }
        if (!singleObject) {
            this.fireHierarchyChangedEvent(this);
        }
        return true;
    }

    public synchronized void resolveHierarchy() {
        List tmaCores = this.tmaGrid == null ? Collections.emptyList() : this.tmaGrid.getTMACoreList();
        Collection<PathObject> annotations = this.getAnnotationObjects();
        if (annotations.isEmpty() && tmaCores.isEmpty()) {
            logger.debug("resolveHierarchy() called with no annotations or TMA cores!");
            return;
        }
        Collection<PathObject> detections = this.getDetectionObjects();
        if (annotations.size() > 1 && detections.size() > 1000) {
            logger.warn("Resolving hierarchy that contains {} annotations and {} detections - this may be slow!", (Object)annotations.size(), (Object)detections.size());
        } else if (annotations.size() > 100) {
            logger.warn("Resolving hierarchy with {} annotations - this may be slow!", (Object)annotations.size());
        }
        if (!tmaCores.isEmpty()) {
            List<PathObject> remainingDetections;
            if (!annotations.isEmpty()) {
                this.removeObjects(annotations, true);
            }
            if (!(remainingDetections = detections.stream().filter(p -> p.getParent() == this.rootObject).toList()).isEmpty()) {
                this.insertPathObjects(remainingDetections);
            }
        }
        this.insertPathObjects(annotations);
    }

    private synchronized boolean insertPathObject(PathObject pathObjectParent, PathObject pathObject, boolean fireChangeEvents, boolean resetCache) {
        if (pathObject.isTMACore()) {
            logger.warn("TMA core objects cannot be inserted - use resolveHierarchy() instead");
            return false;
        }
        ImageRegion region = ImageRegion.createInstance(pathObject.getROI());
        HashSet<PathObject> tempSet = new HashSet<PathObject>();
        tempSet.add(this.getRootObject());
        this.tileCache.getObjectsForRegion(PathAnnotationObject.class, region, tempSet, true);
        if (this.tmaGrid != null) {
            this.tileCache.getObjectsForRegion(TMACoreObject.class, region, tempSet, true);
        }
        if (pathObjectParent != null) {
            tempSet.removeIf(p -> p != pathObjectParent && !PathObjectTools.isAncestor(p, pathObjectParent));
        }
        ArrayList<PathObject> possibleParentObjects = new ArrayList<PathObject>(tempSet);
        possibleParentObjects.sort(HIERARCHY_COMPARATOR);
        for (PathObject possibleParent : possibleParentObjects) {
            boolean addObject;
            if (possibleParent == pathObject || possibleParent.isDetection()) continue;
            if (possibleParent.isRootObject()) {
                addObject = true;
            } else if (pathObject.isDetection()) {
                addObject = this.tileCache.containsCentroid(possibleParent, pathObject);
            } else {
                boolean bl = addObject = pathObjectParent != null && possibleParent == pathObjectParent || this.tileCache.covers(possibleParent, pathObject);
            }
            if (!addObject) continue;
            if (pathObject.getParent() == possibleParent) {
                return false;
            }
            ArrayList<PathObject> previousChildren = pathObject.isDetection() ? new ArrayList<PathObject>() : new ArrayList<PathObject>(possibleParent.getChildObjects());
            previousChildren.removeIf(PathObject::isTMACore);
            if (possibleParent.isTMACore()) {
                possibleParent.getParent().getChildObjects().stream().filter(PathObject::isDetection).forEach(previousChildren::add);
            }
            possibleParent.addChildObject(pathObject);
            if (!previousChildren.isEmpty()) {
                pathObject.addChildObjects(this.filterObjectsForROI(pathObject.getROI(), previousChildren));
            }
            if (fireChangeEvents) {
                this.fireObjectAddedEvent(this, pathObject);
            } else if (resetCache) {
                this.tileCache.resetCache();
            }
            return true;
        }
        return true;
    }

    public synchronized boolean removeObject(PathObject pathObject, boolean keepChildren) {
        return this.removeObject(pathObject, keepChildren, true);
    }

    public synchronized boolean removeObjectWithoutUpdate(PathObject pathObject, boolean keepChildren) {
        return this.removeObject(pathObject, keepChildren, false);
    }

    private synchronized boolean removeObject(PathObject pathObject, boolean keepChildren, boolean fireEvent) {
        PathObject pathObjectParent = pathObject.getParent();
        if (!this.inHierarchy(pathObject) || pathObjectParent == null) {
            logger.warn(String.valueOf(pathObject) + " could not be removed from the hierarchy");
            return false;
        }
        boolean hasChildren = pathObject.hasChildObjects();
        pathObjectParent.removeChildObject(pathObject);
        if (keepChildren && hasChildren) {
            pathObjectParent.addChildObjects(pathObject.getChildObjects());
        }
        if (fireEvent) {
            if (keepChildren || !hasChildren) {
                this.fireObjectRemovedEvent(this, pathObject, pathObjectParent);
            } else {
                this.fireHierarchyChangedEvent(this, pathObjectParent);
            }
        }
        return true;
    }

    public synchronized void removeObjects(Collection<? extends PathObject> pathObjects, boolean keepChildren) {
        if (pathObjects.isEmpty()) {
            return;
        }
        ArrayList<? extends PathObject> pathObjectSet = new ArrayList<PathObject>(pathObjects);
        pathObjectSet.sort((o1, o2) -> Integer.compare(o2.getLevel(), o1.getLevel()));
        HashMap<PathObject, List> map = new HashMap<PathObject, List>();
        for (PathObject pathObject : pathObjectSet) {
            PathObject parent = pathObject.getParent();
            if (parent == null) continue;
            List list = map.computeIfAbsent(parent, k -> new ArrayList());
            list.add(pathObject);
        }
        if (map.isEmpty()) {
            return;
        }
        LinkedHashSet<PathObject> childrenToKeep = new LinkedHashSet<PathObject>();
        for (Map.Entry entry : map.entrySet()) {
            PathObject parent = (PathObject)entry.getKey();
            List children = (List)entry.getValue();
            parent.removeChildObjects(children);
            if (!keepChildren) continue;
            for (PathObject child : children) {
                childrenToKeep.addAll(child.getChildObjects());
            }
        }
        childrenToKeep.removeAll(pathObjects);
        this.tileCache.resetCache();
        for (PathObject pathObject : childrenToKeep) {
            this.addPathObjectImpl(pathObject, false);
        }
        this.fireHierarchyChangedEvent(this);
    }

    private synchronized boolean inHierarchy(PathObject pathObject) {
        if (pathObject == null) {
            return false;
        }
        while (pathObject.getParent() != null) {
            pathObject = pathObject.getParent();
        }
        return pathObject.equals(this.getRootObject());
    }

    private synchronized boolean addPathObjectToList(PathObject pathObjectParent, PathObject pathObject, boolean fireChangeEvents) {
        pathObjectParent.addChildObject(pathObject);
        if (fireChangeEvents) {
            this.fireObjectAddedEvent(this, pathObject);
        }
        return true;
    }

    public boolean addObject(PathObject pathObject) {
        return this.addPathObjectImpl(pathObject, true);
    }

    public boolean addObject(PathObject pathObject, boolean fireUpdate) {
        return this.addPathObjectImpl(pathObject, fireUpdate);
    }

    public synchronized boolean addObjectBelowParent(PathObject pathObjectParent, PathObject pathObject, boolean fireUpdate) {
        if (pathObjectParent == pathObject) {
            throw new IllegalArgumentException("Cannot add a PathObject as a descendent of itself!");
        }
        if (pathObjectParent == null) {
            return this.addPathObjectImpl(pathObject, fireUpdate);
        }
        return this.addPathObjectToList(pathObjectParent, pathObject, fireUpdate);
    }

    private synchronized boolean addPathObjectImpl(PathObject pathObject, boolean fireUpdate) {
        if (pathObject == this.getRootObject() || !pathObject.hasROI()) {
            return false;
        }
        return this.addPathObjectToList(this.getRootObject(), pathObject, fireUpdate);
    }

    public synchronized boolean addObjects(Collection<? extends PathObject> pathObjects) {
        boolean changes = false;
        int n = pathObjects.size();
        int counter = 0;
        for (PathObject pathObject : pathObjects) {
            if (n > 10000) {
                if (counter % 1000 == 0) {
                    logger.debug("Adding {} of {}", (Object)counter, (Object)n);
                }
            } else if (n > 1000 && counter % 100 == 0) {
                logger.debug("Adding {} of {}", (Object)counter, (Object)n);
            }
            changes = this.addPathObjectToList(this.getRootObject(), pathObject, false) || changes;
            ++counter;
        }
        if (changes) {
            this.fireHierarchyChangedEvent(this.getRootObject());
        }
        return changes;
    }

    public synchronized void clearAll() {
        this.getRootObject().clearChildObjects();
        this.tmaGrid = null;
        this.fireHierarchyChangedEvent(this.getRootObject());
    }

    @Deprecated
    public synchronized Collection<PathObject> getPointObjects(Class<? extends PathObject> cls) {
        LogTools.warnOnce(logger, "getPointObjects() is deprecated, use getAllPointObjects() instead");
        Collection<PathObject> pathObjects = this.getObjects(null, cls);
        if (!pathObjects.isEmpty()) {
            pathObjects.removeIf(pathObject -> !PathObjectTools.hasPointROI(pathObject));
        }
        return pathObjects;
    }

    public Collection<PathObject> getAllPointObjects() {
        return this.getAllObjects(false).stream().filter(PathObjectTools::hasPointROI).toList();
    }

    public Collection<PathObject> getAllPointAnnotations() {
        return this.getAnnotationObjects().stream().filter(PathObjectTools::hasPointROI).toList();
    }

    public Collection<PathObject> getCellObjects() {
        return this.getObjects(null, PathCellObject.class);
    }

    public Collection<PathObject> getTileObjects() {
        return this.getObjects(null, PathTileObject.class);
    }

    public Collection<PathObject> getDetectionObjects() {
        return this.getObjects(null, PathDetectionObject.class);
    }

    public Collection<PathObject> getAnnotationObjects() {
        return this.getObjects(null, PathAnnotationObject.class);
    }

    public Collection<PathObject> getObjects(Collection<PathObject> pathObjects, Class<? extends PathObject> cls) {
        if (pathObjects == null) {
            pathObjects = new ArrayList<PathObject>();
        }
        if (PathAnnotationObject.class == cls && this.tileCache != null && this.tileCache.isActive()) {
            pathObjects.addAll(this.tileCache.getObjectsForRegion(cls, null, null, true));
            return pathObjects;
        }
        if (cls == null || cls.isAssignableFrom(PathRootObject.class)) {
            pathObjects.add(this.getRootObject());
        }
        return PathObjectTools.getDescendantObjects(this.getRootObject(), pathObjects, cls);
    }

    public void updateObject(PathObject pathObject, boolean isChanging) {
        if (this.inHierarchy(pathObject)) {
            this.removeObject(pathObject, true, false);
        }
        this.addPathObjectImpl(pathObject, false);
        this.fireObjectsChangedEvent(this, Collections.singletonList(pathObject), isChanging);
    }

    public synchronized List<PathObject> getFlattenedObjectList(List<PathObject> list) {
        if (list == null) {
            list = new ArrayList<PathObject>(this.nObjects() + 1);
        }
        this.getObjects(list, PathObject.class);
        return list;
    }

    public synchronized Collection<PathObject> getAllObjects(boolean includeRoot) {
        LinkedHashSet<PathObject> set = new LinkedHashSet<PathObject>(this.nObjects() + 1, 1.0f);
        this.getObjects(set, PathObject.class);
        if (includeRoot) {
            if (set.add(this.getRootObject())) {
                logger.warn("Root object was added!");
            }
        } else {
            set.remove(this.getRootObject());
        }
        return set;
    }

    public synchronized int nObjects() {
        return PathObjectTools.countDescendants(this.getRootObject());
    }

    public synchronized void setHierarchy(PathObjectHierarchy hierarchy) {
        if (this == hierarchy) {
            return;
        }
        this.rootObject = hierarchy.getRootObject();
        this.tmaGrid = hierarchy.tmaGrid;
        this.fireHierarchyChangedEvent(this.rootObject);
    }

    public Collection<PathObject> getObjectsForROI(Class<? extends PathObject> cls, ROI roi) {
        return this.getObjectsOfClassForROI(cls, roi);
    }

    private Collection<PathObject> getObjectsOfClassForROI(Class<? extends PathObject> cls, ROI roi) {
        if (roi.isEmpty() || !roi.isArea()) {
            return Collections.emptyList();
        }
        Collection<PathObject> pathObjects = this.tileCache.getObjectsForRegion(cls, ImageRegion.createInstance(roi), new HashSet<PathObject>(), true);
        return this.filterObjectsForROI(roi, pathObjects);
    }

    public Collection<PathObject> getAllObjectsForROI(ROI roi) {
        return this.getObjectsOfClassForROI(null, roi);
    }

    public Collection<PathObject> getAnnotationsForROI(ROI roi) {
        return this.getObjectsOfClassForROI(PathAnnotationObject.class, roi);
    }

    public Collection<PathObject> getTilesForROI(ROI roi) {
        return this.getObjectsOfClassForROI(PathTileObject.class, roi);
    }

    public Collection<PathObject> getCellsForROI(ROI roi) {
        return this.getObjectsOfClassForROI(PathCellObject.class, roi);
    }

    public Collection<PathObject> getAllDetectionsForROI(ROI roi) {
        return this.getObjectsOfClassForROI(PathDetectionObject.class, roi);
    }

    Collection<PathObject> filterObjectsForROI(ROI roi, Collection<PathObject> pathObjects) {
        if (pathObjects.isEmpty() || !roi.isArea() || roi.isEmpty()) {
            return Collections.emptyList();
        }
        PointOnGeometryLocator locator = this.tileCache.getLocator(roi, false);
        PreparedGeometry preparedGeometry = this.tileCache.getPreparedGeometry(this.tileCache.getGeometry(roi));
        return pathObjects.parallelStream().filter(child -> {
            if (!PathObjectHierarchy.sameZT(roi, child.getROI())) {
                return false;
            }
            if (child.isDetection()) {
                return this.tileCache.containsCentroid(locator, (PathObject)child);
            }
            return this.tileCache.covers(preparedGeometry, this.tileCache.getGeometry((PathObject)child));
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    private static boolean sameZT(ROI roi1, ROI roi2) {
        return roi1.getZ() == roi2.getZ() && roi1.getT() == roi2.getT();
    }

    @Deprecated
    public Collection<PathObject> getObjectsForRegion(Class<? extends PathObject> cls, ImageRegion region, Collection<PathObject> pathObjects) {
        return this.tileCache.getObjectsForRegion(cls, region, pathObjects, true);
    }

    public Collection<PathObject> getAllObjectsForRegion(ImageRegion region, Collection<PathObject> pathObjects) {
        return this.tileCache.getObjectsForRegion(null, region, pathObjects, true);
    }

    public Collection<PathObject> getAllObjectsForRegion(ImageRegion region) {
        return this.getAllObjectsForRegion(region, null);
    }

    public Collection<PathObject> getAnnotationsForRegion(ImageRegion region, Collection<PathObject> pathObjects) {
        return this.tileCache.getObjectsForRegion(PathAnnotationObject.class, region, pathObjects, true);
    }

    public Collection<PathObject> getAnnotationsForRegion(ImageRegion region) {
        return this.getAnnotationsForRegion(region, null);
    }

    public Collection<PathObject> getAllDetectionsForRegion(ImageRegion region, Collection<PathObject> pathObjects) {
        return this.tileCache.getObjectsForRegion(PathDetectionObject.class, region, pathObjects, true);
    }

    public Collection<PathObject> getAllDetectionsForRegion(ImageRegion region) {
        return this.getAllDetectionsForRegion(region, null);
    }

    public boolean hasObjectsForRegion(Class<? extends PathObject> cls, ImageRegion region) {
        return this.tileCache.hasObjectsForRegion(cls, region, true);
    }

    public boolean hasObjectsForRegion(ImageRegion region) {
        return this.tileCache.hasObjectsForRegion(null, region, true);
    }

    public boolean hasAnnotationsForRegion(ImageRegion region) {
        return this.tileCache.hasObjectsForRegion(PathAnnotationObject.class, region, true);
    }

    public boolean hasDetectionsForRegion(ImageRegion region) {
        return this.tileCache.hasObjectsForRegion(PathDetectionObject.class, region, true);
    }

    void fireObjectRemovedEvent(Object source, PathObject pathObject, PathObject previousParent) {
        PathObjectHierarchyEvent event = PathObjectHierarchyEvent.createObjectRemovedEvent(source, this, previousParent, pathObject);
        this.fireEvent(event);
    }

    void fireObjectAddedEvent(Object source, PathObject pathObject) {
        PathObjectHierarchyEvent event = PathObjectHierarchyEvent.createObjectAddedEvent(source, this, pathObject.getParent(), pathObject);
        this.fireEvent(event);
    }

    public void fireObjectMeasurementsChangedEvent(Object source, Collection<? extends PathObject> pathObjects) {
        this.fireObjectMeasurementsChangedEvent(source, pathObjects, false);
    }

    public void fireObjectMeasurementsChangedEvent(Object source, Collection<? extends PathObject> pathObjects, boolean isChanging) {
        PathObjectHierarchyEvent event = PathObjectHierarchyEvent.createObjectsChangedEvent(source, this, PathObjectHierarchyEvent.HierarchyEventType.CHANGE_MEASUREMENTS, pathObjects, isChanging);
        this.fireEvent(event);
    }

    public void fireObjectClassificationsChangedEvent(Object source, Collection<? extends PathObject> pathObjects) {
        PathObjectHierarchyEvent event = PathObjectHierarchyEvent.createObjectsChangedEvent(source, this, PathObjectHierarchyEvent.HierarchyEventType.CHANGE_CLASSIFICATION, pathObjects, false);
        this.fireEvent(event);
    }

    public void fireObjectsChangedEvent(Object source, Collection<? extends PathObject> pathObjects) {
        this.fireObjectsChangedEvent(source, pathObjects, false);
    }

    public void fireObjectsChangedEvent(Object source, Collection<? extends PathObject> pathObjects, boolean isChanging) {
        PathObjectHierarchyEvent event = PathObjectHierarchyEvent.createObjectsChangedEvent(source, this, PathObjectHierarchyEvent.HierarchyEventType.CHANGE_OTHER, pathObjects, isChanging);
        this.fireEvent(event);
    }

    public void fireHierarchyChangedEvent(Object source, PathObject pathObject) {
        PathObjectHierarchyEvent event = PathObjectHierarchyEvent.createStructureChangeEvent(source, this, pathObject);
        this.fireEvent(event);
    }

    public void fireHierarchyChangedEvent(Object source) {
        this.fireHierarchyChangedEvent(source, this.getRootObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fireEvent(PathObjectHierarchyEvent event) {
        List<PathObjectHierarchyListener> list = this.listeners;
        synchronized (list) {
            if (!event.isChanging() && event.isStructureChangeEvent()) {
                List<PathObject> changed = event.getChangedObjects();
                List<Class> classes = changed.stream().map(Object::getClass).distinct().toList();
                if (classes.isEmpty() || classes.contains(PathRootObject.class)) {
                    this.resetNeighbors();
                } else {
                    for (Class cls : classes) {
                        this.resetNeighborsForClass(cls);
                    }
                }
            }
            for (PathObjectHierarchyListener listener : this.listeners) {
                listener.hierarchyChanged(event);
            }
        }
    }

    private synchronized void resetNeighborsForClass(Class<? extends PathObject> cls) {
        this.subdivisionManager.clear();
    }

    private synchronized void resetNeighbors() {
        this.subdivisionManager.clear();
    }

    public synchronized List<PathObject> findAllNeighbors(PathObject pathObject) {
        DelaunayTools.Subdivision subdivision = this.getSubdivision(pathObject);
        return subdivision == null ? Collections.emptyList() : subdivision.getNeighbors(pathObject);
    }

    public synchronized PathObject findNearestNeighbor(PathObject pathObject) {
        DelaunayTools.Subdivision subdivision = this.getSubdivision(pathObject);
        return subdivision == null ? null : subdivision.getNearestNeighbor(pathObject);
    }

    public synchronized DelaunayTools.Subdivision getSubdivision(PathObject pathObject) {
        return this.subdivisionManager.getSubdivision(pathObject);
    }

    public synchronized DelaunayTools.Subdivision getDetectionSubdivision(ImagePlane plane) {
        return this.subdivisionManager.getSubdivision(PathDetectionObject.class, plane);
    }

    public synchronized DelaunayTools.Subdivision getCellSubdivision(ImagePlane plane) {
        return this.subdivisionManager.getSubdivision(PathCellObject.class, plane);
    }

    public synchronized DelaunayTools.Subdivision getAnnotationSubdivision(ImagePlane plane) {
        return this.subdivisionManager.getSubdivision(PathAnnotationObject.class, plane);
    }

    private DelaunayTools.Subdivision computeSubdivision(Class<? extends PathObject> cls) {
        Collection<PathObject> pathObjects = this.tileCache.getObjectsForRegion(cls, null, null, false);
        return DelaunayTools.createFromCentroids(pathObjects, true);
    }

    public String toString() {
        return "Hierarchy: " + this.nObjects() + " objects";
    }

    private class SubdivisionManager {
        private static final DelaunayTools.Subdivision EMPTY = DelaunayTools.createFromCentroids(Collections.emptyList(), true);
        private static final Map<Class<? extends PathObject>, Map<ImagePlane, DelaunayTools.Subdivision>> subdivisionMap = new ConcurrentHashMap<Class<? extends PathObject>, Map<ImagePlane, DelaunayTools.Subdivision>>();

        private SubdivisionManager() {
        }

        synchronized DelaunayTools.Subdivision getSubdivision(PathObject pathObject) {
            if (pathObject == null || !pathObject.hasROI()) {
                return EMPTY;
            }
            return this.getSubdivision(pathObject.getClass(), pathObject.getROI().getImagePlane());
        }

        synchronized DelaunayTools.Subdivision getSubdivision(Class<? extends PathObject> cls, ImagePlane plane) {
            Map map = subdivisionMap.computeIfAbsent(cls, k -> new ConcurrentHashMap());
            return map.computeIfAbsent(plane, k -> this.computeSubdivision(cls, plane));
        }

        private DelaunayTools.Subdivision computeSubdivision(Class<? extends PathObject> cls, ImagePlane plane) {
            Collection<PathObject> pathObjects = PathObjectHierarchy.this.tileCache.getObjectsForRegion(cls, ImageRegion.createInstance(-1073741823, -1073741823, Integer.MAX_VALUE, Integer.MAX_VALUE, plane.getZ(), plane.getT()), null, false);
            return DelaunayTools.createFromCentroids(pathObjects, true);
        }

        private synchronized void clear() {
            subdivisionMap.clear();
        }

        private synchronized void clearClass(Class<? extends PathObject> cls) {
            subdivisionMap.getOrDefault(cls, Collections.emptyMap()).clear();
        }
    }
}

