/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.hierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.TemporaryObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

class PathObjectTileCache
implements PathObjectHierarchyListener {
    public static int DEFAULT_TILE_SIZE = 1024;
    private static final Logger logger = LoggerFactory.getLogger(PathObjectTileCache.class);
    private static final Envelope MAX_ENVELOPE = new Envelope(-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE);
    private Map<ROI, Envelope> envelopeMap = new WeakHashMap<ROI, Envelope>();
    private Map<PathObject, Envelope> lastEnvelopeMap = new WeakHashMap<PathObject, Envelope>();
    private Map<Class<? extends PathObject>, SpatialIndex> map = new HashMap<Class<? extends PathObject>, SpatialIndex>();
    private static final Map<ROI, Geometry> geometryMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<ROI, PointOnGeometryLocator> locatorMap = Collections.synchronizedMap(new WeakHashMap());
    private PathObjectHierarchy hierarchy;
    private boolean isActive = false;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private Map<Geometry, PreparedGeometry> preparedGeometryMap = new WeakHashMap<Geometry, PreparedGeometry>();

    public PathObjectTileCache(PathObjectHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        if (hierarchy != null) {
            hierarchy.addListener(this);
        }
    }

    public void resetCache() {
        this.isActive = false;
        logger.trace("Cache reset!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructCache(Class<? extends PathObject> limitToClass) {
        this.w.lock();
        try {
            long startTime = System.currentTimeMillis();
            this.isActive = true;
            if (limitToClass == null) {
                this.map.clear();
            } else {
                this.map.remove(limitToClass);
            }
            this.addToCache(this.hierarchy.getRootObject(), true, limitToClass);
            long endTime = System.currentTimeMillis();
            logger.debug("Cache reconstructed in " + (double)(endTime - startTime) / 1000.0);
        }
        finally {
            this.w.unlock();
        }
    }

    private void ensureCacheConstructed() {
        if (!this.isActive()) {
            this.constructCache(null);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void addToCache(PathObject pathObject, boolean includeChildren, Class<? extends PathObject> limitToClass) {
        if (!this.isActive()) {
            return;
        }
        if (pathObject.hasROI()) {
            Class<?> cls = pathObject.getClass();
            if (limitToClass == null || cls == limitToClass) {
                SpatialIndex mapObjects = this.map.get(cls);
                if (mapObjects == null) {
                    mapObjects = this.createSpatialIndex();
                    this.map.put(cls, mapObjects);
                }
                Envelope envelope = this.getEnvelope(pathObject);
                mapObjects.insert(envelope, (Object)pathObject);
            }
        }
        if (includeChildren && !(pathObject instanceof TemporaryObject) && pathObject.hasChildObjects()) {
            for (PathObject child : pathObject.getChildObjectsAsArray()) {
                this.addToCache(child, includeChildren, limitToClass);
            }
        }
    }

    Geometry getGeometry(ROI roi) {
        Geometry geometry = geometryMap.get(roi);
        if (geometry == null) {
            return roi.getGeometry();
        }
        return geometry;
    }

    Geometry getGeometry(PathObject pathObject) {
        ROI roi = pathObject.getROI();
        Geometry geometry = geometryMap.get(roi);
        if (geometry == null) {
            geometry = roi.getGeometry();
            if (pathObject.isAnnotation() || pathObject.isTMACore()) {
                geometryMap.put(roi, geometry);
            }
        }
        return geometry;
    }

    private Coordinate getCentroidCoordinate(PathObject pathObject) {
        ROI roi = PathObjectTools.getROI(pathObject, true);
        return new Coordinate(roi.getCentroidX(), roi.getCentroidY());
    }

    PointOnGeometryLocator getLocator(ROI roi, boolean addToCache) {
        Object locator = locatorMap.get(roi);
        if (locator == null) {
            Geometry geometry = this.getGeometry(roi);
            locator = geometry instanceof Polygonal || geometry instanceof LinearRing ? new IndexedPointInAreaLocator(geometry) : new SimplePointInAreaLocator(geometry);
            locator.locate(new Coordinate());
            locatorMap.put(roi, (PointOnGeometryLocator)locator);
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedGeometry getPreparedGeometry(Geometry geometry) {
        PreparedGeometry prepared = this.preparedGeometryMap.get(geometry);
        if (prepared != null) {
            return prepared;
        }
        Map<Geometry, PreparedGeometry> map = this.preparedGeometryMap;
        synchronized (map) {
            prepared = this.preparedGeometryMap.get(geometry);
            if (prepared != null) {
                return prepared;
            }
            prepared = PreparedGeometryFactory.prepare((Geometry)geometry);
            this.preparedGeometryMap.put(geometry, prepared);
            return prepared;
        }
    }

    boolean covers(PathObject possibleParent, PathObject possibleChild) {
        Geometry child = this.getGeometry(possibleChild);
        if (possibleParent.isAnnotation() && this.getLocator(possibleParent.getROI(), true).locate(child.getCoordinate()) == 2) {
            return false;
        }
        Geometry parent = this.getGeometry(possibleParent);
        return this.covers(parent, child);
    }

    boolean covers(PreparedGeometry parent, Geometry child) {
        return parent.covers(child);
    }

    boolean covers(Geometry parent, Geometry child) {
        return this.covers(this.getPreparedGeometry(parent), child);
    }

    boolean containsCentroid(PathObject possibleParent, PathObject possibleChild) {
        Coordinate centroid = this.getCentroidCoordinate(possibleChild);
        if (centroid == null) {
            return false;
        }
        if (possibleParent.isDetection()) {
            return SimplePointInAreaLocator.locate((Coordinate)centroid, (Geometry)this.getGeometry(possibleParent)) != 2;
        }
        return this.getLocator(possibleParent.getROI(), true).locate(centroid) != 2;
    }

    boolean containsCentroid(PointOnGeometryLocator locator, PathObject possibleChild) {
        Coordinate centroid = this.getCentroidCoordinate(possibleChild);
        if (centroid == null) {
            return false;
        }
        return locator.locate(centroid) != 2;
    }

    boolean containsCentroid(Geometry possibleParent, PathObject possibleChild) {
        Coordinate centroid = this.getCentroidCoordinate(possibleChild);
        if (centroid == null) {
            return false;
        }
        return SimplePointInAreaLocator.locate((Coordinate)centroid, (Geometry)possibleParent) != 2;
    }

    private SpatialIndex createSpatialIndex() {
        return new Quadtree();
    }

    private Envelope getEnvelope(PathObject pathObject) {
        Envelope envelope = this.getEnvelope(pathObject.getROI());
        this.lastEnvelopeMap.put(pathObject, envelope);
        return envelope;
    }

    private Envelope getEnvelope(ROI roi) {
        Envelope envelope = this.envelopeMap.get(roi);
        if (envelope == null) {
            envelope = new Envelope(roi.getBoundsX(), roi.getBoundsX() + roi.getBoundsWidth(), roi.getBoundsY(), roi.getBoundsY() + roi.getBoundsHeight());
            this.envelopeMap.put(roi, envelope);
        }
        return envelope;
    }

    private Envelope getEnvelope(ImageRegion region) {
        return new Envelope((double)region.getMinX(), (double)region.getMaxX(), (double)region.getMinY(), (double)region.getMaxY());
    }

    private void removeFromCache(PathObject pathObject, boolean removeChildren) {
        if (!this.isActive()) {
            return;
        }
        SpatialIndex mapObjects = this.map.get(pathObject.getClass());
        if (mapObjects instanceof Quadtree) {
            Envelope envelope = this.lastEnvelopeMap.get(pathObject);
            envelope = MAX_ENVELOPE;
            if (envelope != null) {
                if (mapObjects.remove(envelope, (Object)pathObject)) {
                    logger.debug("Removed {} from cache", (Object)pathObject);
                } else {
                    logger.debug("Unable to remove {} from cache", (Object)pathObject);
                }
            } else {
                logger.debug("No envelope found for {}", (Object)pathObject);
            }
            if (removeChildren) {
                for (PathObject child : pathObject.getChildObjectsAsArray()) {
                    this.removeFromCache(child, removeChildren);
                }
            }
        } else if (mapObjects instanceof SpatialIndex && !removeChildren) {
            this.constructCache(pathObject.getClass());
        } else {
            this.constructCache(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PathObject> getObjectsForRegion(Class<? extends PathObject> cls, ImageRegion region, Collection<PathObject> pathObjects, boolean includeSubclasses) {
        this.ensureCacheConstructed();
        Envelope envelope = region == null ? MAX_ENVELOPE : this.getEnvelope(region);
        int z = region == null ? -1 : region.getZ();
        int t = region == null ? -1 : region.getT();
        this.r.lock();
        try {
            Collection<PathObject> collection;
            for (Map.Entry<Class<? extends PathObject>, SpatialIndex> entry : this.map.entrySet()) {
                List list;
                if (cls != null && (!includeSubclasses || !cls.isAssignableFrom(entry.getKey())) && !Objects.equals(cls, entry.getKey()) || entry.getValue() == null || (list = entry.getValue().query(envelope)).isEmpty()) continue;
                if (pathObjects == null) {
                    pathObjects = new HashSet<PathObject>();
                }
                for (PathObject pathObject : list) {
                    ROI roi = pathObject.getROI();
                    if (roi != null && region != null && (roi.getZ() != z || roi.getT() != t) || pathObject.getParent() == null && !pathObject.isRootObject() || !envelope.intersects(this.getEnvelope(pathObject))) continue;
                    pathObjects.add(pathObject);
                }
            }
            if (pathObjects == null) {
                collection = Collections.emptySet();
                return collection;
            }
            collection = pathObjects;
            return collection;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObjectsForRegion(Class<? extends PathObject> cls, ImageRegion region, boolean includeSubclasses) {
        this.ensureCacheConstructed();
        Envelope envelope = region == null ? MAX_ENVELOPE : this.getEnvelope(region);
        int z = region == null ? -1 : region.getZ();
        int t = region == null ? -1 : region.getT();
        this.r.lock();
        try {
            for (Map.Entry<Class<? extends PathObject>, SpatialIndex> entry : this.map.entrySet()) {
                if (cls != null && !Objects.equals(cls, entry.getKey()) && (!includeSubclasses || !cls.isAssignableFrom(entry.getKey())) || entry.getValue() == null) continue;
                List list = entry.getValue().query(envelope);
                for (PathObject pathObject : list) {
                    ROI roi = pathObject.getROI();
                    if (roi == null) continue;
                    if (region == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (roi.getZ() != z || roi.getT() != t) continue;
                    if (!region.intersects(roi.getBoundsX(), roi.getBoundsY(), roi.getBoundsWidth(), roi.getBoundsHeight())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        this.w.lock();
        try {
            PathObject singleObject;
            boolean singleChange = event.getChangedObjects().size() == 1;
            PathObject pathObject = singleObject = singleChange ? event.getChangedObjects().get(0) : null;
            if (singleChange && event.getEventType() == PathObjectHierarchyEvent.HierarchyEventType.ADDED) {
                this.removeFromCache(singleObject, false);
                this.addToCache(singleObject, false, singleObject.getClass());
            } else if (singleChange && event.getEventType() == PathObjectHierarchyEvent.HierarchyEventType.REMOVED) {
                this.removeFromCache(singleObject, false);
            } else if (!(event.getEventType() != PathObjectHierarchyEvent.HierarchyEventType.OTHER_STRUCTURE_CHANGE && event.getEventType() != PathObjectHierarchyEvent.HierarchyEventType.CHANGE_OTHER || event.isChanging())) {
                this.resetCache();
            }
        }
        finally {
            this.w.unlock();
        }
    }
}

