/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.hierarchy.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionListener;
import qupath.lib.roi.interfaces.ROI;

public class PathObjectSelectionModel {
    private List<PathObjectSelectionListener> listeners = Collections.synchronizedList(new ArrayList());
    private Set<PathObject> selectedSet = Collections.synchronizedSet(new LinkedHashSet(256));
    private Set<PathObject> selectedSetUnmodifiable = Collections.unmodifiableSet(this.selectedSet);
    private PathObject pathObjectSelected = null;

    public synchronized void setSelectedObjects(Collection<? extends PathObject> pathObjects, PathObject primarySelectedObject) {
        if (pathObjects == null || pathObjects.isEmpty()) {
            this.clearSelection();
            return;
        }
        if (this.pathObjectSelected == primarySelectedObject && this.selectedSet.size() == pathObjects.size() && this.selectedSet.containsAll(pathObjects)) {
            return;
        }
        PathObject previousSelected = this.pathObjectSelected;
        this.selectedSet.clear();
        this.selectedSet.addAll(pathObjects);
        this.selectedSet.remove(null);
        this.pathObjectSelected = primarySelectedObject;
        this.firePathObjectSelectionChangedEvent(this.pathObjectSelected, previousSelected);
    }

    public synchronized Set<PathObject> getSelectedObjects() {
        return this.selectedSetUnmodifiable;
    }

    public synchronized boolean noSelection() {
        return this.pathObjectSelected == null && this.selectedSet.isEmpty();
    }

    public synchronized boolean singleSelection() {
        return this.selectedSet.size() == 1 || this.selectedSet.isEmpty() && this.pathObjectSelected != null;
    }

    public void setSelectedObject(PathObject pathObject, boolean addToSelection) {
        if (!addToSelection) {
            this.setSelectedObject(pathObject);
            return;
        }
        if (pathObject == null) {
            return;
        }
        PathObject previousSelected = this.pathObjectSelected;
        this.selectedSet.add(pathObject);
        this.pathObjectSelected = pathObject;
        this.firePathObjectSelectionChangedEvent(this.pathObjectSelected, previousSelected);
    }

    private synchronized void updateToLastSelectedObject() {
        for (PathObject this.pathObjectSelected : this.selectedSet) {
        }
    }

    public void deselectObject(PathObject pathObject) {
        PathObject previousSelected = this.pathObjectSelected;
        boolean changes = this.selectedSet.remove(pathObject);
        if (this.pathObjectSelected == previousSelected) {
            this.pathObjectSelected = null;
            this.updateToLastSelectedObject();
            changes = true;
        }
        if (changes) {
            this.firePathObjectSelectionChangedEvent(this.pathObjectSelected, previousSelected);
        }
    }

    public void deselectObjects(Collection<? extends PathObject> pathObjects) {
        if (this.selectedSet.removeAll(pathObjects)) {
            PathObject previousSelected = this.pathObjectSelected;
            if (pathObjects.contains(this.pathObjectSelected)) {
                this.updateToLastSelectedObject();
            }
            this.firePathObjectSelectionChangedEvent(this.pathObjectSelected, previousSelected);
        }
    }

    public void selectObjects(Collection<? extends PathObject> pathObjects) {
        if (this.selectedSet.addAll(pathObjects)) {
            PathObject previousSelected = this.pathObjectSelected;
            if (previousSelected == null) {
                this.updateToLastSelectedObject();
            }
            this.firePathObjectSelectionChangedEvent(this.pathObjectSelected, previousSelected);
        }
    }

    public void setSelectedObject(PathObject pathObject) {
        PathObject previousObject = this.pathObjectSelected;
        this.pathObjectSelected = pathObject;
        this.selectedSet.clear();
        if (this.pathObjectSelected != null) {
            this.selectedSet.add(this.pathObjectSelected);
        }
        this.firePathObjectSelectionChangedEvent(this.pathObjectSelected, previousObject);
    }

    public PathObject getSelectedObject() {
        return this.pathObjectSelected;
    }

    public boolean isSelected(PathObject pathObject) {
        return this.pathObjectSelected == pathObject || this.selectedSet.contains(pathObject);
    }

    public ROI getSelectedROI() {
        if (this.pathObjectSelected != null) {
            return this.pathObjectSelected.getROI();
        }
        return null;
    }

    public synchronized void clearSelection() {
        if (this.noSelection()) {
            return;
        }
        this.selectedSet.clear();
        PathObject previous = this.pathObjectSelected;
        this.pathObjectSelected = null;
        this.firePathObjectSelectionChangedEvent(null, previous);
    }

    synchronized void firePathObjectSelectionChangedEvent(PathObject pathObjectSelected, PathObject previousObject) {
        Set<PathObject> allSelected = Collections.unmodifiableSet(new HashSet<PathObject>(this.selectedSet));
        for (PathObjectSelectionListener listener : this.listeners) {
            listener.selectedPathObjectChanged(pathObjectSelected, previousObject, allSelected);
        }
    }

    public synchronized void addPathObjectSelectionListener(PathObjectSelectionListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removePathObjectSelectionListener(PathObjectSelectionListener listener) {
        this.listeners.remove(listener);
    }
}

