/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.index.strtree.STRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.objects.DefaultPathObjectComparator;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.utils.ObjectProcessor;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class OverlapFixer
implements ObjectProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OverlapFixer.class);
    private final Supplier<Comparator<PathObject>> comparatorSupplier;
    private final double minArea;
    private final boolean keepFragments;
    private final Strategy strategy;

    private OverlapFixer(Strategy strategy, double minArea, Supplier<Comparator<PathObject>> comparatorSupplier, boolean keepFragments) {
        this.strategy = strategy;
        this.minArea = minArea;
        this.comparatorSupplier = comparatorSupplier;
        this.keepFragments = keepFragments;
    }

    @Override
    public List<PathObject> process(Collection<? extends PathObject> pathObjects) {
        int nInput = pathObjects.size();
        List<PathObject> list = pathObjects.parallelStream().filter(p -> p.hasROI() && p.getROI().getArea() >= this.minArea).collect(Collectors.toList());
        if (this.strategy == Strategy.KEEP_OVERLAPS) {
            return list;
        }
        GeometryCache cache = new GeometryCache();
        pathObjects.parallelStream().forEach(cache::add);
        STRtree immutableIndex = new STRtree();
        OverlapFixer.populateSpatialIndex(pathObjects, (SpatialIndex)immutableIndex, cache);
        for (PathObject pathObject : pathObjects) {
            immutableIndex.insert(cache.getEnvelope(pathObject), (Object)pathObject);
        }
        Map<Boolean, List> overlapMap = pathObjects.parallelStream().collect(Collectors.groupingBy(arg_0 -> OverlapFixer.lambda$process$1((SpatialIndex)immutableIndex, cache, arg_0), Collectors.toCollection(ArrayList::new)));
        List list2 = overlapMap.computeIfAbsent(Boolean.FALSE, b -> new ArrayList());
        if (overlapMap.getOrDefault(Boolean.TRUE, Collections.emptyList()).isEmpty()) {
            logger.debug("No overlaps found in {} objects", (Object)nInput);
            return list2;
        }
        Comparator<PathObject> comparator = this.comparatorSupplier.get();
        TreeSet<PathObject> toProcess = new TreeSet<PathObject>(comparator);
        toProcess.addAll(overlapMap.get(Boolean.TRUE));
        Quadtree index = new Quadtree();
        OverlapFixer.populateSpatialIndex(toProcess, (SpatialIndex)index, cache);
        while (!toProcess.isEmpty()) {
            PathObject pathObject = (PathObject)toProcess.removeFirst();
            Envelope envelope = cache.getEnvelope(pathObject);
            List<PathObject> overlapping = index.query(envelope);
            if (!overlapping.contains(pathObject)) continue;
            list2.add(pathObject);
            if (overlapping.size() > 1) {
                Geometry geom = cache.getGeometry(pathObject);
                if (overlapping.size() > 2) {
                    PreparedGeometry prepared = PreparedGeometryFactory.prepare((Geometry)geom);
                    overlapping = overlapping.stream().filter(p -> p != pathObject).filter(p -> prepared.overlaps(cache.getGeometry((PathObject)p)) || geom.equalsExact(cache.getGeometry((PathObject)p))).sorted(comparator).toList();
                } else {
                    overlapping = overlapping.stream().filter(p -> p != pathObject).filter(p -> geom.overlaps(cache.getGeometry((PathObject)p)) || geom.equalsExact(cache.getGeometry((PathObject)p))).sorted(comparator).toList();
                }
            }
            if (overlapping.isEmpty()) continue;
            for (PathObject overlap : overlapping) {
                if (!index.remove(cache.getEnvelope(overlap), (Object)overlap)) {
                    logger.warn("Failed to remove object from index: " + String.valueOf(overlap));
                }
                toProcess.remove(overlap);
            }
            if (this.strategy != Strategy.CLIP_OVERLAPS) continue;
            ArrayList<ROI> previousROIs = new ArrayList<ROI>();
            previousROIs.add(pathObject.getROI());
            for (PathObject overlap : overlapping) {
                ROI roiCurrent = overlap.getROI();
                int nPiecesOriginally = roiCurrent.getGeometry().getNumGeometries();
                ROI roiUpdated = RoiTools.subtract(roiCurrent, previousROIs);
                ROI roiNucleus = PathObjectTools.getNucleusROI(overlap);
                if (roiNucleus != null) {
                    roiNucleus = RoiTools.subtract(roiNucleus, previousROIs);
                }
                int nPieces = roiUpdated.getGeometry().getNumGeometries();
                if (!this.keepFragments && nPieces > nPiecesOriginally || roiUpdated.isEmpty() || !roiUpdated.isArea() || !(roiUpdated.getArea() >= this.minArea)) continue;
                PathObject clippedObject = PathObjectTools.createLike(pathObject, roiUpdated, roiNucleus);
                index.insert(cache.getEnvelope(clippedObject), (Object)clippedObject);
                previousROIs.add(roiCurrent);
                toProcess.add(clippedObject);
            }
        }
        logger.debug("Processed {} objects to fix overlaps, retaining {} objects", (Object)nInput, (Object)list2.size());
        return list2;
    }

    private static void populateSpatialIndex(Collection<? extends PathObject> pathObjects, SpatialIndex index, GeometryCache cache) {
        for (PathObject pathObject : pathObjects) {
            index.insert(cache.getEnvelope(pathObject), (Object)pathObject);
        }
    }

    private static boolean containsOverlaps(PathObject pathObject, SpatialIndex index, GeometryCache cache) {
        Envelope envelope = cache.getEnvelope(pathObject);
        List maybeOverlapping = index.query(envelope);
        if (maybeOverlapping.size() <= 1) {
            return false;
        }
        Geometry geom = cache.getGeometry(pathObject);
        for (PathObject maybe : maybeOverlapping) {
            Geometry geomMaybe;
            if (maybe == pathObject || !geom.overlaps(geomMaybe = cache.getGeometry(maybe)) && !geom.equalsExact(geomMaybe)) continue;
            return true;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static /* synthetic */ Boolean lambda$process$1(SpatialIndex immutableIndex, GeometryCache cache, PathObject p) {
        return OverlapFixer.containsOverlaps(p, immutableIndex, cache);
    }

    public static enum Strategy {
        KEEP_OVERLAPS,
        DROP_OVERLAPS,
        CLIP_OVERLAPS;

    }

    private static class GeometryCache {
        private final Map<ROI, Geometry> geometryMap = new ConcurrentHashMap<ROI, Geometry>();
        private final Map<ROI, Envelope> envelopMap = new ConcurrentHashMap<ROI, Envelope>();

        private GeometryCache() {
        }

        private void add(PathObject pathObject) {
            ROI roi = pathObject.getROI();
            Geometry geom = roi.getGeometry().norm();
            this.geometryMap.put(roi, geom);
            this.envelopMap.put(roi, this.getEnvelope(pathObject));
        }

        private Geometry getGeometry(PathObject pathObject) {
            return this.getGeometry(pathObject.getROI());
        }

        private Geometry getGeometry(ROI roi) {
            return this.geometryMap.computeIfAbsent(roi, r -> r.getGeometry().norm());
        }

        private Envelope getEnvelope(PathObject pathObject) {
            return this.getEnvelope(pathObject.getROI());
        }

        private Envelope getEnvelope(ROI roi) {
            return this.envelopMap.computeIfAbsent(roi, r -> this.getGeometry((ROI)r).getEnvelopeInternal());
        }
    }

    public static class Builder {
        private Supplier<Comparator<PathObject>> comparator = () -> Comparators.createAreaFirstComparator();
        private double minArea = Double.NEGATIVE_INFINITY;
        private Strategy strategy = Strategy.CLIP_OVERLAPS;
        private boolean keepFragments = false;

        private Builder() {
        }

        public Builder setMinArea(double minArea) {
            this.minArea = minArea;
            return this;
        }

        public Builder setComparator(Comparator<PathObject> comparator) {
            this.comparator = () -> comparator;
            return this;
        }

        public Builder sortBySolidity() {
            this.comparator = () -> Comparators.createSolidityFirstComparator();
            return this;
        }

        public Builder sortByArea() {
            this.comparator = () -> Comparators.createAreaFirstComparator();
            return this;
        }

        public Builder keepFragments() {
            return this.keepFragments(true);
        }

        public Builder keepFragments(boolean doKeep) {
            this.keepFragments = doKeep;
            return this;
        }

        public Builder discardFragments() {
            return this.keepFragments(false);
        }

        public Builder setStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder clipOverlaps() {
            this.strategy = Strategy.CLIP_OVERLAPS;
            return this;
        }

        public Builder dropOverlaps() {
            this.strategy = Strategy.DROP_OVERLAPS;
            return this;
        }

        public OverlapFixer build() {
            return new OverlapFixer(this.strategy, this.minArea, this.comparator, this.keepFragments);
        }
    }

    private static class Comparators {
        private Map<ROI, Double> solidityMap = new ConcurrentHashMap<ROI, Double>();
        private Map<ROI, Double> areaMap = new ConcurrentHashMap<ROI, Double>();
        private Map<ROI, Double> lengthMap = new ConcurrentHashMap<ROI, Double>();
        private Map<ROI, Integer> pointsMap = new ConcurrentHashMap<ROI, Integer>();

        private Comparators() {
        }

        private static Comparator<PathObject> createAreaFirstComparator() {
            Comparators c = new Comparators();
            return c.compareByArea().thenComparing(c.compareByLength()).thenComparing(c.compareByPoints()).thenComparing(DefaultPathObjectComparator.getInstance());
        }

        private static Comparator<PathObject> createSolidityFirstComparator() {
            Comparators c = new Comparators();
            return c.compareBySolidity().thenComparing(c.compareByArea()).thenComparing(c.compareByLength()).thenComparing(c.compareByPoints()).thenComparing(DefaultPathObjectComparator.getInstance());
        }

        private Comparator<PathObject> compareBySolidity() {
            return Comparator.comparingDouble(p -> -this.solidityMap.computeIfAbsent(p.getROI(), ROI::getSolidity).doubleValue());
        }

        private Comparator<PathObject> compareByArea() {
            return Comparator.comparingDouble(p -> -this.areaMap.computeIfAbsent(p.getROI(), ROI::getArea).doubleValue());
        }

        private Comparator<PathObject> compareByLength() {
            return Comparator.comparingDouble(p -> -this.lengthMap.computeIfAbsent(p.getROI(), ROI::getArea).doubleValue());
        }

        private Comparator<PathObject> compareByPoints() {
            return Comparator.comparingInt(p -> -this.pointsMap.computeIfAbsent(p.getROI(), ROI::getNumPoints).intValue());
        }
    }

    private static enum ComparatorType {
        AREA,
        SOLIDITY;

    }
}

