/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.plugins.AbstractPlugin;
import qupath.lib.plugins.PathInteractivePlugin;
import qupath.lib.plugins.parameters.ParameterList;

public abstract class AbstractInteractivePlugin<T>
extends AbstractPlugin<T>
implements PathInteractivePlugin<T> {
    protected transient ParameterList params;
    private static final Logger logger = LoggerFactory.getLogger(AbstractInteractivePlugin.class);

    @Override
    public abstract ParameterList getDefaultParameterList(ImageData<T> var1);

    @Override
    public boolean alwaysPromptForObjects() {
        return false;
    }

    protected ParameterList getParameterList(ImageData<T> imageData) {
        if (this.params == null) {
            this.params = this.getDefaultParameterList(imageData);
        }
        return this.params;
    }

    @Override
    protected boolean parseArgument(ImageData<T> imageData, String arg) {
        if (arg != null) {
            logger.trace("Updating parameters with arg: {}", (Object)arg);
            Map<String, String> map = GeneralTools.parseArgStringValues(arg);
            this.params = this.getParameterList(imageData);
            ParameterList.updateParameterList(this.params, map, Locale.US);
        }
        return imageData != null;
    }

    protected ParameterList getLoggableParameters(ImageData<T> imageData) {
        ParameterList params = this.getParameterList(imageData).duplicate();
        params.removeEmptyParameters();
        return params;
    }
}

