/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.plugins.AbstractTaskRunner;
import qupath.lib.plugins.SimpleProgressMonitor;
import qupath.lib.regions.ImageRegion;

public class CommandLineTaskRunner
extends AbstractTaskRunner {
    public CommandLineTaskRunner() {
    }

    public CommandLineTaskRunner(int nThreads) {
        super(nThreads);
    }

    @Override
    public SimpleProgressMonitor makeProgressMonitor() {
        return new CommandLineProgressMonitor();
    }

    public static class CommandLineProgressMonitor
    implements SimpleProgressMonitor {
        private static final Logger logger = LoggerFactory.getLogger(CommandLineProgressMonitor.class);
        private long startTime;
        private AtomicInteger progress = new AtomicInteger(0);
        private int maxProgress;
        private String lastMessage;

        @Override
        public void startMonitoring(String message, int maxProgress, boolean mayCancel) {
            this.startTime = System.currentTimeMillis();
            this.maxProgress = maxProgress;
            if (message != null) {
                logger.info(message);
            }
        }

        @Override
        public synchronized void updateProgress(int increment, String message, ImageRegion region) {
            int progressValue = this.progress.addAndGet(increment);
            int progressPercent = (int)((double)progressValue / (double)this.maxProgress * 100.0 + 0.5);
            String newMessage = message + " (" + progressPercent + "%)";
            if (!newMessage.equals(this.lastMessage) || progressValue >= this.maxProgress) {
                logger.info(newMessage);
            }
            this.lastMessage = newMessage;
            if (progressValue >= this.maxProgress) {
                this.pluginCompleted(String.format("Processing complete in %.2f seconds", (double)(System.currentTimeMillis() - this.startTime) / 1000.0));
            }
        }

        @Override
        public void pluginCompleted(String message) {
            logger.info(message);
        }

        @Override
        public boolean cancelled() {
            return false;
        }
    }
}

