/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.parameters;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import qupath.lib.plugins.parameters.AbstractParameter;
import qupath.lib.plugins.parameters.Parameter;

public class ChoiceParameter<S>
extends AbstractParameter<S> {
    private static final long serialVersionUID = 1L;
    protected List<S> choices = null;

    ChoiceParameter(String prompt, S defaultValue, List<S> choices, S lastValue, String helpText, boolean isHidden) {
        super(prompt, defaultValue, lastValue, helpText, isHidden);
        this.choices = choices;
    }

    ChoiceParameter(String prompt, S defaultValue, List<S> choices, S lastValue, String helpText) {
        this(prompt, defaultValue, choices, lastValue, helpText, false);
    }

    ChoiceParameter(String prompt, S defaultValue, List<S> choices, String helpText) {
        this(prompt, defaultValue, (List<Object>)choices, null, helpText);
    }

    ChoiceParameter(String prompt, S defaultValue, S[] choices, String helpText) {
        this(prompt, defaultValue, Arrays.asList(choices), helpText);
    }

    public List<S> getChoices() {
        return this.choices;
    }

    @Override
    public boolean isValidInput(S value) {
        return this.choices.contains(value);
    }

    @Override
    public boolean setStringLastValue(Locale locale, String value) {
        for (S choice : this.choices) {
            String choiceValue = choice.toString();
            if (!choiceValue.equals(value)) continue;
            return this.setValue((Object)choice);
        }
        for (S choice : this.choices) {
            String name;
            if (!(choice instanceof Enum) || !(name = ((Enum)choice).name()).equals(value)) continue;
            return this.setValue((Object)choice);
        }
        return false;
    }

    @Override
    public Parameter<S> duplicate() {
        return new ChoiceParameter<Object>(this.getPrompt(), this.getDefaultValue(), this.getChoices(), this.getValue(), this.getHelpText(), this.isHidden());
    }
}

