/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.parameters;

import qupath.lib.plugins.parameters.NumericParameter;
import qupath.lib.plugins.parameters.Parameter;

public class DoubleParameter
extends NumericParameter<Double> {
    private static final long serialVersionUID = 1L;

    DoubleParameter(String prompt, Double defaultValue, String unit, Double minValue, Double maxValue, Double lastValue, String helpText, boolean isHidden) {
        super(prompt, defaultValue, unit, minValue, maxValue, lastValue, helpText, isHidden);
    }

    DoubleParameter(String prompt, Double defaultValue, String unit, Double minValue, Double maxValue, String helpText) {
        super(prompt, defaultValue, unit, minValue, maxValue, helpText);
    }

    DoubleParameter(String prompt, Double defaultValue, String unit, String helpText) {
        super(prompt, defaultValue, unit, helpText);
    }

    @Override
    public boolean setValue(Double lastValue) {
        if (!this.isValidInput(lastValue)) {
            return false;
        }
        this.lastValue = lastValue;
        return true;
    }

    @Override
    public boolean setValueWithBoundsCheck(Double lastValue) {
        if (!this.isValidInput(lastValue)) {
            return false;
        }
        this.lastValue = Math.max(Math.min(lastValue, this.getUpperBound()), this.getLowerBound());
        return true;
    }

    @Override
    public boolean setDoubleLastValue(double val) {
        return this.setValue(val);
    }

    @Override
    public Parameter<Double> duplicate() {
        return new DoubleParameter(this.getPrompt(), (Double)this.getDefaultValue(), this.getUnit(), (Double)this.getLowerBound(), (Double)this.getUpperBound(), (Double)this.getValue(), this.getHelpText(), this.isHidden());
    }
}

