/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.parameters;

import qupath.lib.plugins.parameters.NumericParameter;
import qupath.lib.plugins.parameters.Parameter;

public class IntParameter
extends NumericParameter<Integer> {
    private static final long serialVersionUID = 1L;

    IntParameter(String prompt, Integer defaultValue, String unit, Double minValue, Double maxValue, Integer lastValue, String helpText, boolean isHidden) {
        super(prompt, defaultValue, unit, minValue, maxValue, lastValue, helpText, isHidden);
    }

    IntParameter(String prompt, Integer defaultValue, String unit, Double minValue, Double maxValue, String helpText) {
        this(prompt, defaultValue, unit, minValue, maxValue, null, helpText, false);
    }

    IntParameter(String prompt, Integer defaultValue, String unit, String helpText) {
        super(prompt, defaultValue, unit, helpText);
    }

    @Override
    public boolean setValue(Integer lastValue) {
        if (!this.isValidInput(lastValue)) {
            return false;
        }
        this.lastValue = lastValue;
        return true;
    }

    @Override
    public boolean setValueWithBoundsCheck(Integer lastValue) {
        if (!this.isValidInput(lastValue)) {
            return false;
        }
        this.lastValue = (int)Math.max(Math.min((double)lastValue.intValue(), this.getUpperBound()), this.getLowerBound());
        return true;
    }

    @Override
    public boolean setDoubleLastValue(double val) {
        return this.setValue((int)Math.round(val));
    }

    @Override
    public Parameter<Integer> duplicate() {
        return new IntParameter(this.getPrompt(), (Integer)this.getDefaultValue(), this.getUnit(), (Double)this.getLowerBound(), (Double)this.getUpperBound(), (Integer)this.lastValue, this.getHelpText(), this.isHidden());
    }
}

