/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.parameters;

import java.text.NumberFormat;
import java.util.Locale;
import qupath.lib.plugins.parameters.AbstractParameter;

public abstract class NumericParameter<S extends Number>
extends AbstractParameter<S> {
    private static final long serialVersionUID = 1L;
    private String unit = null;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    NumericParameter(String prompt, S defaultValue, String unit, double minValue, double maxValue, S lastValue, String helpText, boolean isHidden) {
        super(prompt, defaultValue, lastValue, helpText, isHidden);
        this.unit = unit;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    NumericParameter(String prompt, S defaultValue, String unit, double minValue, double maxValue, String helpText) {
        this(prompt, defaultValue, unit, minValue, maxValue, null, helpText, false);
    }

    NumericParameter(String prompt, S defaultValue, String unit, String helpText) {
        this(prompt, defaultValue, unit, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, helpText);
    }

    public boolean hasLowerAndUpperBounds() {
        return this.hasLowerBound() && this.hasUpperBound();
    }

    public boolean isUnbounded() {
        return !this.hasLowerBound() && !this.hasUpperBound();
    }

    public double getLowerBound() {
        return this.minValue;
    }

    public double getUpperBound() {
        return this.maxValue;
    }

    public void setRange(double minValue, double maxValue) {
        if (Double.isNaN(minValue)) {
            minValue = Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(maxValue)) {
            minValue = Double.POSITIVE_INFINITY;
        }
        if (!(minValue <= maxValue)) {
            throw new IllegalArgumentException("Invalid range set " + minValue + "-" + maxValue + ": minValue must be <= maxValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public boolean hasLowerBound() {
        return Math.abs(this.minValue) <= Double.MAX_VALUE;
    }

    public boolean hasUpperBound() {
        return Math.abs(this.maxValue) <= Double.MAX_VALUE;
    }

    public String getUnit() {
        return this.unit;
    }

    public abstract boolean setValueWithBoundsCheck(S var1);

    public abstract boolean setDoubleLastValue(double var1);

    @Override
    public boolean isValidInput(S value) {
        return !Double.isNaN(((Number)value).doubleValue());
    }

    @Override
    public boolean setStringLastValue(Locale locale, String value) {
        try {
            Number number = locale == null ? (Number)NumberFormat.getInstance(locale).parse(value) : (Number)NumberFormat.getInstance(locale).parse(value);
            return this.setDoubleLastValue(number.doubleValue());
        }
        catch (Exception number) {
            try {
                double d = Double.parseDouble(value);
                return this.setDoubleLastValue(d);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }
}

