/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.workflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import qupath.lib.common.GeneralTools;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.workflow.ScriptableWorkflowStep;

public class SimplePluginWorkflowStep
implements ScriptableWorkflowStep,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final String PROP_KEY_WORKFLOW_ARGS = "script.workflow.args";
    private static final String PROP_WORKFLOW_ARGS_MAP = "map";
    private static final String PROP_WORKFLOW_ARGS_STRING = "string";
    private String name;
    private String pluginClass;
    private String arg;
    private String scriptBefore;
    private String scriptAfter;

    public SimplePluginWorkflowStep() {
    }

    public SimplePluginWorkflowStep(String name, Class<? extends PathPlugin<?>> pluginClass, String arg) {
        this(name, pluginClass, arg, null, null);
    }

    public SimplePluginWorkflowStep(String name, Class<? extends PathPlugin<?>> pluginClass, String arg, String scriptBefore, String scriptAfter) {
        this.name = name;
        this.pluginClass = pluginClass.getName();
        this.arg = arg;
        this.scriptBefore = scriptBefore;
        this.scriptAfter = scriptAfter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    @Override
    public Map<String, ?> getParameterMap() {
        if (this.arg == null || this.arg.trim().length() == 0) {
            return Collections.emptyMap();
        }
        try {
            return GeneralTools.parseArgStringValues(this.arg);
        }
        catch (Exception e) {
            return Collections.singletonMap("Argument", this.arg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(this.pluginClass).append("  ").append(this.arg);
        return sb.toString();
    }

    @Override
    public String getScript() {
        StringBuilder sb = new StringBuilder();
        if (this.scriptBefore != null) {
            sb.append(this.scriptBefore);
        }
        String argString = this.getArgs();
        sb.append("runPlugin(").append("'").append(this.pluginClass).append("', ").append(argString).append(")");
        if (this.scriptAfter != null) {
            sb.append(this.scriptAfter);
        }
        return sb.toString();
    }

    private String getArgs() {
        if (this.arg == null || this.arg.isEmpty()) {
            return "''";
        }
        String prop = System.getProperty(PROP_KEY_WORKFLOW_ARGS, "script");
        switch (prop.toLowerCase()) {
            case "map": {
                if (this.arg == null) {
                    return "''";
                }
                if (this.arg.startsWith("{") && this.arg.endsWith("}") && !this.getParameterMap().isEmpty()) {
                    return "[" + this.arg.substring(1, this.arg.length() - 1) + "]";
                }
                return "'" + this.arg + "'";
            }
        }
        return "'" + this.arg + "'";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.name);
        out.writeObject(this.pluginClass);
        out.writeObject(this.arg);
        out.writeObject(this.scriptBefore);
        out.writeObject(this.scriptAfter);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int v = in.readInt();
        if (v != 1) {
            throw new IOException("Invalid version number " + v);
        }
        this.name = (String)in.readObject();
        this.pluginClass = (String)in.readObject();
        this.arg = (String)in.readObject();
        this.scriptBefore = (String)in.readObject();
        this.scriptAfter = (String)in.readObject();
    }
}

