/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.workflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.plugins.workflow.ScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowListener;
import qupath.lib.plugins.workflow.WorkflowStep;

public class Workflow
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Workflow.class);
    static int version = 1;
    private transient List<WorkflowListener> listeners = Collections.synchronizedList(new ArrayList());
    private List<WorkflowStep> steps = new ArrayList<WorkflowStep>();

    public List<WorkflowStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public WorkflowStep getLastStep() {
        return this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
    }

    public synchronized void addStep(WorkflowStep step) {
        this.steps.add(step);
        this.fireWorkflowUpdatedEvent();
    }

    public synchronized void addSteps(Collection<WorkflowStep> steps) {
        this.steps.addAll(steps);
        this.fireWorkflowUpdatedEvent();
    }

    public synchronized void removeStep(int ind) {
        if (this.steps.remove(ind) != null) {
            this.fireWorkflowUpdatedEvent();
        }
    }

    public synchronized void removeStep(WorkflowStep step) {
        if (this.steps.remove(step)) {
            this.fireWorkflowUpdatedEvent();
        }
    }

    public synchronized void removeSteps(Collection<WorkflowStep> steps) {
        if (this.steps.removeAll(steps)) {
            this.fireWorkflowUpdatedEvent();
        }
    }

    public synchronized void replaceLastStep(WorkflowStep step) {
        if (!this.steps.isEmpty()) {
            this.steps.remove(this.steps.size() - 1);
        }
        this.addStep(step);
    }

    public int size() {
        return this.steps.size();
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.steps.clear();
        this.fireWorkflowUpdatedEvent();
    }

    protected void fireWorkflowUpdatedEvent() {
        for (WorkflowListener listener : this.listeners) {
            listener.workflowUpdated(this);
        }
    }

    public void addWorkflowListener(WorkflowListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector<WorkflowListener>();
        }
        this.listeners.add(listener);
    }

    public void removeWorkflowListener(WorkflowListener listener) {
        this.listeners.remove(listener);
    }

    public String createScript() {
        StringBuilder sb = new StringBuilder();
        for (WorkflowStep step : this.steps) {
            if (step instanceof ScriptableWorkflowStep) {
                sb.append(((ScriptableWorkflowStep)step).getScript());
            } else {
                sb.append("// ").append(step.getName()).append(" is not scriptable");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(version);
        out.writeInt(this.steps.size());
        for (WorkflowStep step : this.steps) {
            out.writeObject(step);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1) {
            logger.error(this.getClass().getSimpleName() + " unsupported version number " + version);
        }
        int nSteps = in.readInt();
        this.steps = new ArrayList<WorkflowStep>(nSteps * 2);
        for (int i = 0; i < nSteps; ++i) {
            try {
                WorkflowStep step = (WorkflowStep)in.readObject();
                this.steps.add(step);
                logger.trace(step.toString());
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.error("Cannot load workflow step - {}", (Object)e.getMessage());
            }
        }
    }
}

