/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.regions;

public class Padding {
    private final int x1;
    private final int x2;
    private final int y1;
    private final int y2;
    private static Padding[] symmetric = new Padding[65];

    public int getX1() {
        return this.x1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getXSum() {
        return this.getX1() + this.getX2();
    }

    public int getY1() {
        return this.y1;
    }

    public int getY2() {
        return this.y2;
    }

    public int getYSum() {
        return this.getY1() + this.getY2();
    }

    public String toString() {
        return String.format("Padding (x=[%d, %d], y=[%d, %d])", this.getX1(), this.getX2(), this.getY1(), this.getY2());
    }

    public boolean isSymmetric() {
        return this.x1 == this.x2 && this.x2 == this.y1 && this.y1 == this.y2;
    }

    public boolean isEmpty() {
        return this.x1 == 0 && this.isSymmetric();
    }

    public Padding add(Padding padding) {
        if (this.isEmpty()) {
            return padding;
        }
        if (padding.isEmpty()) {
            return this;
        }
        return Padding.getPadding(this.x1 + padding.x1, this.x2 + padding.x2, this.y1 + padding.y1, this.y2 + padding.y2);
    }

    public Padding subtract(Padding padding) {
        if (this.isEmpty()) {
            return padding;
        }
        if (padding.isEmpty()) {
            return this;
        }
        return Padding.getPadding(this.x1 - padding.x1, this.x2 - padding.x2, this.y1 - padding.y1, this.y2 - padding.y2);
    }

    public Padding max(Padding padding) {
        if (this.isEmpty()) {
            return padding;
        }
        if (padding.isEmpty()) {
            return this;
        }
        return Padding.getPadding(Math.max(this.x1, padding.x1), Math.max(this.x2, padding.x2), Math.max(this.y1, padding.y1), Math.max(this.y2, padding.y2));
    }

    private Padding(int x1, int x2, int y1, int y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        if (x1 < 0 || x2 < 0 || y1 < 0 || y2 < 0) {
            throw new IllegalArgumentException("Padding must be >= 0! Requested " + this.toString());
        }
    }

    private Padding(int pad) {
        this(pad, pad, pad, pad);
    }

    public static Padding symmetric(int pad) {
        if (pad < symmetric.length) {
            return symmetric[pad];
        }
        return new Padding(pad);
    }

    public static Padding getPadding(int x, int y) {
        if (x == y) {
            return Padding.symmetric(x);
        }
        return Padding.getPadding(x, x, y, y);
    }

    public static Padding empty() {
        return symmetric[0];
    }

    public static Padding getPadding(int x1, int x2, int y1, int y2) {
        if (x1 == x2 && x1 == y1 && x1 == y2) {
            return Padding.symmetric(x1);
        }
        return new Padding(x1, x2, y1, y2);
    }

    static {
        for (int i = 0; i < symmetric.length; ++i) {
            Padding.symmetric[i] = new Padding(i);
        }
    }
}

