/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.regions;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.Padding;
import qupath.lib.roi.interfaces.ROI;

public class RegionRequest
extends ImageRegion {
    private static final Logger logger = LoggerFactory.getLogger(RegionRequest.class);
    private static DecimalFormat df = new DecimalFormat("#.##");
    private static Map<String, String> strings = new HashMap<String, String>();
    private final String path;
    private final double downsample;

    @Override
    public String toString() {
        String prefix = this.path;
        return prefix + ": x=" + this.getX() + ", y=" + this.getY() + ", w=" + this.getWidth() + ", h=" + this.getHeight() + ", z=" + this.getZ() + ", t=" + this.getT() + ", downsample=" + df.format(this.downsample);
    }

    RegionRequest(String path, double downsample, int x, int y, int width, int height, int z, int t) {
        super(x, y, width, height, z, t);
        String interned = strings.putIfAbsent(path, path);
        if (interned == null) {
            interned = path;
        }
        this.path = path;
        if (!Double.isFinite(downsample)) {
            logger.warn("Invalid downsample value {}! This will be an error in future versions.", (Object)downsample);
        }
        this.downsample = downsample;
    }

    public static RegionRequest createInstance(ImageServer<?> server) {
        return RegionRequest.createInstance(server, server.getDownsampleForResolution(0));
    }

    public static RegionRequest createInstance(ImageServer<?> server, double downsample) {
        return RegionRequest.createInstance(server.getPath(), downsample, 0, 0, server.getWidth(), server.getHeight());
    }

    public static List<RegionRequest> createAllRequests(ImageServer<?> server, double downsample) {
        ArrayList<RegionRequest> requests = new ArrayList<RegionRequest>();
        for (int t = 0; t < server.nTimepoints(); ++t) {
            for (int z = 0; z < server.nZSlices(); ++z) {
                requests.add(RegionRequest.createInstance(server.getPath(), downsample, 0, 0, server.getWidth(), server.getHeight(), z, t));
            }
        }
        return requests;
    }

    public static RegionRequest createInstance(String path, double downsample, ROI roi) {
        return RegionRequest.createInstance(path, downsample, ImageRegion.createInstance(roi));
    }

    public static RegionRequest createInstance(String path, double downsample, Collection<? extends ROI> rois) {
        return RegionRequest.createInstance(path, downsample, ImageRegion.createInstance(rois));
    }

    public static RegionRequest createInstance(String path, RegionRequest request) {
        return RegionRequest.createInstance(path, request.getDownsample(), request);
    }

    public static RegionRequest createInstance(String path, double downsample, ImageRegion region) {
        return new RegionRequest(path, downsample, region.getX(), region.getY(), region.getWidth(), region.getHeight(), region.getZ(), region.getT());
    }

    public static RegionRequest createInstance(String path, double downsample, int x, int y, int width, int height, int z, int t) {
        return new RegionRequest(path, downsample, x, y, width, height, z, t);
    }

    public static RegionRequest createInstance(String path, double downsample, int x, int y, int width, int height, ImagePlane plane) {
        return new RegionRequest(path, downsample, x, y, width, height, plane.getZ(), plane.getT());
    }

    public static RegionRequest createInstance(String path, double downsample, int x, int y, int width, int height) {
        return RegionRequest.createInstance(path, downsample, x, y, width, height, 0, 0);
    }

    public boolean overlapsRequest(RegionRequest request) {
        if (this.path.equals(request.getPath())) {
            return this.path.equals(request.getPath()) && super.intersects(request);
        }
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public double getDownsample() {
        return this.downsample;
    }

    public RegionRequest intersect2D(ImageRegion region) {
        if (this.getX() >= region.getX() && this.getY() >= region.getY() && this.getMaxY() <= region.getMaxY() && this.getMaxX() <= region.getMaxX()) {
            return this;
        }
        int x = Math.max(this.getMinX(), region.getMinX());
        int y = Math.max(this.getMinY(), region.getMinY());
        int x2 = Math.min(this.getMaxX(), region.getMaxX());
        int y2 = Math.min(this.getMaxY(), region.getMaxY());
        return RegionRequest.createInstance(this.getPath(), this.getDownsample(), x, y, Math.max(x2 - x, 0), Math.max(y2 - y, 0), this.getZ(), this.getT());
    }

    public RegionRequest intersect2D(int x, int y, int width, int height) {
        return this.intersect2D(ImageRegion.createInstance(x, y, width, height, this.getZ(), this.getT()));
    }

    public RegionRequest updateZ(int z) {
        if (this.getZ() == z) {
            return this;
        }
        return RegionRequest.createInstance(this.getPath(), this.getDownsample(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), z, this.getT());
    }

    public RegionRequest updateT(int t) {
        if (this.getT() == t) {
            return this;
        }
        return RegionRequest.createInstance(this.getPath(), this.getDownsample(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getZ(), t);
    }

    public RegionRequest updateDownsample(double downsample) {
        if (this.getDownsample() == downsample) {
            return this;
        }
        return RegionRequest.createInstance(this.getPath(), downsample, this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getZ(), this.getT());
    }

    public RegionRequest updatePath(String path) {
        Objects.requireNonNull(path);
        if (this.getPath().equals(path)) {
            return this;
        }
        return RegionRequest.createInstance(path, this.getDownsample(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getZ(), this.getT());
    }

    public RegionRequest translate(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return this;
        }
        return RegionRequest.createInstance(this.path, this.getDownsample(), this.getX() + dx, this.getY() + dy, this.getWidth(), this.getHeight(), this.getZ(), this.getT());
    }

    public RegionRequest pad2D(int xPad, int yPad) {
        if (xPad == 0 && yPad == 0) {
            return this;
        }
        return RegionRequest.createInstance(this.getPath(), this.getDownsample(), this.getX() - xPad, this.getY() - yPad, this.getWidth() + xPad * 2, this.getHeight() + yPad * 2, this.getZ(), this.getT());
    }

    public RegionRequest pad2D(Padding padding) {
        if (padding.isEmpty()) {
            return this;
        }
        return RegionRequest.createInstance(this.getPath(), this.getDownsample(), this.getX() - padding.getX1(), this.getY() - padding.getY1(), this.getWidth() + padding.getXSum(), this.getHeight() + padding.getYSum(), this.getZ(), this.getT());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.downsample);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionRequest other = (RegionRequest)obj;
        if (Double.doubleToLongBits(this.downsample) != Double.doubleToLongBits(other.downsample)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

