/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import org.locationtech.jts.geom.Geometry;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.interfaces.ROI;

abstract class AbstractPathROI
implements ROI {
    int c = -1;
    int t = 0;
    int z = 0;
    private transient ImagePlane plane;
    private transient int nPoints = -1;
    private static GeometryTools.GeometryConverter converter = new GeometryTools.GeometryConverter.Builder().build();

    public AbstractPathROI() {
        this(null);
    }

    public AbstractPathROI(ImagePlane plane) {
        if (plane == null) {
            plane = ImagePlane.getDefaultPlane();
        }
        this.c = plane.getC();
        this.z = plane.getZ();
        this.t = plane.getT();
    }

    @Override
    public ImagePlane getImagePlane() {
        if (this.plane == null) {
            this.plane = ImagePlane.getPlaneWithChannel(this.c, this.z, this.t);
        }
        return this.plane;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public int getT() {
        return this.t;
    }

    @Override
    public int getC() {
        return this.c;
    }

    @Override
    public boolean isEmpty() {
        int n = this.getNumPoints();
        if (n == 0) {
            return true;
        }
        if (this.isArea()) {
            return this.getArea() == 0.0;
        }
        if (this.isLine()) {
            return this.getLength() == 0.0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getRoiName()).append(" (").append(Math.round(this.getBoundsX())).append(", ").append(Math.round(this.getBoundsY())).append(", ").append(Math.round(this.getBoundsWidth())).append(", ").append(Math.round(this.getBoundsHeight()));
        if (this.getZ() != 0) {
            sb.append(", z=").append(this.getZ());
        }
        if (this.getT() != 0) {
            sb.append(", t=").append(this.getT());
        }
        if (this.getC() != -1) {
            sb.append(", c=").append(this.getC());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int getNumPoints() {
        if (this.nPoints < 0) {
            this.nPoints = this.getAllPoints().size();
        }
        return this.nPoints;
    }

    @Override
    public boolean isLine() {
        return this.getRoiType() == ROI.RoiType.LINE;
    }

    @Override
    public boolean isArea() {
        return this.getRoiType() == ROI.RoiType.AREA;
    }

    @Override
    public boolean isPoint() {
        return this.getRoiType() == ROI.RoiType.POINT;
    }

    @Override
    public Geometry getGeometry() {
        return converter.roiToGeometry(this);
    }

    @Override
    public double getArea() {
        return this.getScaledArea(1.0, 1.0);
    }

    @Override
    public double getLength() {
        return this.getScaledLength(1.0, 1.0);
    }

    @Override
    public ROI getConvexHull() {
        return GeometryTools.geometryToROI(this.getGeometry().convexHull(), this.getImagePlane());
    }

    @Override
    public double getSolidity() {
        return this.isArea() ? this.getArea() / this.getConvexHull().getArea() : Double.NaN;
    }
}

