/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import qupath.lib.roi.Vertices;

class ClosedShapeStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double areaCached = Double.NaN;
    private double perimeterCached = Double.NaN;
    private float centroidXCached = Float.NaN;
    private float centroidYCached = Float.NaN;
    private double minX = Double.NaN;
    private double maxX = Double.NaN;
    private double minY = Double.NaN;
    private double maxY = Double.NaN;
    private int nVertices = 0;

    public ClosedShapeStatistics(Vertices vertices) {
        this(vertices, 1.0, 1.0);
    }

    public ClosedShapeStatistics(List<? extends Vertices> vertices) {
        this(vertices, 1.0, 1.0);
    }

    public ClosedShapeStatistics(Vertices vertices, double pixelWidth, double pixelHeight) {
        this(Collections.singletonList(vertices), pixelWidth, pixelHeight);
    }

    public ClosedShapeStatistics(List<? extends Vertices> verticesList, double pixelWidth, double pixelHeight) {
        if (verticesList.isEmpty()) {
            return;
        }
        Path2D.Float path = new Path2D.Float();
        for (Vertices vertices : verticesList) {
            if (vertices.isEmpty()) continue;
            ((Path2D)path).moveTo(vertices.getX(0), vertices.getY(0));
            for (int i = 1; i < vertices.size(); ++i) {
                ((Path2D)path).lineTo(vertices.getX(i), vertices.getY(i));
            }
            path.closePath();
        }
        this.calculateShapeMeasurements(path, pixelWidth, pixelHeight);
    }

    @Deprecated
    ClosedShapeStatistics(Shape shape) {
        this(shape, 1.0, 1.0);
    }

    @Deprecated
    ClosedShapeStatistics(Shape shape, double pixelWidth, double pixelHeight) {
        this.calculateShapeMeasurements(shape, pixelWidth, pixelHeight);
    }

    private void calculateShapeMeasurements(Shape shape, double pixelWidth, double pixelHeight) {
        Area area;
        double perimeter = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        double areaTempSigned = 0.0;
        double areaCached = 0.0;
        double flatness = 0.01;
        PathIterator iter = shape instanceof Area ? ((Area)shape).getPathIterator(null, flatness) : ((area = new Area(shape)).isEmpty() ? shape.getPathIterator(null, flatness) : area.getPathIterator(null, flatness));
        double[] seg = new double[6];
        double startX = Double.NaN;
        double startY = Double.NaN;
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        int nPaths = 0;
        block5: while (!iter.isDone()) {
            switch (iter.currentSegment(seg)) {
                case 0: {
                    startX = seg[0] * pixelWidth;
                    startY = seg[1] * pixelHeight;
                    x0 = startX;
                    y0 = startY;
                    this.updateMinMax(x0, y0);
                    iter.next();
                    ++nPaths;
                    areaCached += areaTempSigned;
                    areaTempSigned = 0.0;
                    ++this.nVertices;
                    continue block5;
                }
                case 4: {
                    x1 = startX;
                    y1 = startY;
                    break;
                }
                case 1: {
                    x1 = seg[0] * pixelWidth;
                    y1 = seg[1] * pixelHeight;
                    this.updateMinMax(x1, y1);
                    ++this.nVertices;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid polygon in " + String.valueOf(this) + " - only line connections are allowed");
                }
            }
            perimeter += Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
            cx += (x0 + x1) * (x0 * y1 - x1 * y0);
            cy += (y0 + y1) * (x0 * y1 - x1 * y0);
            areaTempSigned += 0.5 * (x0 * y1 - x1 * y0);
            x0 = x1;
            y0 = y1;
            iter.next();
        }
        if (nPaths == 1) {
            this.centroidXCached = (float)(cx / (6.0 * areaTempSigned));
            this.centroidYCached = (float)(cy / (6.0 * areaTempSigned));
            this.perimeterCached = perimeter;
        } else {
            this.centroidXCached = (float)(cx / (6.0 * (areaCached + areaTempSigned)));
            this.centroidYCached = (float)(cy / (6.0 * (areaCached + areaTempSigned)));
            this.perimeterCached = Double.NaN;
        }
        this.areaCached = Math.abs(areaCached + areaTempSigned);
        Rectangle2D bounds = shape.getBounds2D();
        if (pixelWidth != 1.0 || pixelHeight != 1.0) {
            bounds.setFrame(bounds.getX() * pixelWidth, bounds.getY() * pixelHeight, bounds.getWidth() * pixelWidth, bounds.getHeight() * pixelHeight);
        }
        assert (this.areaCached <= bounds.getWidth() * bounds.getHeight());
        assert (bounds.contains(this.centroidXCached, this.centroidYCached));
    }

    public final double getBoundsX() {
        return this.minX;
    }

    public final double getBoundsY() {
        return this.minY;
    }

    public final double getBoundsWidth() {
        return this.maxX - this.minX;
    }

    public final double getBoundsHeight() {
        return this.maxY - this.minY;
    }

    private final void updateMinMax(double x, double y) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
    }

    public final double getCentroidX() {
        return this.centroidXCached;
    }

    public final double getCentroidY() {
        return this.centroidYCached;
    }

    public final double getArea() {
        return this.areaCached;
    }

    public final double getPerimeter() {
        return this.perimeterCached;
    }

    public final int getNVertices() {
        return this.nVertices;
    }
}

