/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.Point2;

public class ConvexHull {
    private static final Logger logger = LoggerFactory.getLogger(ConvexHull.class);

    public static List<Point2> getConvexHull(List<Point2> points) {
        Point2 endPoint;
        if (points == null || points.isEmpty()) {
            return null;
        }
        Point2 pointOnHull = points.get(0);
        for (Point2 p : points) {
            if (!(p.getX() < pointOnHull.getX())) continue;
            pointOnHull = p;
        }
        ArrayList<Point2> hull = new ArrayList<Point2>(points.size());
        do {
            hull.add(pointOnHull);
            endPoint = points.get(0);
            double dx = endPoint.getX() - pointOnHull.getX();
            double dy = endPoint.getY() - pointOnHull.getY();
            for (Point2 s : points) {
                double sx = s.getX() - pointOnHull.getX();
                double sy = s.getY() - pointOnHull.getY();
                if (!endPoint.equals(pointOnHull) && !(sx * dy - sy * dx > 0.0)) continue;
                endPoint = s;
                dx = sx;
                dy = sy;
            }
            pointOnHull = endPoint;
        } while (!endPoint.equals(hull.get(0)));
        logger.trace("Original points: {}, Convex hull points: {}", (Object)points.size(), (Object)hull.size());
        return hull;
    }
}

