/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.util.Comparator;
import java.util.List;
import qupath.lib.geom.Point2;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.AreaROI;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

public class DefaultROIComparator
implements Comparator<ROI> {
    private static final DefaultROIComparator instance = new DefaultROIComparator();

    @Override
    public int compare(ROI o1, ROI o2) {
        int size;
        AbstractPathROI r2;
        AbstractPathROI r1;
        double v2;
        int i2;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        int i1 = o1.getT();
        int temp = Double.compare(i1, i2 = o2.getT());
        if (temp != 0) {
            return temp;
        }
        i1 = o1.getZ();
        temp = Double.compare(i1, i2 = o2.getZ());
        if (temp != 0) {
            return temp;
        }
        i1 = o1.getC();
        temp = Double.compare(i1, i2 = o2.getC());
        if (temp != 0) {
            return temp;
        }
        double v1 = o1.getCentroidY();
        temp = Double.compare(v1, v2 = o2.getCentroidY());
        if (temp != 0) {
            return temp;
        }
        v1 = o1.getCentroidX();
        temp = Double.compare(v1, v2 = o2.getCentroidX());
        if (temp != 0) {
            return temp;
        }
        v1 = o1.getBoundsX();
        temp = Double.compare(v1, v2 = o2.getBoundsX());
        if (temp != 0) {
            return temp;
        }
        v1 = o1.getBoundsY();
        temp = Double.compare(v1, v2 = o2.getBoundsY());
        if (temp != 0) {
            return temp;
        }
        v1 = o1.getBoundsWidth();
        temp = Double.compare(v1, v2 = o2.getBoundsWidth());
        if (temp != 0) {
            return temp;
        }
        v1 = o1.getBoundsHeight();
        temp = Double.compare(v1, v2 = o2.getBoundsHeight());
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1 instanceof RectangleROI, o2 instanceof RectangleROI);
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1 instanceof EllipseROI, o2 instanceof EllipseROI);
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1 instanceof PolygonROI, o2 instanceof PolygonROI);
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1 instanceof AreaROI, o2 instanceof AreaROI);
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1 instanceof LineROI, o2 instanceof LineROI);
        if (temp != 0) {
            return temp;
        }
        temp = -Boolean.compare(o1 instanceof PointsROI, o2 instanceof PointsROI);
        if (temp != 0) {
            return temp;
        }
        temp = o1.getClass().getName().compareTo(o2.getClass().getName());
        if (temp != 0) {
            return temp;
        }
        if (o1 instanceof LineROI && o2 instanceof LineROI) {
            LineROI r12 = (LineROI)o1;
            LineROI r22 = (LineROI)o2;
            v1 = r12.getY1();
            temp = Double.compare(v1, v2 = r22.getY1());
            if (temp != 0) {
                return temp;
            }
            v1 = r12.getX1();
            temp = Double.compare(v1, v2 = r22.getX1());
            if (temp != 0) {
                return temp;
            }
            v1 = r12.getY2();
            temp = Double.compare(v1, v2 = r22.getY2());
            if (temp != 0) {
                return temp;
            }
            v1 = r12.getX2();
            v2 = r22.getX2();
            return Double.compare(v1, v2);
        }
        if (o1 instanceof PointsROI && o2 instanceof PointsROI) {
            r1 = (PointsROI)o1;
            r2 = (PointsROI)o2;
            size = Integer.compare(((PointsROI)r1).getNumPoints(), ((PointsROI)r2).getNumPoints());
            if (size != 0) {
                return size;
            }
        }
        if (o1 instanceof PolygonROI && o2 instanceof PolygonROI) {
            r1 = (PolygonROI)o1;
            r2 = (PolygonROI)o2;
            size = Integer.compare(((PolygonROI)r1).nVertices(), ((PolygonROI)r2).nVertices());
            if (size != 0) {
                return size;
            }
        }
        if (o1 instanceof AreaROI && o2 instanceof AreaROI) {
            r1 = (AreaROI)o1;
            r2 = (AreaROI)o2;
            size = Integer.compare(((AreaROI)r1).nVertices(), ((AreaROI)r2).nVertices());
            if (size != 0) {
                return size;
            }
        }
        List<Point2> points1 = o1.getAllPoints();
        List<Point2> points2 = o2.getAllPoints();
        size = Integer.compare(points1.size(), points2.size());
        if (size != 0) {
            return size;
        }
        for (int i = 0; i < points1.size(); ++i) {
            Point2 p1 = points1.get(i);
            Point2 p2 = points2.get(i);
            temp = Double.compare(p1.getY(), p2.getY());
            if (temp != 0) {
                return temp;
            }
            temp = Double.compare(p1.getX(), p2.getX());
            if (temp == 0) continue;
            return temp;
        }
        return 0;
    }

    public static Comparator<ROI> getInstance() {
        return instance;
    }
}

